/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.InvalidTransitionException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.common.SystemKey;
import org.cristalise.kernel.entity.ItemOperations;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.entity.agent.JobArrayList;
import org.cristalise.kernel.events.Event;
import org.cristalise.kernel.events.History;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.Workflow;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStepContainer;
import org.cristalise.kernel.lifecycle.instance.predefined.item.ItemPredefinedStepContainer;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.InvalidAgentPathException;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionManager;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyArrayList;
import org.cristalise.kernel.scripting.ErrorInfo;
import org.cristalise.kernel.security.SecurityManager;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemImplementation
implements ItemOperations {
    private static final Logger log = LoggerFactory.getLogger(ItemImplementation.class);
    protected final TransactionManager mStorage = Gateway.getStorage();
    protected final ItemPath mItemPath;

    protected ItemImplementation(ItemPath key) {
        this.mItemPath = key;
    }

    public SystemKey getSystemKey() {
        return this.mItemPath.getSystemKey();
    }

    public UUID getUUID() {
        return this.mItemPath.getUUID();
    }

    public void initialise(SystemKey agentId, String propString, String initWfString, String initCollsString, String initViewpointString, String initOutcomeString) throws AccessRightsException, InvalidDataException, PersistencyException {
        AgentPath agentPath;
        log.debug("initialise(" + this.mItemPath + ") - agent:" + agentId);
        Object locker = new Object();
        try {
            agentPath = new AgentPath(agentId);
        }
        catch (InvalidItemPathException e) {
            throw new AccessRightsException("Invalid Agent Id:" + agentId);
        }
        if (StringUtils.isBlank((CharSequence)propString) || propString.equals("<NULL/>")) {
            throw new InvalidDataException("No properties supplied");
        }
        try {
            PropertyArrayList props = (PropertyArrayList)Gateway.getMarshaller().unmarshall(propString);
            for (Property thisProp : props.list) {
                this.mStorage.put(this.mItemPath, thisProp, locker);
            }
        }
        catch (Exception ex) {
            log.error("initialise({}) - Properties were invalid: {}", new Object[]{this.mItemPath, propString, ex});
            this.mStorage.abort(locker);
            throw new InvalidDataException("Properties were invalid");
        }
        History hist = new History(this.mItemPath, locker);
        try {
            Schema initSchema = LocalObjectLoader.getSchema("ItemInitialization", 0);
            Outcome initOutcome = new Outcome(0, propString, initSchema);
            Event newEvent = hist.addEvent(new AgentPath(agentId), null, "", "Initialize", "", "", initSchema, LocalObjectLoader.getStateMachine("PredefinedStep", 0), 0, "last");
            initOutcome.setID(newEvent.getID());
            Viewpoint newLastView = new Viewpoint(this.mItemPath, initSchema, "last", newEvent.getID());
            this.mStorage.put(this.mItemPath, initOutcome, locker);
            this.mStorage.put(this.mItemPath, newLastView, locker);
        }
        catch (Exception ex) {
            log.error("initialise({}) - Could not store event and outcome.", (Object)this.mItemPath, (Object)ex);
            this.mStorage.abort(locker);
            throw new PersistencyException("Error storing 'Initialize' event and outcome:" + ex.getMessage());
        }
        if (StringUtils.isNotBlank((CharSequence)initViewpointString)) {
            try {
                Viewpoint vp = (Viewpoint)Gateway.getMarshaller().unmarshall(initViewpointString);
                Schema schema = LocalObjectLoader.getSchema(vp.getSchemaName(), vp.getSchemaVersion());
                Outcome outcome = new Outcome(-1, initOutcomeString, schema);
                outcome.validateAndCheck();
                vp.setItemPath(this.mItemPath);
                Event newEvent = hist.addEvent(new AgentPath(agentId), null, "", "Constructor", "", "", schema, LocalObjectLoader.getStateMachine("PredefinedStep", 0), 0, vp.getName());
                vp.setEventId(newEvent.getID());
                outcome.setID(newEvent.getID());
                this.mStorage.put(this.mItemPath, outcome, locker);
                this.mStorage.put(this.mItemPath, vp, locker);
            }
            catch (Exception ex) {
                log.error("initialise({}) - Could not store event and outcome.", (Object)this.mItemPath, (Object)ex);
                this.mStorage.abort(locker);
                throw new PersistencyException("Error storing 'Constructor event and outcome:" + ex.getMessage());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)initCollsString) && !initCollsString.equals("<NULL/>")) {
            try {
                CollectionArrayList colls = (CollectionArrayList)Gateway.getMarshaller().unmarshall(initCollsString);
                for (Collection thisColl : colls.list) {
                    this.mStorage.put(this.mItemPath, thisColl, locker);
                }
            }
            catch (Exception ex) {
                log.error("initialise(" + this.mItemPath + ") - Collections were invalid: " + initCollsString, (Throwable)ex);
                this.mStorage.abort(locker);
                throw new InvalidDataException("Collections were invalid");
            }
        }
        Workflow lc = null;
        try {
            lc = StringUtils.isBlank((CharSequence)initWfString) || initWfString.equals("<NULL/>") ? new Workflow(new CompositeActivity(), this.getNewPredefStepContainer()) : new Workflow((CompositeActivity)Gateway.getMarshaller().unmarshall(initWfString), this.getNewPredefStepContainer());
            this.mStorage.put(this.mItemPath, lc, locker);
        }
        catch (Exception ex) {
            log.error("initialise(" + this.mItemPath + ") - Workflow was invalid: " + initWfString, (Throwable)ex);
            this.mStorage.abort(locker);
            throw new InvalidDataException("Workflow was invalid");
        }
        lc.initialise(this.mItemPath, agentPath, locker);
        this.mStorage.put(this.mItemPath, lc, locker);
        this.mStorage.commit(locker);
        log.info("Initialisation of item " + this.mItemPath + " was successful");
    }

    protected PredefinedStepContainer getNewPredefStepContainer() {
        return new ItemPredefinedStepContainer();
    }

    public String requestAction(SystemKey agentId, String stepPath, int transitionID, String requestData, String attachmentType, byte[] attachment) throws AccessRightsException, InvalidTransitionException, ObjectNotFoundException, InvalidDataException, PersistencyException, ObjectAlreadyExistsException, InvalidCollectionModification {
        return this.delegatedAction(agentId, null, stepPath, transitionID, requestData, attachmentType, attachment);
    }

    public String delegatedAction(SystemKey agentId, SystemKey delegateId, String stepPath, int transitionID, String requestData, String attachmentType, byte[] attachment) throws AccessRightsException, InvalidTransitionException, ObjectNotFoundException, InvalidDataException, PersistencyException, ObjectAlreadyExistsException, InvalidCollectionModification {
        Workflow lifeCycle = null;
        try {
            AgentPath agent = new AgentPath(agentId);
            AgentPath delegate = delegateId == null ? null : new AgentPath(delegateId);
            AgentPath agentToUse = delegate == null ? agent : delegate;
            log.info("request(" + this.mItemPath + ") Transition " + transitionID + " on " + stepPath + " by " + (delegate == null ? "" : delegate + " on behalf of ") + agent);
            lifeCycle = (Workflow)this.mStorage.get(this.mItemPath, (Object)((Object)ClusterType.LIFECYCLE) + "/workflow", null);
            SecurityManager secMan = Gateway.getSecurityManager();
            if (secMan.isShiroEnabled() && !secMan.checkPermissions(agentToUse, (Activity)lifeCycle.search(stepPath), this.mItemPath)) {
                for (RolePath role : agent.getRoles()) {
                    log.error(role.dump());
                }
                throw new AccessRightsException("'" + agentToUse.getAgentName() + "' is NOT permitted to execute step:" + stepPath);
            }
            String finalOutcome = lifeCycle.requestAction(agent, delegate, stepPath, this.mItemPath, transitionID, requestData, attachmentType, attachment);
            if (!stepPath.startsWith("workflow/predefined")) {
                this.mStorage.put(this.mItemPath, lifeCycle, lifeCycle);
            }
            if (stepPath.equals("workflow/predefined/Erase")) {
                log.info("Erasing item path " + this.mItemPath.toString());
                Gateway.getLookupManager().delete(this.mItemPath);
            }
            this.mStorage.commit(lifeCycle);
            return finalOutcome;
        }
        catch (AccessRightsException | InvalidCollectionModification | InvalidDataException | InvalidTransitionException | ObjectAlreadyExistsException | ObjectNotFoundException | PersistencyException ex) {
            log.error("", ex);
            String errorOutcome = this.handleError(agentId, delegateId, stepPath, lifeCycle, (Exception)ex);
            if (StringUtils.isBlank((CharSequence)errorOutcome)) {
                this.mStorage.abort(lifeCycle);
                throw ex;
            }
            this.mStorage.commit(lifeCycle);
            return errorOutcome;
        }
        catch (CannotManageException | ObjectCannotBeUpdated | InvalidAgentPathException ex) {
            log.error("", ex);
            String errorOutcome = this.handleError(agentId, delegateId, stepPath, lifeCycle, (Exception)ex);
            if (StringUtils.isBlank((CharSequence)errorOutcome)) {
                this.mStorage.abort(lifeCycle);
                throw new InvalidDataException(ex.getClass().getName() + " - " + ex.getMessage());
            }
            this.mStorage.commit(lifeCycle);
            return errorOutcome;
        }
        catch (Exception ex) {
            log.error("Unknown Error: requestAction on " + this.mItemPath + " by " + agentId + " executing " + stepPath, (Throwable)ex);
            String errorOutcome = this.handleError(agentId, delegateId, stepPath, lifeCycle, ex);
            if (StringUtils.isBlank((CharSequence)errorOutcome)) {
                this.mStorage.abort(lifeCycle);
                throw new InvalidDataException("Extraordinary Exception during execution:" + ex.getClass().getName() + " - " + ex.getMessage());
            }
            this.mStorage.commit(lifeCycle);
            return errorOutcome;
        }
    }

    private String handleError(SystemKey agentId, SystemKey delegateId, String stepPath, Workflow lifeCycle, Exception ex) throws PersistencyException, ObjectNotFoundException, AccessRightsException, InvalidTransitionException, InvalidDataException, ObjectAlreadyExistsException, InvalidCollectionModification {
        if (!Gateway.getProperties().getBoolean("StateMachine.enableErrorHandling", false)) {
            return null;
        }
        int errorTransId = ((Activity)lifeCycle.search(stepPath)).getErrorTransitionId();
        if (errorTransId == -1) {
            return null;
        }
        try {
            AgentPath agent = new AgentPath(agentId);
            AgentPath delegate = delegateId == null ? null : new AgentPath(delegateId);
            String errorOutcome = Gateway.getMarshaller().marshall(new ErrorInfo(ex));
            lifeCycle.requestAction(agent, delegate, stepPath, this.mItemPath, errorTransId, errorOutcome, "", null);
            if (!stepPath.startsWith("workflow/predefined")) {
                this.mStorage.put(this.mItemPath, lifeCycle, lifeCycle);
            }
            return errorOutcome;
        }
        catch (IOException | CannotManageException | ObjectCannotBeUpdated | InvalidAgentPathException | MappingException | MarshalException | ValidationException e) {
            log.error("", e);
            return "";
        }
    }

    public String queryLifeCycle(SystemKey agentId, boolean filter) throws AccessRightsException, ObjectNotFoundException, PersistencyException {
        log.info("queryLifeCycle(" + this.mItemPath + ") - agent: " + agentId);
        try {
            AgentPath agent;
            try {
                agent = new AgentPath(agentId);
            }
            catch (InvalidItemPathException e) {
                throw new AccessRightsException("Agent " + agentId + " doesn't exist");
            }
            Workflow wf = (Workflow)this.mStorage.get(this.mItemPath, (Object)((Object)ClusterType.LIFECYCLE) + "/workflow", null);
            JobArrayList jobBag = new JobArrayList();
            CompositeActivity domainWf = (CompositeActivity)wf.search("workflow/domain");
            ArrayList<Job> jobs = filter ? domainWf.calculateJobs(agent, this.mItemPath, true) : domainWf.calculateAllJobs(agent, this.mItemPath, true);
            SecurityManager secMan = Gateway.getSecurityManager();
            if (secMan.isShiroEnabled()) {
                for (Job j : jobs) {
                    Activity act = (Activity)wf.search(j.getStepPath());
                    if (!secMan.checkPermissions(agent, act, this.mItemPath)) continue;
                    try {
                        j.getTransition().getPerformingRole(act, agent);
                        jobBag.list.add(j);
                    }
                    catch (AccessRightsException accessRightsException) {}
                }
            } else {
                jobBag.list = jobs;
            }
            log.info("queryLifeCycle(" + this.mItemPath + ") - Returning " + jobBag.list.size() + " jobs.");
            try {
                return Gateway.getMarshaller().marshall(jobBag);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                throw new PersistencyException("Error marshalling job bag");
            }
        }
        catch (AccessRightsException | ObjectNotFoundException | PersistencyException e) {
            log.error("", e);
            throw e;
        }
        catch (Exception ex) {
            log.error("queryLifeCycle(" + this.mItemPath + ") - Unknown error", (Throwable)ex);
            throw new PersistencyException("Unknown error querying jobs. Please see server log.");
        }
    }

    public String queryData(String path) throws AccessRightsException, ObjectNotFoundException, PersistencyException {
        String result = "";
        log.info("queryData(" + this.mItemPath + ") - " + path);
        try {
            if (path.endsWith("/all")) {
                int allPos = path.lastIndexOf("all");
                String query = path.substring(0, allPos);
                String[] ids = this.mStorage.getClusterContents(this.mItemPath, query);
                for (int i = 0; i < ids.length; ++i) {
                    result = result + ids[i];
                    if (i == ids.length - 1) continue;
                    result = result + ",";
                }
            } else {
                result = Gateway.getMarshaller().marshall(this.mStorage.get(this.mItemPath, path, null));
            }
        }
        catch (ObjectNotFoundException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.warn("queryData(" + this.mItemPath + ") - " + path + " Failed: " + ex.getClass().getName());
            throw new PersistencyException("Server exception: " + ex.getClass().getName());
        }
        log.trace("queryData(" + this.mItemPath + ") - result:" + result);
        return result;
    }

    protected void finalize() throws Throwable {
        log.debug("finalize reaping " + this.mItemPath);
        Gateway.getStorage().clearCache(this.mItemPath, null);
        super.finalize();
    }
}

