/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.events;

import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.GTimeStamp;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.lifecycle.instance.stateMachine.Transition;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.utils.DateUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Event
implements C2KLocalObject {
    private static final Logger log = LoggerFactory.getLogger(Event.class);
    ItemPath mItemPath;
    AgentPath mAgentPath;
    AgentPath mDelegatePath;
    int mOriginState;
    int mTransition;
    int mTargetState;
    Integer mID;
    Integer mSchemaVersion;
    Integer mStateMachineVersion;
    String mName;
    String mStepName;
    String mStepPath;
    String mStepType;
    String mSchemaName;
    String mStateMachineName;
    String mViewName;
    String mAgentRole;
    GTimeStamp mTimeStamp;

    public Event(ItemPath itemPath, AgentPath agentPath, AgentPath delegatePath, String agentRole, String stepName, String stepPath, String stepType, StateMachine stateMachine, int transitionId) {
        Transition transition = stateMachine.getTransition(transitionId);
        log.trace("Creating new event for {} on {} in {}", new Object[]{transition.getName(), stepName, itemPath});
        this.setItemPath(itemPath);
        this.setAgentPath(agentPath);
        this.setDelegatePath(delegatePath);
        this.setAgentRole(agentRole);
        this.setStepName(stepName);
        this.setStepPath(stepPath);
        this.setStepType(stepType);
        this.setTransition(transitionId);
        this.setOriginState(transition.getOriginStateId());
        this.setTargetState(transition.getTargetStateId());
        this.setStateMachineName(stateMachine.getItemID());
        this.setStateMachineVersion(stateMachine.getVersion());
        this.setTimeStamp(DateUtility.getNow());
    }

    public Event(Integer id, ItemPath itemPath, AgentPath agentPath, AgentPath delegatePath, String agentRole, String stepName, String stepPath, String stepType, String smName, Integer smVersion, int transitionId, int originState, int targetState, String schemaName, Integer schemaVersion, String viewName, GTimeStamp ts) {
        this.setID(id);
        this.setItemPath(itemPath);
        this.setAgentPath(agentPath);
        this.setDelegatePath(delegatePath);
        this.setAgentRole(agentRole);
        this.setStepName(stepName);
        this.setStepPath(stepPath);
        this.setStepType(stepType);
        this.setStateMachineName(smName);
        this.setStateMachineVersion(smVersion);
        this.setTransition(transitionId);
        this.setOriginState(originState);
        this.setTargetState(targetState);
        this.setSchemaName(schemaName);
        this.setSchemaVersion(schemaVersion);
        this.setViewName(viewName);
        this.setTimeStamp(ts);
    }

    public Event() {
    }

    public void setID(Integer id) {
        this.mID = id;
        this.mName = id == null ? null : String.valueOf(id);
    }

    public void setItemUUID(String uuid) throws InvalidItemPathException {
        this.setItemPath(new ItemPath(uuid));
    }

    public String getItemUUID() {
        return this.getItemPath().getUUID().toString();
    }

    public void setAgentUUID(String uuid) throws InvalidItemPathException {
        if (uuid == null || uuid.length() == 0) {
            this.mAgentPath = null;
        } else if (uuid.contains(":")) {
            String[] agentStr = uuid.split(":");
            if (agentStr.length != 2) {
                throw new InvalidItemPathException();
            }
            this.setAgentPath(new AgentPath(agentStr[0]));
            this.setDelegatePath(new AgentPath(agentStr[1]));
        } else {
            this.setAgentPath(new AgentPath(uuid));
        }
    }

    public String getAgentUUID() {
        if (this.mAgentPath != null) {
            if (this.mDelegatePath != null) {
                return this.getAgentPath().getUUID().toString() + ":" + this.getDelegatePath().getUUID().toString();
            }
            return this.getAgentPath().getUUID().toString();
        }
        return null;
    }

    @Override
    public void setName(String name) {
        this.mName = name;
        if (this.mID == null) {
            try {
                this.mID = Integer.parseInt(name);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public String getTimeString() {
        return DateUtility.timeToString(this.mTimeStamp);
    }

    public void setTimeString(String time) throws InvalidDataException {
        this.mTimeStamp = DateUtility.parseTimeString(time);
    }

    @Override
    public ClusterType getClusterType() {
        return ClusterType.HISTORY;
    }

    @Override
    public String getClusterPath() {
        return (Object)((Object)this.getClusterType()) + "/" + this.mID;
    }

    public void addOutcomeDetails(Schema schema, String viewName) {
        this.setSchemaName(schema.getItemID());
        this.setSchemaVersion(schema.getVersion());
        this.setViewName(viewName);
    }

    public void setViewName(String viewName) {
        this.mViewName = StringUtils.isBlank((CharSequence)viewName) ? "last" : viewName;
    }

    public ItemPath getItemPath() {
        return this.mItemPath;
    }

    public AgentPath getAgentPath() {
        return this.mAgentPath;
    }

    public AgentPath getDelegatePath() {
        return this.mDelegatePath;
    }

    public int getOriginState() {
        return this.mOriginState;
    }

    public int getTransition() {
        return this.mTransition;
    }

    public int getTargetState() {
        return this.mTargetState;
    }

    public Integer getID() {
        return this.mID;
    }

    public Integer getSchemaVersion() {
        return this.mSchemaVersion;
    }

    public Integer getStateMachineVersion() {
        return this.mStateMachineVersion;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public String getStepName() {
        return this.mStepName;
    }

    public String getStepPath() {
        return this.mStepPath;
    }

    public String getStepType() {
        return this.mStepType;
    }

    public String getSchemaName() {
        return this.mSchemaName;
    }

    public String getStateMachineName() {
        return this.mStateMachineName;
    }

    public String getViewName() {
        return this.mViewName;
    }

    public String getAgentRole() {
        return this.mAgentRole;
    }

    public GTimeStamp getTimeStamp() {
        return this.mTimeStamp;
    }

    public void setItemPath(ItemPath mItemPath) {
        this.mItemPath = mItemPath;
    }

    public void setAgentPath(AgentPath mAgentPath) {
        this.mAgentPath = mAgentPath;
    }

    public void setDelegatePath(AgentPath mDelegatePath) {
        this.mDelegatePath = mDelegatePath;
    }

    public void setOriginState(int mOriginState) {
        this.mOriginState = mOriginState;
    }

    public void setTransition(int mTransition) {
        this.mTransition = mTransition;
    }

    public void setTargetState(int mTargetState) {
        this.mTargetState = mTargetState;
    }

    public void setSchemaVersion(Integer mSchemaVersion) {
        this.mSchemaVersion = mSchemaVersion;
    }

    public void setStateMachineVersion(Integer mStateMachineVersion) {
        this.mStateMachineVersion = mStateMachineVersion;
    }

    public void setStepName(String mStepName) {
        this.mStepName = mStepName;
    }

    public void setStepPath(String mStepPath) {
        this.mStepPath = mStepPath;
    }

    public void setStepType(String mStepType) {
        this.mStepType = mStepType;
    }

    public void setSchemaName(String mSchemaName) {
        this.mSchemaName = mSchemaName;
    }

    public void setStateMachineName(String mStateMachineName) {
        this.mStateMachineName = mStateMachineName;
    }

    public void setAgentRole(String mAgentRole) {
        this.mAgentRole = mAgentRole;
    }

    public void setTimeStamp(GTimeStamp mTimeStamp) {
        this.mTimeStamp = mTimeStamp;
    }
}

