/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.Arrays;
import org.cristalise.kernel.collection.Aggregation;
import org.cristalise.kernel.collection.AggregationMember;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.Gateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClearSlot
extends PredefinedStep {
    private static final Logger log = LoggerFactory.getLogger(ClearSlot.class);

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, Object locker) throws InvalidDataException, ObjectNotFoundException, PersistencyException, ObjectCannotBeUpdated {
        Aggregation agg;
        int slotNo;
        String collName;
        Object[] params = ClearSlot.getDataList(requestData);
        log.debug("Called by {} on {} with parameters {}", new Object[]{agent.getAgentName(), item, params});
        try {
            collName = params[0];
            slotNo = Integer.parseInt(params[1]);
        }
        catch (Exception e) {
            throw new InvalidDataException("ClearSlot: Invalid parameters " + Arrays.toString(params));
        }
        try {
            agg = (Aggregation)Gateway.getStorage().get(item, (Object)((Object)ClusterType.COLLECTION) + "/" + collName + "/last", locker);
        }
        catch (PersistencyException ex) {
            log.error("ClearSlot: Error loading collection '" + collName + "'", (Throwable)ex);
            throw new PersistencyException("ClearSlot: Error loading collection '" + collName + "': " + ex.getMessage());
        }
        boolean stored = false;
        for (AggregationMember member : agg.getMembers().list) {
            if (member.getID() != slotNo) continue;
            if (member.getItemPath() == null) {
                throw new ObjectCannotBeUpdated("ClearSlot: Member slot " + slotNo + " already empty for collection " + collName);
            }
            member.clearItem();
            stored = true;
            break;
        }
        if (!stored) {
            throw new ObjectNotFoundException("ClearSlot: Member slot " + slotNo + " not found for collection " + collName);
        }
        try {
            Gateway.getStorage().put(item, agg, locker);
        }
        catch (PersistencyException e) {
            log.error("Error storing collection {}", (Object)collName, (Object)e);
            throw new PersistencyException("ClearSlot: Error storing collection " + collName);
        }
        return requestData;
    }
}

