/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.util.ArrayList;
import org.cristalise.kernel.common.GTimeStamp;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.graph.renderer.DefaultVertexRenderer;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.utils.DateUtility;

public class ActivityRenderer
extends DefaultVertexRenderer {
    private Paint mActivePaint = new Color(100, 255, 100);
    private Paint mActiveCompPaint = new Color(100, 255, 255);
    private Paint mInactivePaint = new Color(255, 255, 255);
    private Paint mInactiveCompPaint = new Color(200, 200, 255);
    private Paint mErrorPaint = new Color(255, 50, 0);
    private Paint mTextPaint = Color.black;

    @Override
    public void draw(Graphics2D g2d, Vertex vertex) {
        Activity activity = (Activity)vertex;
        boolean hasError = !activity.verify();
        this.drawOutline3DRect(g2d, vertex, this.getActColor(activity, hasError));
        ArrayList<String> linesOfText = new ArrayList<String>();
        String type = activity.getTypeName();
        if (type != null) {
            linesOfText.add("(" + type + ")");
        }
        linesOfText.add(activity.getName());
        if (hasError) {
            linesOfText.add(activity.getErrors());
        } else {
            String stateName = "Invalid State";
            try {
                stateName = activity.getStateName();
            }
            catch (NullPointerException | InvalidDataException throwable) {
                // empty catch block
            }
            linesOfText.add(stateName + " " + ActivityRenderer.getWaitTime(activity.getStateDate()));
        }
        this.drawLinesOfTexts(g2d, vertex, linesOfText, this.mTextPaint);
    }

    private Paint getActColor(Activity activity, boolean hasError) {
        boolean active = activity.getActive();
        boolean isComposite = activity.getIsComposite();
        if (hasError) {
            return this.mErrorPaint;
        }
        if (active) {
            if (isComposite) {
                return this.mActiveCompPaint;
            }
            return this.mActivePaint;
        }
        if (isComposite) {
            return this.mInactiveCompPaint;
        }
        return this.mInactivePaint;
    }

    private static String getWaitTime(GTimeStamp date) {
        GTimeStamp now = new GTimeStamp();
        DateUtility.setToNow(now);
        long diff = DateUtility.diff(now, date);
        long secondes = diff % 60L;
        long minutes = diff / 60L % 60L;
        long hours = diff / 3600L % 24L;
        long days = diff / 3600L / 24L;
        if (days > 0L) {
            return days + " d " + hours + " h";
        }
        if (hours > 0L) {
            return hours + " h " + minutes + " min";
        }
        if (minutes > 0L) {
            return minutes + " min";
        }
        return secondes + " sec";
    }
}

