/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.security;

import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.config.Ini;
import org.apache.shiro.config.IniSecurityManagerFactory;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.auth.Authenticator;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.security.BuiltInAuthc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityManager {
    private static final Logger log = LoggerFactory.getLogger(SecurityManager.class);
    private static final String securityMsgBegin = "[errorMessage]";
    private static final String securityMsgEnd = "[/errorMessage]";
    private Authenticator auth = null;
    private boolean shiroEnabled = false;

    public SecurityManager() throws InvalidDataException {
        if ("Shiro".equals(Gateway.getProperties().getString("Authenticator", ""))) {
            this.setupShiro();
        } else {
            this.auth = Gateway.getAuthenticator();
        }
    }

    public void authenticate() throws InvalidDataException, ObjectNotFoundException {
        if (!this.shiroEnabled && !this.auth.authenticate(BuiltInAuthc.SYSTEM_AGENT.getName())) {
            throw new InvalidDataException("Server authentication failed");
        }
    }

    public AgentProxy authenticate(String agentName, String agentPassword, String resource) throws InvalidDataException, ObjectNotFoundException {
        return this.authenticate(agentName, agentPassword, resource, true);
    }

    public AgentProxy authenticate(String agentName, String agentPassword, String resource, boolean isClient) throws InvalidDataException, ObjectNotFoundException {
        if (this.shiroEnabled ? !this.shiroAuthenticate(agentName, agentPassword) : !this.auth.authenticate(agentName, agentPassword, resource)) {
            throw new InvalidDataException("Login failed");
        }
        if (isClient && Gateway.getProxyManager() != null) {
            return Gateway.getProxyManager().getAgentProxy(agentName);
        }
        return null;
    }

    public Subject getSubject(AgentPath agent) {
        return this.getSubject(agent.getAgentName());
    }

    public Subject getSubject(String principal) {
        SimplePrincipalCollection principals = new SimplePrincipalCollection((Object)principal, principal);
        return new Subject.Builder().principals((PrincipalCollection)principals).buildSubject();
    }

    public void setupShiro() {
        String shiroIni = Gateway.getProperties().getString("Shiro.iniFile");
        shiroIni = StringUtils.isBlank((CharSequence)shiroIni) ? "classpath:shiro.ini" : "file:" + shiroIni;
        Ini sIni = Ini.fromResourcePath((String)shiroIni);
        IniSecurityManagerFactory factory = new IniSecurityManagerFactory(sIni);
        org.apache.shiro.mgt.SecurityManager securityManager = (org.apache.shiro.mgt.SecurityManager)factory.getInstance();
        SecurityUtils.setSecurityManager((org.apache.shiro.mgt.SecurityManager)securityManager);
        log.info("setupShiro(" + shiroIni + ") - Done");
        this.shiroEnabled = true;
    }

    public static String decodePublicSecurityMessage(Throwable ex) {
        String msg = StringUtils.substringBetween((String)ex.getMessage(), (String)securityMsgBegin, (String)securityMsgEnd);
        if (StringUtils.isBlank((CharSequence)msg) && ex.getCause() != null) {
            return SecurityManager.decodePublicSecurityMessage(ex.getCause());
        }
        return msg;
    }

    public static String encodePublicSecurityMessage(String msg) {
        return securityMsgBegin + msg + securityMsgEnd;
    }

    public boolean shiroAuthenticate(String agentName, String agentPassword) throws InvalidDataException {
        block3: {
            Subject agentSubject = this.getSubject(agentName);
            if (!agentSubject.isAuthenticated()) {
                UsernamePasswordToken token = new UsernamePasswordToken(agentName, agentPassword);
                token.setRememberMe(true);
                try {
                    agentSubject.login((AuthenticationToken)token);
                    return true;
                }
                catch (Exception ex) {
                    String publicMsg = SecurityManager.decodePublicSecurityMessage(ex);
                    if (!StringUtils.isNotBlank((CharSequence)publicMsg)) break block3;
                    log.debug("shiroAuthenticate() - Failed with public message:{}", (Object)publicMsg);
                    throw new InvalidDataException(SecurityManager.encodePublicSecurityMessage(publicMsg));
                }
            }
        }
        return false;
    }

    public boolean checkPermissions(AgentPath agent, Activity act, ItemPath itemPath) throws AccessRightsException, ObjectNotFoundException {
        String domain = this.getWildcardPermissionDomain(itemPath);
        String action = this.getWildcardPermissionAction(act);
        String target = Gateway.getProxyManager().getProxy(itemPath).getName();
        String permission = domain + ":" + action + ":" + target;
        log.debug("checkPermissions() - agent:'{}' permission:'{}'", (Object)agent.getAgentName(), (Object)permission);
        return this.getSubject(agent).isPermitted(permission);
    }

    private String getWildcardPermissionDomain(ItemPath itemPath) throws ObjectNotFoundException, AccessRightsException {
        String type;
        ItemProxy item = Gateway.getProxyManager().getProxy(itemPath);
        String domain = item.getProperty(BuiltInItemProperties.SECURITY_DOMAIN, type = item.getType());
        if (StringUtils.isBlank((CharSequence)domain)) {
            throw new AccessRightsException("Domain was blank - Specify 'SecurityDomain' or 'Type' ItemProperties");
        }
        return domain;
    }

    private String getWildcardPermissionAction(Activity act) throws AccessRightsException {
        String action = (String)act.getBuiltInProperty(BuiltInVertexProperties.SECURITY_ACTION, "");
        if (StringUtils.isBlank((CharSequence)action)) {
            action = act.getName();
        }
        if (StringUtils.isBlank((CharSequence)action)) {
            throw new AccessRightsException("Action was blank - Specify 'SecurityAction' or 'Name' ActivityProperties");
        }
        return action;
    }

    public Authenticator getAuth() {
        return this.auth;
    }

    public boolean isShiroEnabled() {
        return this.shiroEnabled;
    }
}

