/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.utils;

import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.querying.Query;
import org.cristalise.kernel.utils.DescriptionObjectCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryCache
extends DescriptionObjectCache<Query> {
    private static final Logger log = LoggerFactory.getLogger(QueryCache.class);

    @Override
    public String getTypeCode() {
        return BuiltInResources.QUERY_RESOURCE.getTypeCode();
    }

    @Override
    public String getSchemaName() {
        return BuiltInResources.QUERY_RESOURCE.getSchemaName();
    }

    @Override
    public Query buildObject(String name, int version, ItemPath path, String data) throws InvalidDataException {
        try {
            return new Query(name, version, path, data);
        }
        catch (Exception ex) {
            log.error("Error parsing query '" + name + "' v" + version, (Throwable)ex);
            throw new InvalidDataException("Error parsing query '" + name + "' v" + version + ": " + ex.getMessage());
        }
    }
}

