/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance;

import java.util.Vector;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.graph.model.GraphableVertex;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.graph.traversal.GraphTraversal;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.Loop;
import org.cristalise.kernel.lifecycle.instance.Next;
import org.cristalise.kernel.lifecycle.instance.WfVertex;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Join
extends WfVertex {
    private static final Logger log = LoggerFactory.getLogger(Join.class);
    public Vector<String> mErrors = new Vector(0, 1);
    private boolean loopTested;
    public int counter = 0;

    private boolean hasPrevActiveActs() throws InvalidDataException {
        Vertex[] vertices;
        String pairingID = (String)this.getBuiltInProperty(BuiltInVertexProperties.PAIRING_ID);
        boolean findPair = false;
        if (StringUtils.isNotBlank((CharSequence)pairingID)) {
            findPair = true;
            for (Vertex outVertex : this.getOutGraphables()) {
                String otherPairingID = (String)((GraphableVertex)outVertex).getBuiltInProperty(BuiltInVertexProperties.PAIRING_ID);
                if (!pairingID.equals(otherPairingID) || !(outVertex instanceof Loop)) continue;
                findPair = false;
                break;
            }
        }
        if (findPair) {
            GraphableVertex endVertex = this.findPair(pairingID);
            if (endVertex == null) {
                throw new InvalidDataException("Could not find pair for Join using PairingID:" + pairingID);
            }
            vertices = GraphTraversal.getTraversal(this.getParent().getChildrenGraphModel(), this, endVertex, 1, true);
            log.debug("hasPrevActiveActs(id:{}) - vertices[PairingID:" + pairingID + "]={}", (Object)this.getID(), (Object)vertices);
        } else {
            vertices = GraphTraversal.getTraversal(this.getParent().getChildrenGraphModel(), this, 1, true);
            log.debug("hasPrevActiveActs(id:{}) - vertices={}", (Object)this.getID(), (Object)vertices);
        }
        for (Vertex v : vertices) {
            Activity act;
            if (!(v instanceof Activity) || (act = (Activity)v).isFinished() || !act.active) continue;
            return true;
        }
        return false;
    }

    @Override
    public void runNext(AgentPath agent, ItemPath item, Object locker) throws InvalidDataException {
        Object[] outVertices;
        if (!this.hasPrevActiveActs() && ArrayUtils.isNotEmpty((Object[])(outVertices = this.getOutGraphables()))) {
            ((WfVertex)outVertices[0]).run(agent, item, locker);
        }
    }

    public Next addNext(String idNext) {
        return this.addNext((WfVertex)this.getParent().search(idNext));
    }

    @Override
    public Next addNext(WfVertex vertex) {
        return new Next(this, vertex);
    }

    @Override
    public void reinit(int idLoop) throws InvalidDataException {
        log.debug("reinit(id:{}, idLoop:{}) - parent:{}", new Object[]{this.getID(), idLoop, this.getParent().getName()});
        Vertex[] outVertices = this.getOutGraphables();
        if (outVertices.length == 1) {
            WfVertex nextAct = (WfVertex)outVertices[0];
            nextAct.reinit(idLoop);
        }
    }

    @Override
    public boolean verify() {
        this.mErrors.removeAllElements();
        int nbOutEdges = this.getOutEdges().length;
        int nbInEdges = this.getInEdges().length;
        String type = (String)this.getProperties().get("Type");
        if (nbInEdges < 1) {
            this.mErrors.add("not enough previous");
            return false;
        }
        if (type != null && type.equals("Route") && nbInEdges > 1) {
            this.mErrors.add("Bad nb of previous");
            return false;
        }
        if (nbOutEdges > 1) {
            this.mErrors.add("too many next");
            return false;
        }
        if (nbOutEdges == 0 && !((CompositeActivity)this.getParent()).hasGoodNumberOfActivity()) {
            this.mErrors.add("too many endpoints");
            return false;
        }
        Vertex[] outV = this.getOutGraphables();
        Vertex[] anteVertices = GraphTraversal.getTraversal(this.getParent().getChildrenGraphModel(), this, 1, false);
        boolean loop = false;
        boolean errInLoop = false;
        for (int i = 0; i < outV.length; ++i) {
            for (int j = 0; j < anteVertices.length; ++j) {
                if (loop || outV[i].getID() != anteVertices[j].getID()) continue;
                if (outV[i] instanceof Loop) {
                    loop = true;
                    j = anteVertices.length;
                    i = outV.length;
                    continue;
                }
                errInLoop = true;
            }
        }
        if (errInLoop && loop) {
            this.mErrors.add("Problem in Loop");
            return false;
        }
        return true;
    }

    @Override
    public String getErrors() {
        if (this.mErrors.size() == 0) {
            return "No error";
        }
        return this.mErrors.elementAt(0);
    }

    @Override
    public void run(AgentPath agent, ItemPath item, Object locker) throws InvalidDataException {
        this.runNext(agent, item, locker);
    }

    @Override
    public boolean loop() {
        boolean loop2 = false;
        if (!this.loopTested) {
            this.loopTested = true;
            if (this.getOutGraphables().length != 0) {
                loop2 = ((WfVertex)this.getOutGraphables()[0]).loop();
            }
        } else {
            loop2 = true;
        }
        this.loopTested = false;
        return loop2;
    }

    @Override
    public void runFirst(AgentPath agent, ItemPath item, Object locker) throws InvalidDataException {
        this.runNext(agent, item, locker);
    }

    @Override
    public boolean isJoin() {
        return true;
    }
}

