/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance;

import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.graph.model.BuiltInEdgeProperties;
import org.cristalise.kernel.graph.model.DirectedEdge;
import org.cristalise.kernel.lifecycle.instance.Next;
import org.cristalise.kernel.lifecycle.instance.Split;
import org.cristalise.kernel.lifecycle.instance.WfVertex;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrSplit
extends Split {
    private static final Logger log = LoggerFactory.getLogger(OrSplit.class);

    @Override
    public void runNext(AgentPath agent, ItemPath itemPath, Object locker) throws InvalidDataException {
        int id = this.getID();
        String[] nextsTab = this.calculateNexts(itemPath, locker);
        int active = 0;
        DirectedEdge[] outEdges = this.getOutEdges();
        for (String thisNext : nextsTab) {
            log.debug("runNext(id:{}) - Finding edge with {} '{}'", new Object[]{id, BuiltInEdgeProperties.ALIAS, thisNext});
            if (thisNext == null) continue;
            for (DirectedEdge outEdge : outEdges) {
                Next nextEdge = (Next)outEdge;
                if (!thisNext.equals(nextEdge.getBuiltInProperty(BuiltInEdgeProperties.ALIAS))) continue;
                WfVertex term = nextEdge.getTerminusVertex();
                try {
                    term.run(agent, itemPath, locker);
                }
                catch (InvalidDataException e) {
                    log.error("", (Throwable)e);
                    throw new InvalidDataException("Error enabling next " + thisNext);
                }
                log.debug("runNext(id:{}) - Running {}", (Object)id, nextEdge.getBuiltInProperty(BuiltInEdgeProperties.ALIAS));
                ++active;
            }
        }
        if (active == 0) {
            throw new InvalidDataException("No edges found, no next vertex activated! (id: " + id + ")");
        }
    }
}

