/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.CorbaServer;
import org.cristalise.kernel.entity.ItemOperations;
import org.cristalise.kernel.entity.agent.ActiveEntity;
import org.cristalise.kernel.lifecycle.instance.predefined.item.CreateItemFromDescription;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.PropertyArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateAgentFromDescription
extends CreateItemFromDescription {
    private static final Logger log = LoggerFactory.getLogger(CreateAgentFromDescription.class);

    @Override
    protected String runActivityLogic(AgentPath agentPath, ItemPath descItemPath, int transitionID, String requestData, Object locker) throws ObjectNotFoundException, InvalidDataException, ObjectAlreadyExistsException, CannotManageException, ObjectCannotBeUpdated, PersistencyException {
        String[] input = CreateAgentFromDescription.getDataList(requestData);
        String newName = input[0];
        String contextS = input[1];
        String[] roles = StringUtils.isNotBlank((CharSequence)input[2]) ? input[2].split(",") : new String[]{};
        String pwd = input.length > 3 && StringUtils.isNotBlank((CharSequence)input[3]) ? input[3] : "";
        String descVer = input.length > 4 && StringUtils.isNotBlank((CharSequence)input[4]) ? input[4] : "last";
        PropertyArrayList initProps = input.length > 5 && StringUtils.isNotBlank((CharSequence)input[5]) ? this.unmarshallInitProperties(input[5]) : new PropertyArrayList();
        String outcome = input.length > 6 && StringUtils.isNotBlank((CharSequence)input[6]) ? input[6] : "";
        log.debug("Called by {} on {} with parameters {}", new Object[]{agentPath.getAgentName(), descItemPath, input});
        AgentPath newAgentPath = new AgentPath(new ItemPath(), newName);
        if (Gateway.getLookup().exists(newAgentPath)) {
            throw new ObjectAlreadyExistsException("The agent name " + newName + " exists already.");
        }
        DomainPath context = new DomainPath(new DomainPath(contextS), newName);
        if (context.exists()) {
            throw new ObjectAlreadyExistsException("The path " + context + " exists already.");
        }
        ActiveEntity newAgent = this.createAgentAddRoles(newAgentPath, roles, pwd);
        this.initialiseItem((ItemOperations)newAgent, agentPath, descItemPath, initProps, outcome, newName, descVer, context, newAgentPath, locker);
        if (input.length > 3) {
            input[3] = "REDACTED";
        }
        return CreateAgentFromDescription.bundleData(input);
    }

    protected ActiveEntity createAgentAddRoles(AgentPath newAgentPath, String[] roles, String pwd) throws CannotManageException, ObjectCannotBeUpdated, ObjectAlreadyExistsException {
        log.info("createAgentAddRoles() - Creating Agent {}", (Object)newAgentPath.getAgentName());
        CorbaServer factory = Gateway.getCorbaServer();
        if (factory == null) {
            throw new CannotManageException("This process cannot create new Items");
        }
        ActiveEntity newAgent = factory.createAgent(newAgentPath);
        Gateway.getLookupManager().add(newAgentPath);
        try {
            if (StringUtils.isNotBlank((CharSequence)pwd)) {
                Gateway.getLookupManager().setAgentPassword(newAgentPath, pwd, true);
            }
            for (String roleName : roles) {
                if (!StringUtils.isNotBlank((CharSequence)roleName)) continue;
                RolePath role = Gateway.getLookupManager().getRolePath(roleName);
                Gateway.getLookupManager().addRole(newAgentPath, role);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            Gateway.getLookupManager().delete(newAgentPath);
            throw new CannotManageException(e.getMessage());
        }
        return newAgent;
    }
}

