/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lookup;

import java.util.Arrays;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.SystemKey;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.Gateway;
import org.omg.CORBA.Object;

public abstract class Path
implements C2KLocalObject {
    public static final String delim = "/";
    protected String[] mPath = new String[0];

    public Path() {
    }

    protected Path(String[] path) {
        this.setPath(path);
    }

    protected Path(String path) {
        this.setPath(path);
    }

    protected Path(Path parent, String child) {
        if (child.contains(delim)) {
            throw new IllegalArgumentException("Child name '" + child + "' contains delimiter:" + delim);
        }
        this.mPath = Arrays.copyOf(parent.getPath(), parent.getPath().length + 1);
        this.mPath[this.mPath.length - 1] = child;
    }

    public void setPath(String[] path) {
        this.mPath = path != null && path.length > 0 ? (path[0].equals(this.getRoot()) ? Arrays.copyOfRange(path, 1, path.length) : (String[])path.clone()) : new String[0];
    }

    public void setPath(String path) {
        this.setPath(StringUtils.split((String)path, (String)delim));
    }

    public abstract String getRoot();

    public Object getIOR() {
        return null;
    }

    public void setIOR(Object IOR) {
    }

    public SystemKey getSystemKey() {
        return null;
    }

    public UUID getUUID() {
        return null;
    }

    public ItemPath getItemPath() throws ObjectNotFoundException {
        return null;
    }

    public void setPath(Path path) {
        this.mPath = (String[])path.getPath().clone();
    }

    public String[] getPath() {
        return this.mPath;
    }

    public String getStringPath() {
        if (this.mPath.length == 0) {
            return delim + this.getRoot();
        }
        return delim + this.getRoot() + delim + StringUtils.join((java.lang.Object[])this.mPath, (String)delim);
    }

    @Deprecated
    public String getString() {
        return this.getStringPath();
    }

    public boolean exists() {
        if (Gateway.getLookup() == null) {
            return false;
        }
        return Gateway.getLookup().exists(this);
    }

    public String toString() {
        return this.getStringPath();
    }

    public boolean equals(java.lang.Object path) {
        if (path == null) {
            return false;
        }
        return this.toString().equals(path.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String dump() {
        StringBuffer comp = new StringBuffer("Components: { ");
        for (String element : this.mPath) {
            comp.append("'").append(element).append("' ");
        }
        return "Path - dump(): " + comp.toString() + "}\n        string=" + this.toString() + "\n        uuid=" + this.getUUID();
    }

    @Override
    public void setName(String name) {
        throw new IllegalStateException("This method should not be called");
    }

    @Override
    public ClusterType getClusterType() {
        return ClusterType.PATH;
    }
}

