/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.persistency;

import java.util.ArrayList;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.auth.Authenticator;
import org.cristalise.kernel.querying.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClusterStorage {
    private static final Logger log = LoggerFactory.getLogger(ClusterStorage.class);
    public static final short NONE = 0;
    public static final short READ = 1;
    public static final short WRITE = 2;
    public static final short READWRITE = 3;
    @Deprecated
    public static final String ROOT = ClusterType.ROOT.getName();
    @Deprecated
    public static final String PATH = ClusterType.PATH.getName();
    @Deprecated
    public static final String PROPERTY = ClusterType.PROPERTY.getName();
    @Deprecated
    public static final String COLLECTION = ClusterType.COLLECTION.getName();
    @Deprecated
    public static final String LIFECYCLE = ClusterType.LIFECYCLE.getName();
    @Deprecated
    public static final String OUTCOME = ClusterType.OUTCOME.getName();
    @Deprecated
    public static final String HISTORY = ClusterType.HISTORY.getName();
    @Deprecated
    public static final String VIEWPOINT = ClusterType.VIEWPOINT.getName();
    @Deprecated
    public static final String JOB = ClusterType.JOB.getName();
    @Deprecated
    public static final String[] allClusterTypes = new String[]{PROPERTY, COLLECTION, LIFECYCLE, OUTCOME, HISTORY, VIEWPOINT, JOB};

    public abstract void open(Authenticator var1) throws PersistencyException;

    public abstract void close() throws PersistencyException;

    public abstract void postBoostrap() throws PersistencyException;

    public abstract void postStartServer() throws PersistencyException;

    public abstract void postConnect() throws PersistencyException;

    public short queryClusterSupport(ClusterType clusterType) {
        return this.queryClusterSupport(clusterType.getName());
    }

    @Deprecated
    public abstract short queryClusterSupport(String var1);

    public abstract boolean checkQuerySupport(String var1);

    public abstract String getName();

    public abstract String getId();

    protected static ClusterType getClusterType(String path) {
        try {
            if (path == null || path.length() == 0) {
                return ClusterType.ROOT;
            }
            int start = path.charAt(0) == '/' ? 1 : 0;
            int end = path.indexOf(47, start + 1);
            if (end == -1) {
                end = path.length();
            }
            return ClusterType.getValue(path.substring(start, end));
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
            return ClusterType.ROOT;
        }
    }

    public static String getPath(C2KLocalObject obj) {
        if (obj.getClusterType() == null) {
            return null;
        }
        return obj.getClusterPath();
    }

    public abstract String executeQuery(Query var1) throws PersistencyException;

    public abstract C2KLocalObject get(ItemPath var1, String var2) throws PersistencyException;

    public abstract void put(ItemPath var1, C2KLocalObject var2) throws PersistencyException;

    public abstract void delete(ItemPath var1, String var2) throws PersistencyException;

    public abstract String[] getClusterContents(ItemPath var1, String var2) throws PersistencyException;

    public String[] getClusterContents(ItemPath itemPath, ClusterType type) throws PersistencyException {
        return this.getClusterContents(itemPath, type.getName());
    }

    public ClusterType[] getClusters(ItemPath itemPath) throws PersistencyException {
        String[] contents = this.getClusterContents(itemPath, "");
        ArrayList<ClusterType> types = new ArrayList<ClusterType>();
        for (String content : contents) {
            ClusterType type = ClusterType.getValue(content);
            if (type != null) {
                types.add(type);
                continue;
            }
            log.warn("Cannot convert content '{}' to ClusterType", (Object)content);
        }
        return types.toArray(new ClusterType[0]);
    }
}

