/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.persistency.outcome;

import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.events.Event;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.process.Gateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutcomeAttachment
implements C2KLocalObject {
    private static final Logger log = LoggerFactory.getLogger(OutcomeAttachment.class);
    public static final int NONE = -1;
    ItemPath itemPath;
    String schemaName;
    int schemaVersion;
    int eventId;
    String fileName;
    byte[] binaryData;

    public OutcomeAttachment() {
        this.eventId = -1;
        this.itemPath = null;
        this.schemaVersion = -1;
        this.schemaName = null;
        this.fileName = null;
        this.binaryData = new byte[0];
    }

    public OutcomeAttachment(ItemPath itemPath, String schemaName, int schemaVersion, int eventId, String file, byte[] binaryData) {
        this.itemPath = itemPath;
        this.schemaName = schemaName;
        this.schemaVersion = schemaVersion;
        this.eventId = eventId;
        this.fileName = file;
        this.binaryData = binaryData;
    }

    public OutcomeAttachment(ItemPath itemPath, Outcome outcome, String file, byte[] binaryData) {
        this.itemPath = itemPath;
        this.schemaName = outcome.getSchema().getName();
        this.schemaVersion = outcome.getSchema().getVersion();
        this.eventId = outcome.getID();
        this.fileName = file;
        this.binaryData = binaryData;
    }

    public Outcome getOutcome() throws ObjectNotFoundException, PersistencyException {
        return this.getOutcome(null);
    }

    public Outcome getOutcome(Object locker) throws ObjectNotFoundException, PersistencyException {
        if (this.eventId == -1) {
            throw new ObjectNotFoundException("No last eventId defined for path:" + this.getClusterPath());
        }
        return (Outcome)Gateway.getStorage().get(this.itemPath, (Object)((Object)ClusterType.OUTCOME) + "/" + this.schemaName + "/" + this.schemaVersion + "/" + this.eventId, locker);
    }

    @Override
    public ClusterType getClusterType() {
        return ClusterType.ATTACHMENT;
    }

    @Override
    public String getClusterPath() {
        return (Object)((Object)this.getClusterType()) + "/" + this.schemaName + "/" + this.schemaVersion + "/" + this.eventId;
    }

    public void setItemUUID(String uuid) throws InvalidItemPathException {
        this.setItemPath(new ItemPath(uuid));
    }

    public String getItemUUID() {
        return this.getItemPath().getUUID().toString();
    }

    public Event getEvent() throws InvalidDataException, PersistencyException, ObjectNotFoundException {
        if (this.eventId == -1) {
            throw new InvalidDataException("No eventId defined for path:" + this.getClusterPath());
        }
        return (Event)Gateway.getStorage().get(this.itemPath, (Object)((Object)ClusterType.HISTORY) + "/" + this.eventId, null);
    }

    @Override
    public void setName(String name) {
        try {
            this.eventId = Integer.valueOf(name);
        }
        catch (NumberFormatException e) {
            log.error("Invalid id set on Outcome:" + name);
        }
    }

    @Override
    public String getName() {
        return "" + this.eventId;
    }

    public ItemPath getItemPath() {
        return this.itemPath;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    public int getEventId() {
        return this.eventId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public byte[] getBinaryData() {
        return this.binaryData;
    }

    public void setItemPath(ItemPath itemPath) {
        this.itemPath = itemPath;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setSchemaVersion(int schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public void setEventId(int eventId) {
        this.eventId = eventId;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setBinaryData(byte[] binaryData) {
        this.binaryData = binaryData;
    }
}

