/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.storage;

import java.util.HashMap;
import java.util.StringTokenizer;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.AgentHelper;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.entity.Item;
import org.cristalise.kernel.entity.ItemHelper;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Lookup;
import org.cristalise.kernel.persistency.ClusterStorage;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.auth.Authenticator;
import org.cristalise.kernel.querying.Query;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Object;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyLoader
extends ClusterStorage {
    private static final Logger log = LoggerFactory.getLogger(ProxyLoader.class);
    HashMap<ItemPath, Item> entities = new HashMap();
    Lookup lookup;

    @Override
    public void open(Authenticator auth) throws PersistencyException {
        this.lookup = Gateway.getLookup();
    }

    @Override
    public void postBoostrap() {
    }

    @Override
    public void postStartServer() {
    }

    @Override
    public void postConnect() {
    }

    @Override
    public void close() throws PersistencyException {
    }

    @Override
    public boolean checkQuerySupport(String language) {
        log.warn("ProxyLoader DOES NOT Support any query");
        return false;
    }

    @Override
    public short queryClusterSupport(String clusterType) {
        return 1;
    }

    @Override
    public String getName() {
        return "Proxy Cluster Loader";
    }

    @Override
    public String getId() {
        return "CORBA";
    }

    @Override
    public String executeQuery(Query query) throws PersistencyException {
        throw new PersistencyException("UNIMPLEMENTED funnction");
    }

    @Override
    public C2KLocalObject get(ItemPath thisItem, String path) throws PersistencyException {
        try {
            Item thisEntity = this.getIOR(thisItem);
            ClusterType type = ProxyLoader.getClusterType(path);
            String queryData = thisEntity.queryData(path);
            log.trace("get() - {} : {} = {}", new java.lang.Object[]{thisItem, path, queryData});
            if (queryData != null) {
                if (type == ClusterType.OUTCOME) {
                    return new Outcome(path, queryData);
                }
                return (C2KLocalObject)Gateway.getMarshaller().unmarshall(queryData);
            }
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new PersistencyException(e.getMessage());
        }
        return null;
    }

    @Override
    public void put(ItemPath thisItem, C2KLocalObject obj) throws PersistencyException {
        throw new PersistencyException("Cannot write to items through the ProxyLoader");
    }

    @Override
    public void delete(ItemPath thisItem, String path) throws PersistencyException {
        throw new PersistencyException("Cannot write to items through the ProxyLoader");
    }

    @Override
    public String[] getClusterContents(ItemPath thisItem, String path) throws PersistencyException {
        try {
            Item thisEntity = this.getIOR(thisItem);
            String contents = thisEntity.queryData(path + "/all");
            StringTokenizer tok = new StringTokenizer(contents, ",");
            String[] result = new String[tok.countTokens()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = tok.nextToken();
            }
            return result;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new PersistencyException(e.getMessage());
        }
    }

    private Item getIOR(ItemPath thisPath) throws PersistencyException {
        if (this.entities.containsKey(thisPath)) {
            log.trace("getIOR() - " + thisPath + " cached.");
            return this.entities.get(thisPath);
        }
        try {
            log.trace("getIOR() - Resolving " + thisPath + ".");
            Object ior = thisPath.getIOR();
            Item thisItem = null;
            try {
                thisItem = ItemHelper.narrow((Object)ior);
            }
            catch (BAD_PARAM ex) {
                try {
                    thisItem = AgentHelper.narrow((Object)ior);
                }
                catch (BAD_PARAM ex2) {
                    throw new PersistencyException("Could not narrow " + thisItem + " as a known Entity type");
                }
            }
            log.trace("getIOR() - Found " + thisItem + ".");
            this.entities.put(thisPath, thisItem);
            return thisItem;
        }
        catch (Exception e) {
            throw new PersistencyException("Error narrowing " + thisPath + ": " + e.getMessage());
        }
    }
}

