/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.agent;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.RemoteMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobList
extends RemoteMap<Job> {
    private static final Logger log = LoggerFactory.getLogger(JobList.class);
    private static final long serialVersionUID = -1110616958817712975L;

    public JobList(AgentPath agentPath, Object locker) {
        super(agentPath, ClusterType.JOB.getName(), locker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(Job job) {
        JobList jobList = this;
        synchronized (jobList) {
            int jobId = this.getLastId() + 1;
            job.setId(jobId);
            this.put(String.valueOf(jobId), job);
        }
    }

    @Override
    public ClusterType getClusterType() {
        return null;
    }

    public Job getJob(int id) {
        return (Job)this.get(String.valueOf(id));
    }

    public void removeJobsForItem(ItemPath itemPath) {
        Iterator currentMembers = this.values().iterator();
        Job j = null;
        while (currentMembers.hasNext()) {
            j = (Job)currentMembers.next();
            if (!j.getItemPath().equals(itemPath)) continue;
            this.remove(String.valueOf(j.getId()));
        }
        log.info("JobList::removeJobsWithSysKey() - " + itemPath + " DONE.");
    }

    public List<String> getKeysForStep(ItemPath itemPath, String stepPath) {
        ArrayList<String> jobKeys = new ArrayList<String>();
        for (String jid : this.keySet()) {
            Job j = (Job)this.get(jid);
            if (!j.getItemPath().equals(itemPath) || !j.getStepPath().equals(stepPath)) continue;
            jobKeys.add(jid);
        }
        return jobKeys;
    }

    public void removeJobsForStep(ItemPath itemPath, String stepPath) {
        List<String> staleJobs = this.getKeysForStep(itemPath, stepPath);
        log.info("JobList.removeJobsForStep() - removing " + staleJobs.size());
        for (String jid : staleJobs) {
            this.remove(jid);
        }
        log.info("JobList::removeJobsForStep() - " + itemPath + " DONE.");
    }

    public Vector<Job> getJobsOfItem(ItemPath itemPath) {
        Iterator currentMembers = this.values().iterator();
        Job j = null;
        Vector<Job> jobs = new Vector<Job>();
        while (currentMembers.hasNext()) {
            j = (Job)currentMembers.next();
            if (!j.getItemPath().equals(itemPath)) continue;
            jobs.add(j);
        }
        log.info("JobList::getJobsOfSysKey() - returning " + jobs.size() + " Jobs.");
        return jobs;
    }

    public void dump(int logLevel) {
        StringBuffer sb = new StringBuffer("{ ");
        for (String jid : this.keySet()) {
            Job j = (Job)this.get(jid);
            sb.append("[id:" + jid + " ");
            sb.append("step:" + j.getStepName() + " ");
            sb.append("role:" + j.getAgentRole() + " ");
            sb.append("trans:" + j.getTransition().getName() + "] ");
        }
        sb.append("}");
        log.info("Joblist " + sb);
    }
}

