/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.persistency;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.entity.agent.JobList;
import org.cristalise.kernel.events.History;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterStorage;
import org.cristalise.kernel.persistency.ClusterStorageManager;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.AbstractMain;
import org.cristalise.kernel.process.auth.Authenticator;
import org.cristalise.kernel.querying.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionManager {
    private static final Logger log = LoggerFactory.getLogger(TransactionManager.class);
    private HashMap<ItemPath, Object> locks;
    HashMap<Object, ArrayList<TransactionEntry>> pendingTransactions;
    ClusterStorageManager storage;

    public TransactionManager(Authenticator auth) throws PersistencyException {
        this.storage = new ClusterStorageManager(auth);
        this.locks = new HashMap();
        this.pendingTransactions = new HashMap();
    }

    public boolean hasPendingTransactions() {
        return this.pendingTransactions.size() > 0;
    }

    public ClusterStorageManager getDb() {
        return this.storage;
    }

    public void close() {
        if (this.pendingTransactions.size() != 0) {
            log.error("There were pending transactions on shutdown. All changes were lost.");
            this.dumpPendingTransactions(0);
        }
        log.info("Transaction Manager: Closing storages");
        this.storage.close();
    }

    public String executeQuery(Query query) throws PersistencyException {
        return this.storage.executeQuery(query);
    }

    public String[] getClusterContents(ItemPath itemPath, ClusterType type) throws PersistencyException {
        return this.getClusterContents(itemPath, type, null);
    }

    public String[] getClusterContents(ItemPath itemPath, ClusterType type, Object locker) throws PersistencyException {
        return this.getClusterContents(itemPath, type.getName(), locker);
    }

    public String[] getClusterContents(ItemPath itemPath, String path) throws PersistencyException {
        return this.getClusterContents(itemPath, path, null);
    }

    public String[] getClusterContents(ItemPath itemPath, String path, Object locker) throws PersistencyException {
        if (path.startsWith("/") && path.length() > 1) {
            path = path.substring(1);
        }
        ArrayList<String> uncomittedContents = new ArrayList<String>();
        if (this.locks.containsKey(itemPath) && this.locks.get(itemPath).equals(locker)) {
            for (TransactionEntry thisEntry : this.pendingTransactions.get(locker)) {
                if (!itemPath.equals(thisEntry.itemPath) || !thisEntry.path.startsWith(path)) continue;
                if (thisEntry.obj == null) {
                    throw new PersistencyException("TransactionManager.get() - Cluster " + path + " has been deleted in " + itemPath + " but not yet committed");
                }
                String content = StringUtils.substringAfterLast((String)thisEntry.path, (String)"/");
                uncomittedContents.add(content);
            }
        }
        return (String[])ArrayUtils.addAll((Object[])this.storage.getClusterContents(itemPath, path), (Object[])uncomittedContents.toArray(new String[uncomittedContents.size()]));
    }

    public C2KLocalObject get(ItemPath itemPath, String path, Object locker) throws PersistencyException, ObjectNotFoundException {
        if (path.startsWith("/") && path.length() > 1) {
            path = path.substring(1);
        }
        if (path.indexOf(47) == -1) {
            if (path.equals((Object)ClusterType.HISTORY) && locker != null) {
                return new History(itemPath, locker);
            }
            if (path.equals((Object)ClusterType.JOB) && locker != null) {
                if (itemPath instanceof AgentPath) {
                    return new JobList((AgentPath)itemPath, locker);
                }
                throw new ObjectNotFoundException("TransactionManager.get() - Items do not have job lists");
            }
        }
        if (this.locks.containsKey(itemPath) && this.locks.get(itemPath).equals(locker)) {
            ArrayList<TransactionEntry> lockerTransaction = this.pendingTransactions.get(locker);
            for (TransactionEntry thisEntry : lockerTransaction) {
                if (!itemPath.equals(thisEntry.itemPath) || !path.equals(thisEntry.path)) continue;
                if (thisEntry.obj == null) {
                    throw new PersistencyException("TransactionManager.get() - Cluster " + path + " has been deleted in " + itemPath + " but not yet committed");
                }
                return thisEntry.obj;
            }
        }
        return this.storage.get(itemPath, path);
    }

    public void put(ItemPath itemPath, C2KLocalObject obj, Object locker) throws PersistencyException {
        ArrayList<TransactionEntry> lockingTransaction = this.getLockingTransaction(itemPath, locker);
        if (lockingTransaction == null) {
            this.storage.put(itemPath, obj);
            this.locks.remove(itemPath);
        } else {
            this.createTransactionEntry(itemPath, obj, null, lockingTransaction);
        }
    }

    public void remove(ItemPath itemPath, String path, Object locker) throws PersistencyException {
        ArrayList<TransactionEntry> lockingTransaction = this.getLockingTransaction(itemPath, locker);
        if (lockingTransaction == null) {
            this.storage.remove(itemPath, path);
            this.locks.remove(itemPath);
        } else {
            this.createTransactionEntry(itemPath, null, path, lockingTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ArrayList<TransactionEntry> getLockingTransaction(ItemPath itemPath, Object locker) throws PersistencyException {
        HashMap<ItemPath, Object> hashMap = this.locks;
        synchronized (hashMap) {
            if (this.locks.containsKey(itemPath)) {
                Object thisLocker = this.locks.get(itemPath);
                if (!thisLocker.equals(locker)) throw new PersistencyException("Access denied: '" + itemPath + "' has been locked for writing by " + thisLocker);
                return this.pendingTransactions.get(locker);
            }
            if (locker == null) {
                this.locks.put(itemPath, new Object());
                return null;
            }
            this.locks.put(itemPath, locker);
            ArrayList<TransactionEntry> lockerTransaction = new ArrayList();
            this.pendingTransactions.put(locker, lockerTransaction);
            return lockerTransaction;
        }
    }

    private void createTransactionEntry(ItemPath itemPath, C2KLocalObject obj, String path, ArrayList<TransactionEntry> lockerTransaction) throws PersistencyException {
        TransactionEntry newEntry;
        if (obj != null) {
            newEntry = new TransactionEntry(itemPath, obj);
        } else if (path != null) {
            newEntry = new TransactionEntry(itemPath, path);
        } else {
            throw new PersistencyException("");
        }
        if (lockerTransaction.contains(newEntry)) {
            lockerTransaction.remove(newEntry);
        }
        lockerTransaction.add(newEntry);
    }

    public void removeCluster(ItemPath itemPath, String path, Object locker) throws PersistencyException {
        String[] children;
        for (String element : children = this.getClusterContents(itemPath, path)) {
            this.removeCluster(itemPath, path + (path.length() > 0 ? "/" : "") + element, locker);
        }
        if (children.length == 0 && path.indexOf("/") > -1) {
            this.remove(itemPath, path, locker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Object locker) throws PersistencyException {
        HashMap<ItemPath, Object> hashMap = this.locks;
        synchronized (hashMap) {
            ArrayList<TransactionEntry> lockerTransactions = this.pendingTransactions.get(locker);
            if (lockerTransactions == null) {
                return;
            }
            try {
                this.storage.begin(locker);
                for (TransactionEntry thisEntry : lockerTransactions) {
                    if (thisEntry.obj == null) {
                        this.storage.remove(thisEntry.itemPath, thisEntry.path, locker);
                        continue;
                    }
                    this.storage.put(thisEntry.itemPath, thisEntry.obj, locker);
                }
                this.storage.commit(locker);
                for (TransactionEntry thisEntry : lockerTransactions) {
                    this.locks.remove(thisEntry.itemPath);
                }
                this.pendingTransactions.remove(locker);
            }
            catch (Exception e) {
                this.storage.abort(locker);
                log.error("commit() - Problems during transaction commit of locker " + locker.toString() + ". Database may be in an inconsistent state.");
                this.dumpPendingTransactions(0);
                AbstractMain.shutdown(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort(Object locker) {
        HashMap<ItemPath, Object> hashMap = this.locks;
        synchronized (hashMap) {
            if (this.locks.containsValue(locker)) {
                for (ItemPath thisPath : this.locks.keySet()) {
                    if (!this.locks.get(thisPath).equals(locker)) continue;
                    this.locks.remove(thisPath);
                }
            }
            this.pendingTransactions.remove(locker);
        }
    }

    public void clearCache(ItemPath itemPath, String path) {
        if (itemPath == null) {
            this.storage.clearCache();
        } else if (path == null) {
            this.storage.clearCache(itemPath);
        } else {
            this.storage.clearCache(itemPath, path);
        }
    }

    public void dumpPendingTransactions(int logLevel) {
        log.error("Transaction dump. Locked Items:");
        if (this.locks.size() == 0) {
            log.error("  None");
        } else {
            for (ItemPath thisPath : this.locks.keySet()) {
                Object locker = this.locks.get(thisPath);
                log.error("  " + thisPath + " locked by " + locker);
            }
        }
        log.error("Open transactions:");
        if (this.pendingTransactions.size() == 0) {
            log.error("  None");
        } else {
            for (Object thisLocker : this.pendingTransactions.keySet()) {
                log.error("  Transaction owner:" + thisLocker);
                ArrayList<TransactionEntry> entries = this.pendingTransactions.get(thisLocker);
                for (TransactionEntry thisEntry : entries) {
                    log.error("    " + thisEntry.toString());
                }
            }
        }
    }

    public void postConnect() throws PersistencyException {
        this.storage.postConnect();
    }

    public void postBoostrap() throws PersistencyException {
        this.storage.postBoostrap();
    }

    public void postStartServer() throws PersistencyException {
        this.storage.postStartServer();
    }

    public int getLastIntegerId(ItemPath itemPath, String path) throws PersistencyException {
        return this.storage.getLastIntegerId(itemPath, path);
    }

    static class TransactionEntry {
        public ItemPath itemPath;
        public String path;
        public C2KLocalObject obj;

        public TransactionEntry(ItemPath itemPath, C2KLocalObject obj) {
            this.itemPath = itemPath;
            this.path = ClusterStorage.getPath(obj);
            this.obj = obj;
        }

        public TransactionEntry(ItemPath itemPath, String path) {
            this.itemPath = itemPath;
            this.path = path;
            this.obj = null;
        }

        public String toString() {
            StringBuffer report = new StringBuffer();
            if (this.obj == null) {
                report.append("Delete");
            } else {
                report.append("Put " + this.obj.getClass().getName());
            }
            report.append(" at ").append(this.path).append(" in ").append(this.itemPath);
            return report.toString();
        }

        public int hashCode() {
            return this.itemPath.hashCode() * this.path.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof TransactionEntry) {
                return this.hashCode() == ((TransactionEntry)other).hashCode();
            }
            return false;
        }
    }
}

