/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process.module;

import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.module.ModuleImport;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.process.resource.ResourceImportHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleResource
extends ModuleImport {
    private static final Logger log = LoggerFactory.getLogger(ModuleResource.class);
    public int version = 0;
    public BuiltInResources type;
    public String resourceLocation;
    String resourceChangeDetails = null;

    public String getResourceType() {
        return this.type.getTypeCode();
    }

    public void setResourceType(String typeCode) {
        this.type = BuiltInResources.getValue(typeCode);
    }

    public String getResourceDir() {
        return "boot/" + this.type.getTypeCode();
    }

    public String getResourceExt() {
        return this.type == BuiltInResources.SCHEMA_RESOURCE ? "xsd" : "xml";
    }

    public String getResourceLocation() {
        if (StringUtils.isBlank((CharSequence)this.resourceLocation) && this.ns != null) {
            this.resourceLocation = Gateway.getProperties().getString("Resource.moduleUseFileNameWithVersion", "").equals(this.ns) ? this.getResourceDir() + "/" + this.name + "_" + this.version + "." + this.getResourceExt() : this.getResourceDir() + "/" + this.name + "." + this.getResourceExt();
        }
        return this.resourceLocation;
    }

    @Override
    public Path create(AgentPath agentPath, boolean reset) throws ObjectNotFoundException, ObjectCannotBeUpdated, CannotManageException, ObjectAlreadyExistsException, InvalidDataException {
        try {
            ResourceImportHandler importHandler = Gateway.getResourceImportHandler(this.type);
            this.domainPath = importHandler.importResource(this.ns, this.name, this.version, this.itemPath, this.getResourceLocation(), reset);
            this.resourceChangeDetails = importHandler.getResourceChangeDetails();
            if (this.itemPath == null) {
                this.itemPath = this.domainPath.getItemPath();
            }
            return this.domainPath;
        }
        catch (Exception e) {
            log.error("Exception verifying module resource {}/{}", new Object[]{this.ns, this.name, e});
            throw new CannotManageException("Exception verifying module resource " + this.ns + "/" + this.name);
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.type.getTypeCode().hashCode() + this.version;
    }

    public int getVersion() {
        return this.version;
    }

    public BuiltInResources getType() {
        return this.type;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setType(BuiltInResources type) {
        this.type = type;
    }

    public void setResourceLocation(String resourceLocation) {
        this.resourceLocation = resourceLocation;
    }

    public void setResourceChangeDetails(String resourceChangeDetails) {
        this.resourceChangeDetails = resourceChangeDetails;
    }

    public String getResourceChangeDetails() {
        return this.resourceChangeDetails;
    }
}

