/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.storage;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterStorage;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.auth.Authenticator;
import org.cristalise.kernel.querying.Query;
import org.cristalise.kernel.utils.FileStringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLClusterStorage
extends ClusterStorage {
    private static final Logger log = LoggerFactory.getLogger(XMLClusterStorage.class);
    String rootDir = null;
    String fileExtension = ".xml";
    boolean useDirectories = true;

    public XMLClusterStorage() {
    }

    public XMLClusterStorage(String root) {
        this(root, null, null);
    }

    public XMLClusterStorage(String root, String ext, Boolean useDir) {
        this.rootDir = new File(root).getAbsolutePath();
        if (ext != null) {
            this.fileExtension = ext;
        }
        if (useDir != null) {
            this.useDirectories = useDir;
        }
    }

    @Override
    public void open(Authenticator auth) throws PersistencyException {
        if (StringUtils.isBlank((CharSequence)this.rootDir)) {
            String rootProp = Gateway.getProperties().getString("XMLStorage.root");
            if (rootProp == null) {
                throw new PersistencyException("XMLClusterStorage.open() - Root path not given in config file.");
            }
            this.rootDir = new File(rootProp).getAbsolutePath();
        }
        if (!FileStringUtility.checkDir(this.rootDir)) {
            log.error("XMLClusterStorage.open() - Path " + this.rootDir + "' does not exist. Attempting to create.");
            boolean success = FileStringUtility.createNewDir(this.rootDir);
            if (!success) {
                throw new PersistencyException("XMLClusterStorage.open() - Could not create dir " + this.rootDir + ". Cannot continue.");
            }
        }
        log.info("open() - DONE rootDir:'" + this.rootDir + "' ext:'" + this.fileExtension + "' userDir:" + this.useDirectories);
    }

    @Override
    public void close() {
        this.rootDir = null;
    }

    @Override
    public void postBoostrap() {
    }

    @Override
    public void postStartServer() {
    }

    @Override
    public void postConnect() {
    }

    @Override
    public short queryClusterSupport(String clusterType) {
        return 3;
    }

    @Override
    public String getName() {
        return "XML File Cluster Storage";
    }

    @Override
    public String getId() {
        return "XML";
    }

    @Override
    public boolean checkQuerySupport(String language) {
        log.warn("XMLClusterStorage DOES NOT Support any query");
        return false;
    }

    @Override
    public String executeQuery(Query query) throws PersistencyException {
        throw new PersistencyException("UNIMPLEMENTED funnction");
    }

    @Override
    public C2KLocalObject get(ItemPath itemPath, String path) throws PersistencyException {
        try {
            ClusterType type = ClusterStorage.getClusterType(path);
            String filePath = this.getFilePath(itemPath, path) + this.fileExtension;
            String objString = FileStringUtility.file2String(filePath);
            if (objString.length() == 0) {
                return null;
            }
            log.trace("get() - objString:" + objString);
            if (type == ClusterType.OUTCOME) {
                return new Outcome(path, objString);
            }
            return (C2KLocalObject)Gateway.getMarshaller().unmarshall(objString);
        }
        catch (Exception e) {
            log.error("get() - The path " + path + " from " + itemPath + " does not exist", (Throwable)e);
            throw new PersistencyException(e.getMessage());
        }
    }

    @Override
    public void put(ItemPath itemPath, C2KLocalObject obj) throws PersistencyException {
        try {
            boolean success;
            String filePath = this.getFilePath(itemPath, XMLClusterStorage.getPath(obj) + this.fileExtension);
            log.trace("put() - Writing " + filePath);
            String data = Gateway.getMarshaller().marshall(obj);
            String dir = filePath.substring(0, filePath.lastIndexOf(47));
            if (!FileStringUtility.checkDir(dir) && !(success = FileStringUtility.createNewDir(dir))) {
                throw new PersistencyException("XMLClusterStorage.put() - Could not create dir " + dir + ". Cannot continue.");
            }
            FileStringUtility.string2File(filePath, data);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new PersistencyException("XMLClusterStorage.put() - Could not write " + XMLClusterStorage.getPath(obj) + " to " + itemPath);
        }
    }

    @Override
    public void delete(ItemPath itemPath, String path) throws PersistencyException {
        try {
            String filePath = this.getFilePath(itemPath, path + this.fileExtension);
            boolean success = FileStringUtility.deleteDir(filePath, true, true);
            if (success) {
                return;
            }
            filePath = this.getFilePath(itemPath, path);
            success = FileStringUtility.deleteDir(filePath, true, true);
            if (success) {
                return;
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new PersistencyException("XMLClusterStorage.delete() - Failure deleting path " + path + " in " + itemPath + " Error: " + e.getMessage());
        }
        throw new PersistencyException("XMLClusterStorage.delete() - Failure deleting path " + path + " in " + itemPath);
    }

    @Override
    public String[] getClusterContents(ItemPath itemPath, String path) throws PersistencyException {
        try {
            if (this.useDirectories) {
                return this.getContentsFromDirectories(itemPath, path);
            }
            return this.getContentsFromFileNames(itemPath, path);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new PersistencyException("XMLClusterStorage.getClusterContents(" + itemPath + ") - Could not get contents of " + path + " from " + itemPath + ": " + e.getMessage());
        }
    }

    private String[] getContentsFromFileNames(ItemPath itemPath, String path) throws IOException {
        TreeSet result = new TreeSet();
        String resource = this.getResourceName(path);
        try (Stream<Path> pathes = Files.list(Paths.get(this.rootDir + "/" + itemPath.getUUID(), new String[0]));){
            pathes.filter(p -> p.getFileName().toString().startsWith(resource)).forEach(p -> {
                int i;
                String fileName = p.getFileName().toString();
                String content = resource.length() != 0 ? fileName.substring(resource.length() + 1) : fileName.substring(resource.length());
                log.trace("getContentsFromFileNames() - resource:'" + resource + "' fileName:'" + fileName + "' content:'" + content + "'");
                if (content.endsWith(this.fileExtension)) {
                    content = content.substring(0, content.length() - this.fileExtension.length());
                }
                if ((i = content.indexOf(46)) != -1) {
                    content = content.substring(0, i);
                }
                result.add(content);
            });
        }
        return result.toArray(new String[0]);
    }

    private String[] getContentsFromDirectories(ItemPath itemPath, String path) {
        String[] result = new String[]{};
        String filePath = this.getFilePath(itemPath, path);
        ArrayList<String> paths = FileStringUtility.listDir(filePath, true, false);
        if (paths == null) {
            return result;
        }
        ArrayList<String> contents = new ArrayList<String>();
        String previous = null;
        for (int i = 0; i < paths.size(); ++i) {
            String next = paths.get(i);
            if (next.endsWith(this.fileExtension)) {
                next = next.substring(0, next.length() - this.fileExtension.length());
            }
            if (next.equals(previous)) continue;
            previous = next;
            if (next.indexOf(47) > -1) {
                next = next.substring(next.lastIndexOf(47) + 1);
            }
            contents.add(next);
        }
        result = contents.toArray(result);
        return result;
    }

    protected String getFilePath(ItemPath itemPath, String path) {
        path = this.getResourceName(path);
        String filePath = this.rootDir + "/" + itemPath.getUUID() + "/" + path;
        log.trace("getFilePath() - " + filePath);
        return filePath;
    }

    protected String getResourceName(String path) {
        if (path.length() != 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if (!this.useDirectories) {
            path = path.replace("/", ".");
        }
        return path;
    }

    @Override
    public int getLastIntegerId(ItemPath itemPath, String path) throws PersistencyException {
        int lastId = -1;
        try {
            String[] keys;
            for (String key : keys = this.getClusterContents(itemPath, path)) {
                int newId = Integer.parseInt(key);
                lastId = newId > lastId ? newId : lastId;
            }
        }
        catch (NumberFormatException e) {
            log.error("Error parsing keys", (Throwable)e);
            throw new PersistencyException(e.getMessage());
        }
        return lastId;
    }
}

