/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.proxy;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.DomainPathSubscriber;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.entity.proxy.ProxyMessage;
import org.cristalise.kernel.entity.proxy.ProxyMessageListener;
import org.cristalise.kernel.entity.proxy.ProxyServerConnection;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.utils.SoftCache;
import org.omg.CORBA.Object;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyManager {
    private static final Logger log = LoggerFactory.getLogger(ProxyManager.class);
    public static final String CONFIG_STRICT_POLICY = "ProxyManager.strictPolicy";
    SoftCache<ItemPath, ItemProxy> proxyPool = new SoftCache(50);
    HashMap<DomainPathSubscriber, DomainPath> treeSubscribers = new HashMap();
    HashMap<String, ProxyServerConnection> connections = new HashMap();
    ProxyMessageListener messageListener = null;

    public ProxyManager() throws InvalidDataException {
        Iterator<Path> servers = Gateway.getLookup().search((Path)new DomainPath("/servers"), new Property(BuiltInItemProperties.TYPE, "Server", false));
        while (servers.hasNext()) {
            Path thisServerResult = servers.next();
            try {
                ItemPath thisServerPath = thisServerResult.getItemPath();
                String remoteServer = ((Property)Gateway.getStorage().get(thisServerPath, (java.lang.Object)((java.lang.Object)ClusterType.PROPERTY) + "/" + (java.lang.Object)((java.lang.Object)BuiltInItemProperties.NAME), null)).getValue();
                String portStr = ((Property)Gateway.getStorage().get(thisServerPath, (java.lang.Object)((java.lang.Object)ClusterType.PROPERTY) + "/ProxyPort", null)).getValue();
                this.connectToProxyServer(remoteServer, Integer.parseInt(portStr));
            }
            catch (Exception ex) {
                log.error("Exception retrieving proxy server connection data for " + thisServerResult, (Throwable)ex);
            }
        }
        try {
            if (Gateway.getProperties().containsKey("ProxyMessageListener")) {
                this.messageListener = (ProxyMessageListener)Gateway.getProperties().getInstance("ProxyMessageListener");
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            log.error("", (Throwable)e);
            throw new InvalidDataException(e.getMessage());
        }
    }

    public void connectToProxyServer(String name, int port) {
        ProxyServerConnection oldConn = this.connections.get(name);
        if (oldConn != null) {
            oldConn.shutdown();
        }
        this.connections.put(name, new ProxyServerConnection(name, port, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resubscribe(ProxyServerConnection conn) {
        SoftCache<ItemPath, ItemProxy> softCache = this.proxyPool;
        synchronized (softCache) {
            for (ItemPath key : this.proxyPool.keySet()) {
                ProxyMessage sub = new ProxyMessage(key, "add", false);
                log.debug("resubscribe() - item:{}", (java.lang.Object)key);
                conn.sendMessage(sub);
            }
        }
    }

    private void sendMessage(ProxyMessage sub) {
        for (ProxyServerConnection element : this.connections.values()) {
            element.sendMessage(sub);
        }
    }

    public void shutdown() {
        log.info("shutdown() - flagging shutdown of server connections");
        for (ProxyServerConnection element : this.connections.values()) {
            element.shutdown();
        }
    }

    protected void processMessage(ProxyMessage thisMessage) throws InvalidDataException {
        log.debug("processMessage() - Received proxy message:{}", (java.lang.Object)thisMessage);
        if (thisMessage.getPath().equals("ping")) {
            return;
        }
        if (thisMessage.getItemPath() == null) {
            this.informTreeSubscribers(thisMessage.isState(), thisMessage.getPath());
        } else {
            ItemProxy relevant = this.proxyPool.get(thisMessage.getItemPath());
            if (relevant == null) {
                log.warn("processMessage() - Received message for which there is no proxy - message:{}", (java.lang.Object)thisMessage);
            } else {
                try {
                    log.trace("processMessage() - notify relevant '{}' of proxy message:{}", (java.lang.Object)relevant, (java.lang.Object)thisMessage);
                    relevant.notify(thisMessage);
                }
                catch (Throwable ex) {
                    log.error("Error caught notifying relevant '{}' of proxy message:{}", new java.lang.Object[]{relevant, thisMessage, ex});
                }
            }
        }
        if (this.messageListener != null) {
            this.messageListener.notifyMessage(thisMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void informTreeSubscribers(boolean state, String path) {
        DomainPath last = new DomainPath(path);
        boolean first = true;
        HashMap<DomainPathSubscriber, DomainPath> hashMap = this.treeSubscribers;
        synchronized (hashMap) {
            DomainPath parent;
            while ((parent = last.getParent()) != null) {
                ArrayList<DomainPathSubscriber> currentKeys = new ArrayList<DomainPathSubscriber>();
                currentKeys.addAll(this.treeSubscribers.keySet());
                for (DomainPathSubscriber sub : currentKeys) {
                    DomainPath interest = this.treeSubscribers.get(sub);
                    if (interest == null || !interest.equals(parent)) continue;
                    if (!state) {
                        sub.pathAdded(last);
                        continue;
                    }
                    if (!first) continue;
                    sub.pathRemoved(last);
                }
                last = parent;
                first = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeTree(DomainPathSubscriber sub, DomainPath interest) {
        HashMap<DomainPathSubscriber, DomainPath> hashMap = this.treeSubscribers;
        synchronized (hashMap) {
            this.treeSubscribers.put(sub, interest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeTree(DomainPathSubscriber sub) {
        HashMap<DomainPathSubscriber, DomainPath> hashMap = this.treeSubscribers;
        synchronized (hashMap) {
            this.treeSubscribers.remove(sub);
        }
    }

    private ItemProxy createProxy(Object ior, ItemPath itemPath) throws ObjectNotFoundException {
        ItemProxy newProxy = null;
        log.debug("createProxy() - Item:{}", (java.lang.Object)itemPath);
        newProxy = itemPath instanceof AgentPath ? new AgentProxy(ior, (AgentPath)itemPath) : new ItemProxy(ior, itemPath);
        ProxyMessage sub = new ProxyMessage(itemPath, "add", false);
        this.sendMessage(sub);
        this.reportCurrentProxies(9);
        return newProxy;
    }

    protected void removeProxy(ItemPath itemPath) {
        ProxyMessage sub = new ProxyMessage(itemPath, "del", true);
        log.debug("removeProxy() - Unsubscribing to proxy informer for {}", (java.lang.Object)itemPath);
        this.sendMessage(sub);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ItemProxy getProxy(Object ior, ItemPath itemPath) throws ObjectNotFoundException {
        SoftCache<ItemPath, ItemProxy> softCache = this.proxyPool;
        synchronized (softCache) {
            ItemProxy newProxy = this.proxyPool.get(itemPath);
            if (newProxy == null) {
                newProxy = this.createProxy(ior, itemPath);
                this.proxyPool.put(itemPath, newProxy);
            }
            return newProxy;
        }
    }

    public ItemProxy getProxy(Path path) throws ObjectNotFoundException {
        ItemPath itemPath = null;
        log.trace("getProxy(" + path.toString() + ")");
        if (path instanceof ItemPath) {
            try {
                itemPath = Gateway.getLookup().getItemPath(((ItemPath)path).getUUID().toString());
            }
            catch (InvalidItemPathException e) {
                throw new ObjectNotFoundException(e.getMessage());
            }
        } else if (path instanceof DomainPath) {
            ((DomainPath)path).setTargetUUID(null);
            itemPath = path.getItemPath();
        }
        if (itemPath == null) {
            throw new ObjectNotFoundException("Cannot use RolePath");
        }
        return this.getProxy(itemPath.getIOR(), itemPath);
    }

    public AgentProxy getAgentProxy(String agentName) throws ObjectNotFoundException {
        AgentPath path = Gateway.getLookup().getAgentPath(agentName);
        return (AgentProxy)this.getProxy(path);
    }

    public AgentProxy getAgentProxy(AgentPath path) throws ObjectNotFoundException {
        return (AgentProxy)this.getProxy(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportCurrentProxies(int logLevel) {
        log.trace("Current proxies: ");
        try {
            SoftCache<ItemPath, ItemProxy> softCache = this.proxyPool;
            synchronized (softCache) {
                Iterator<ItemPath> i = this.proxyPool.keySet().iterator();
                int count = 0;
                while (i.hasNext()) {
                    ItemPath nextProxy = i.next();
                    ItemProxy thisProxy = this.proxyPool.get(nextProxy);
                    if (thisProxy != null) {
                        log.trace("" + count + ": " + this.proxyPool.get(nextProxy).getClass().getName() + ": " + nextProxy);
                    }
                    ++count;
                }
            }
        }
        catch (ConcurrentModificationException ex) {
            log.trace("Proxy cache modified. Aborting.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        SoftCache<ItemPath, ItemProxy> softCache = this.proxyPool;
        synchronized (softCache) {
            this.proxyPool.clear();
        }
        log.debug("clearCache() - DONE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache(ItemPath item) {
        SoftCache<ItemPath, ItemProxy> softCache = this.proxyPool;
        synchronized (softCache) {
            if (this.proxyPool.remove(item) != null) {
                log.debug("clearCache({}) - Item was removed from cache", (java.lang.Object)item);
            } else {
                log.trace("clearCache({}) - Item was NOT in cache", (java.lang.Object)item);
            }
        }
    }
}

