/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.utils;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class SoftCache<K, V>
extends AbstractMap<K, V> {
    private final Map<K, SoftValue<V>> hash = new HashMap<K, SoftValue<V>>();
    private final int minSize;
    private final LinkedList<V> hardCache = new LinkedList();
    private final ReferenceQueue<V> queue = new ReferenceQueue();

    public SoftCache() {
        this(0);
    }

    public SoftCache(int minSize) {
        this.minSize = minSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        Object result = null;
        SoftValue<V> soft_ref = this.hash.get(key);
        if (soft_ref != null) {
            result = soft_ref.get();
            if (result == null) {
                this.hash.remove(key);
            } else if (this.minSize > 0) {
                LinkedList<V> linkedList = this.hardCache;
                synchronized (linkedList) {
                    this.hardCache.addFirst(result);
                    if (this.hardCache.size() > this.minSize) {
                        this.hardCache.removeLast();
                    }
                }
            }
        }
        return (V)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        this.processQueue();
        if (this.minSize > 0) {
            LinkedList<V> linkedList = this.hardCache;
            synchronized (linkedList) {
                this.hardCache.addFirst(value);
                if (this.hardCache.size() > this.minSize) {
                    this.hardCache.removeLast();
                }
            }
        }
        this.hash.put(key, new SoftValue(key, value, this.queue));
        return value;
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        if (this.hash.containsKey(key)) {
            return (V)this.hash.remove(key).get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        LinkedList<V> linkedList = this.hardCache;
        synchronized (linkedList) {
            this.hardCache.clear();
        }
        while (this.queue.poll() != null) {
        }
        this.hash.clear();
    }

    @Override
    public int size() {
        this.processQueue();
        return this.hash.size();
    }

    @Override
    public Set<K> keySet() {
        this.processQueue();
        return this.hash.keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    private void processQueue() {
        SoftValue sv;
        while ((sv = (SoftValue)this.queue.poll()) != null) {
            this.hash.remove(sv.key);
        }
    }

    private static class SoftValue<V>
    extends SoftReference<V> {
        private final Object key;

        private SoftValue(Object key, V value, ReferenceQueue<V> q) {
            super(value, q);
            this.key = key;
        }
    }
}

