/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import org.cristalise.kernel.collection.BuiltInCollections;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.graph.model.DirectedEdge;
import org.cristalise.kernel.graph.model.GraphModel;
import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.graph.model.GraphableVertex;
import org.cristalise.kernel.graph.model.TypeNameAndConstructionInfo;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.lifecycle.ActivityDef;
import org.cristalise.kernel.lifecycle.ActivitySlotDef;
import org.cristalise.kernel.lifecycle.AndSplitDef;
import org.cristalise.kernel.lifecycle.JoinDef;
import org.cristalise.kernel.lifecycle.LifecycleVertexOutlineCreator;
import org.cristalise.kernel.lifecycle.LoopDef;
import org.cristalise.kernel.lifecycle.NextDef;
import org.cristalise.kernel.lifecycle.OrSplitDef;
import org.cristalise.kernel.lifecycle.WfVertexDef;
import org.cristalise.kernel.lifecycle.XOrSplitDef;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.Next;
import org.cristalise.kernel.lifecycle.instance.WfVertex;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NodeList;

public class CompositeActivityDef
extends ActivityDef {
    private static final Logger log = LoggerFactory.getLogger(CompositeActivityDef.class);
    private ArrayList<ActivityDef> refChildActDef = new ArrayList();
    private final TypeNameAndConstructionInfo[] mVertexTypeNameAndConstructionInfo = new TypeNameAndConstructionInfo[]{new TypeNameAndConstructionInfo("Activity", "Atomic"), new TypeNameAndConstructionInfo("Local Activity", "AtomicLocal"), new TypeNameAndConstructionInfo("Composite", "Composite"), new TypeNameAndConstructionInfo("Sub-workflow", "CompositeLocal"), new TypeNameAndConstructionInfo("AND Split", "And"), new TypeNameAndConstructionInfo("OR Split", "Or"), new TypeNameAndConstructionInfo("XOR Split", "XOr"), new TypeNameAndConstructionInfo("Join", "Join"), new TypeNameAndConstructionInfo("Loop", "Loop")};
    private final TypeNameAndConstructionInfo[] mEdgeTypeNameAndConstructionInfo = new TypeNameAndConstructionInfo[]{new TypeNameAndConstructionInfo("Next Edge", "Next")};

    public CompositeActivityDef() {
        this.setBuiltInProperty(BuiltInVertexProperties.ABORTABLE, false);
        this.setBuiltInProperty(BuiltInVertexProperties.REPEAT_WHEN, false);
        this.setBuiltInProperty(BuiltInVertexProperties.STATE_MACHINE_NAME, "CompositeActivity");
        try {
            this.setChildrenGraphModel(new GraphModel(new LifecycleVertexOutlineCreator()));
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
        this.setIsComposite(true);
    }

    public ArrayList<ActivityDef> getRefChildActDef() {
        return this.refChildActDef;
    }

    public void setRefChildActDef(ArrayList<ActivityDef> refChildActDef) {
        this.refChildActDef = refChildActDef;
    }

    public TypeNameAndConstructionInfo[] getVertexTypeNameAndConstructionInfo() {
        return this.mVertexTypeNameAndConstructionInfo;
    }

    public TypeNameAndConstructionInfo[] getEdgeTypeNameAndConstructionInfo() {
        return this.mEdgeTypeNameAndConstructionInfo;
    }

    public NextDef addNextDef(WfVertexDef origin, WfVertexDef terminus) {
        NextDef returnNxt = new NextDef(origin, terminus);
        this.getChildrenGraphModel().addEdgeAndCreateId((DirectedEdge)returnNxt, origin, terminus);
        return returnNxt;
    }

    public ActivitySlotDef addExistingActivityDef(String name, ActivityDef actDef, GraphPoint point) throws InvalidDataException {
        this.changed = true;
        boolean newActDef = true;
        for (ActivityDef existingActDef : this.refChildActDef) {
            if (!existingActDef.getName().equals(actDef.getName())) continue;
            if (existingActDef.getVersion().equals(actDef.getVersion())) {
                actDef = existingActDef;
                newActDef = false;
                break;
            }
            throw new InvalidDataException("Cannot use same activity def with different version in the same composite activity");
        }
        if (newActDef) {
            this.refChildActDef.add(actDef);
        }
        ActivitySlotDef child = new ActivitySlotDef(name, actDef);
        this.addChild(child, point);
        return child;
    }

    public ActivityDef addLocalActivityDef(String name, String type, GraphPoint point) {
        this.changed = true;
        ActivityDef child = type.startsWith("Composite") ? new CompositeActivityDef() : new ActivityDef();
        child.setName(name);
        child.setIsLayoutable(true);
        this.addChild(child, point);
        return child;
    }

    public WfVertexDef newChild(String Name, String Type2, Integer version, GraphPoint location) throws ObjectNotFoundException, InvalidDataException {
        WfVertexDef child;
        this.changed = true;
        boolean wasAdded = false;
        if (Type2.equals("Or")) {
            child = new OrSplitDef();
        } else if (Type2.equals("XOr")) {
            child = new XOrSplitDef();
        } else if (Type2.equals("And")) {
            child = new AndSplitDef();
        } else if (Type2.equals("Loop")) {
            child = new LoopDef();
        } else if (Type2.equals("Join") || Type2.equals("Route")) {
            child = new JoinDef();
            child.getProperties().put("Type", Type2);
        } else if (Type2.equals("Atomic") || Type2.equals("Composite")) {
            ActivityDef act = Type2.equals("Atomic") ? LocalObjectLoader.getElemActDef(Name, version) : LocalObjectLoader.getCompActDef(Name, version);
            child = this.addExistingActivityDef(act.getActName(), act, location);
            wasAdded = true;
        } else if (Type2.equals("AtomicLocal") || Type2.equals("CompositeLocal")) {
            child = this.addLocalActivityDef(Name, Type2, location);
            wasAdded = true;
        } else {
            throw new InvalidDataException("Unknown child type: " + Type2);
        }
        if (!wasAdded) {
            this.addChild(child, location);
        }
        log.debug("newChild() - Type:" + Type2 + " ID:" + child.getID() + " added to ID:" + this.getID());
        return child;
    }

    @Override
    public WfVertex instantiate() throws ObjectNotFoundException, InvalidDataException {
        return this.instantiate(this.getName());
    }

    @Override
    public WfVertex instantiate(String name) throws ObjectNotFoundException, InvalidDataException {
        CompositeActivity caInstance = new CompositeActivity();
        log.info("instantiate(name:" + name + ") - Starting.");
        caInstance.setName(name);
        this.configureInstance(caInstance);
        if (this.getItemPath() != null) {
            caInstance.setType(this.getItemID());
        }
        caInstance.getChildrenGraphModel().setStartVertexId(this.getChildrenGraphModel().getStartVertexId());
        caInstance.getChildrenGraphModel().setVertices(this.intantiateVertices(caInstance));
        caInstance.getChildrenGraphModel().setEdges(this.instantiateEdges(caInstance));
        caInstance.getChildrenGraphModel().setNextId(this.getChildrenGraphModel().getNextId());
        caInstance.getChildrenGraphModel().resetVertexOutlines();
        this.propagateCollectionProperties(caInstance);
        return caInstance;
    }

    private void propagateCollectionProperties(CompositeActivity caInstance) throws InvalidDataException {
        CastorHashMap caProps = caInstance.getProperties();
        ArrayList keysToDelete = new ArrayList();
        for (Map.Entry aCAProp : caProps.entrySet()) {
            if (!(aCAProp.getValue() instanceof CastorHashMap)) continue;
            for (Vertex vertex : caInstance.getChildrenGraphModel().getVertices()) {
                CastorHashMap propsToPropagate = (CastorHashMap)aCAProp.getValue();
                propsToPropagate.dump(8);
                BuiltInVertexProperties builtInProp = BuiltInVertexProperties.getValue((String)aCAProp.getKey());
                if (builtInProp == null) {
                    ((GraphableVertex)vertex).updatePropertiesFromCollection(Integer.parseInt((String)aCAProp.getKey()), propsToPropagate);
                    continue;
                }
                ((GraphableVertex)vertex).updatePropertiesFromCollection(builtInProp, propsToPropagate);
            }
            keysToDelete.add(aCAProp.getKey());
        }
        for (String key : keysToDelete) {
            caProps.remove(key);
        }
    }

    public Next[] instantiateEdges(CompositeActivity ca) {
        Next[] nexts = new Next[this.getChildrenGraphModel().getEdges().length];
        for (int i = 0; i < this.getChildrenGraphModel().getEdges().length; ++i) {
            NextDef nextDef = (NextDef)this.getChildrenGraphModel().getEdges()[i];
            nexts[i] = nextDef.instantiate();
            nexts[i].setParent(ca);
        }
        return nexts;
    }

    public WfVertex[] intantiateVertices(CompositeActivity ca) throws ObjectNotFoundException, InvalidDataException {
        GraphableVertex[] vertexDefs = this.getLayoutableChildren();
        WfVertex[] wfVertices = new WfVertex[vertexDefs.length];
        for (int i = 0; i < vertexDefs.length; ++i) {
            WfVertexDef vertDef = (WfVertexDef)vertexDefs[i];
            wfVertices[i] = vertDef.instantiate();
            wfVertices[i].setParent(ca);
        }
        return wfVertices;
    }

    @Override
    public CollectionArrayList makeDescCollections() throws InvalidDataException, ObjectNotFoundException {
        CollectionArrayList retArr = super.makeDescCollections();
        retArr.put(this.makeActDefCollection());
        return retArr;
    }

    public Dependency makeActDefCollection() throws InvalidDataException {
        return this.makeDescCollection(BuiltInCollections.ACTIVITY, this.refChildActDef.toArray(new ActivityDef[this.refChildActDef.size()]));
    }

    public ArrayList<ActivityDef> findRefActDefs(GraphModel graph) throws ObjectNotFoundException, InvalidDataException {
        ArrayList<ActivityDef> graphActDefs = new ArrayList<ActivityDef>();
        for (Vertex elem : graph.getVertices()) {
            ActivityDef actDef;
            if (!(elem instanceof ActivitySlotDef) || graphActDefs.contains(actDef = ((ActivitySlotDef)elem).getTheActivityDef())) continue;
            graphActDefs.add(actDef);
        }
        return graphActDefs;
    }

    public boolean hasGoodNumberOfActivity() {
        int endingAct = 0;
        GraphableVertex[] graphableVertices = this.getLayoutableChildren();
        if (graphableVertices != null) {
            for (GraphableVertex graphableVertice : graphableVertices) {
                WfVertexDef vertex = (WfVertexDef)graphableVertice;
                if (this.getChildrenGraphModel().getOutEdges(vertex).length != 0) continue;
                ++endingAct;
            }
        }
        return endingAct <= true;
    }

    @Override
    public String getPath() {
        if (this.getParent() == null) {
            return this.getName();
        }
        return super.getPath();
    }

    @Override
    public void setChildrenGraphModel(GraphModel childrenGraph) throws InvalidDataException {
        super.setChildrenGraphModel(childrenGraph);
        childrenGraph.setVertexOutlineCreator(new LifecycleVertexOutlineCreator());
        try {
            this.setRefChildActDef(this.findRefActDefs(childrenGraph));
        }
        catch (ObjectNotFoundException e) {
            throw new InvalidDataException(e.getMessage());
        }
    }

    @Deprecated
    public String[] getCastorNonLayoutableChildren() {
        return new String[0];
    }

    @Deprecated
    public void setCastorNonLayoutableChildren(String[] dummy) {
    }

    @Override
    public boolean verify() {
        boolean err = super.verify();
        GraphableVertex[] vChildren = this.getChildren();
        for (int i = 0; i < vChildren.length; ++i) {
            WfVertexDef wfvChild = (WfVertexDef)vChildren[i];
            if (wfvChild.verify()) continue;
            this.mErrors.add(wfvChild.getName() + ": " + wfvChild.getErrors());
            err = false;
        }
        return err;
    }

    @Override
    public void export(Writer imports, File dir, boolean shallow) throws InvalidDataException, ObjectNotFoundException, IOException {
        this.setRefChildActDef(this.findRefActDefs(this.getChildrenGraphModel()));
        if (!shallow) {
            for (GraphableVertex vert : this.getChildren()) {
                if (vert instanceof AndSplitDef) {
                    try {
                        ((AndSplitDef)vert).getRoutingScript().export(imports, dir, shallow);
                    }
                    catch (ObjectNotFoundException objectNotFoundException) {}
                    continue;
                }
                if (!(vert instanceof ActivitySlotDef)) continue;
                ActivityDef refAct = ((ActivitySlotDef)vert).getTheActivityDef();
                refAct.export(imports, dir, shallow);
            }
        }
        String tc = BuiltInResources.COMP_ACT_DESC_RESOURCE.getTypeCode();
        try {
            NodeList nodeList = null;
            Outcome outcome = null;
            String compactXML = Gateway.getMarshaller().marshall(this);
            if (Gateway.getProperties().getBoolean("Export.replaceActivitySlotDefUUIDWithName", false)) {
                outcome = new Outcome(compactXML);
                nodeList = outcome.getNodesByXPath("/CompositeActivityDef/childrenGraphModel/GraphModelCastorData/ActivitySlotDef/activityDef/text()");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    try {
                        ItemPath itemPath = Gateway.getLookup().getItemPath(nodeList.item(i).getNodeValue());
                        ItemProxy itemProxy = Gateway.getProxyManager().getProxy(itemPath);
                        nodeList.item(i).setNodeValue(itemProxy.getName());
                        continue;
                    }
                    catch (Exception e) {
                        log.error("Cannot find item with UIID: " + nodeList.item(i).getNodeValue(), (Throwable)e);
                        throw new ObjectNotFoundException("Cannot find item with UIID: " + nodeList.item(i).getNodeValue());
                    }
                }
                compactXML = outcome.getData();
            }
            FileStringUtility.string2File(new File(new File(dir, tc), this.getActName() + (this.getVersion() == null ? "" : "_" + this.getVersion()) + ".xml"), compactXML);
        }
        catch (Exception e) {
            log.error("Couldn't marshall composite activity def " + this.getActName(), (Throwable)e);
            throw new InvalidDataException("Couldn't marshall composite activity def " + this.getActName());
        }
        if (imports != null) {
            imports.write("<Workflow " + this.getExportAttributes(tc) + ">" + this.getExportCollections());
            for (ActivityDef childActDef : this.refChildActDef) {
                imports.write("<Activity name=\"" + childActDef.getActName() + "\" id=\"" + childActDef.getItemID() + "\" version=\"" + childActDef.getVersion() + "\"/>");
            }
            imports.write("</Workflow>\n");
        }
    }
}

