/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.io.IOException;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.collection.DependencyMember;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStepCollectionBase;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.Gateway;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddMembersToCollection
extends PredefinedStepCollectionBase {
    private static final Logger log = LoggerFactory.getLogger(AddMembersToCollection.class);
    public static final String description = "Adds members to a given item";

    public AddMembersToCollection() {
        this.setBuiltInProperty(BuiltInVertexProperties.SCHEMA_NAME, "Dependency");
    }

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, Object locker) throws InvalidDataException, ObjectAlreadyExistsException, PersistencyException, ObjectNotFoundException, InvalidCollectionModification {
        try {
            Dependency inputDependendency = (Dependency)Gateway.getMarshaller().unmarshall(requestData);
            String collectionName = inputDependendency.getName();
            Dependency dep = (Dependency)Gateway.getStorage().get(item, (Object)((Object)ClusterType.COLLECTION) + "/" + collectionName + "/last", locker);
            for (DependencyMember inputMember : inputDependendency.getMembers().list) {
                DependencyMember newMember = null;
                newMember = inputMember.getProperties() != null && inputMember.getProperties().size() != 0 ? dep.createMember(inputMember.getItemPath(), inputMember.getProperties()) : dep.createMember(inputMember.getItemPath());
                this.evaluateScript(item, dep, newMember, locker);
                dep.addMember(newMember);
            }
            Gateway.getStorage().put(item, dep, locker);
            return Gateway.getMarshaller().marshall(dep);
        }
        catch (IOException | MappingException | MarshalException | ValidationException ex) {
            log.error("Error adding members to collection", ex);
            throw new InvalidDataException("Error adding members to collection: " + ex);
        }
    }
}

