/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.security;

import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.process.Gateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum BuiltInAuthc {
    ADMIN_ROLE("Admin"),
    SYSTEM_AGENT("system");

    private static final Logger log;
    private String name;

    private BuiltInAuthc(String n2) {
        this.name = n2;
    }

    public Path getPath() throws ObjectNotFoundException {
        if (this.equals((Object)SYSTEM_AGENT)) {
            return Gateway.getLookup().getAgentPath(this.name);
        }
        if (this.equals((Object)ADMIN_ROLE)) {
            return Gateway.getLookup().getRolePath(this.name);
        }
        log.warn("getPath() - Enum value '{}' is not handled correctly", (Object)this.name);
        return null;
    }

    public String getName() {
        return this.name;
    }

    static {
        log = LoggerFactory.getLogger(BuiltInAuthc.class);
    }
}

