/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.collection.Aggregation;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.CollectionMember;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.collection.DependencyMember;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.scripting.ScriptingEngineException;
import org.cristalise.kernel.utils.CastorHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PredefinedStepCollectionBase
extends PredefinedStep {
    private static final Logger log = LoggerFactory.getLogger(PredefinedStepCollectionBase.class);
    protected String collectionName = null;
    protected int slotID = -1;
    protected ItemPath childPath = null;
    protected CastorHashMap memberNewProps = null;
    Collection<? extends CollectionMember> collection;

    protected void setChildPath(String data) throws InvalidItemPathException, ObjectNotFoundException {
        this.childPath = ItemPath.isUUID(data) ? new ItemPath(data) : new DomainPath(data).getItemPath();
    }

    protected Dependency getDependency() throws InvalidDataException {
        if (this.collection != null) {
            if (this.collection instanceof Dependency) {
                return (Dependency)this.collection;
            }
            String error = this.collectionName + " is not Dependency (class:" + this.collection.getClass().getSimpleName() + ")";
            log.error(error);
            throw new InvalidDataException(error);
        }
        String error = "Collection '" + this.collectionName + "' was not found or not initilaised.";
        log.error(error);
        throw new InvalidDataException(error);
    }

    protected Aggregation getAggregation() throws InvalidDataException {
        if (this.collection != null) {
            if (this.collection instanceof Aggregation) {
                return (Aggregation)this.collection;
            }
            String error = this.collectionName + " is not Aggregation (class:" + this.collection.getClass().getSimpleName() + ")";
            log.error(error);
            throw new InvalidDataException(error);
        }
        String error = "Collection '" + this.collectionName + "' was not found or not initilaised.";
        log.error(error);
        throw new InvalidDataException(error);
    }

    protected String[] unpackParamsAndGetCollection(ItemPath item, String requestData, Object locker) throws InvalidDataException, PersistencyException, ObjectNotFoundException {
        Object[] params = PredefinedStepCollectionBase.getDataList(requestData);
        if (params == null || params.length < 2) {
            throw new InvalidDataException("CollectionBase - Invalid parameters:" + Arrays.toString(params));
        }
        log.debug("unpackParamsAndGetCollection() - params:{}", (Object)params);
        this.collectionName = params[0];
        this.collection = (Collection)Gateway.getStorage().get(item, (Object)((Object)ClusterType.COLLECTION) + "/" + this.collectionName + "/last", locker);
        try {
            if (StringUtils.isNumeric((CharSequence)params[1])) {
                this.slotID = Integer.parseInt((String)params[1]);
                if (params.length > 2 && StringUtils.isNotBlank((CharSequence)params[2])) {
                    this.setChildPath((String)params[2]);
                }
                if (params.length > 3 && StringUtils.isNotBlank((CharSequence)params[3])) {
                    this.memberNewProps = (CastorHashMap)Gateway.getMarshaller().unmarshall((String)params[3]);
                }
            } else {
                this.setChildPath((String)params[1]);
                if (params.length > 2 && StringUtils.isNotBlank((CharSequence)params[2])) {
                    this.memberNewProps = (CastorHashMap)Gateway.getMarshaller().unmarshall((String)params[2]);
                }
            }
        }
        catch (Exception e) {
            log.error("Invalid parameters:{}", (Object)Arrays.toString(params), (Object)e);
            throw new InvalidDataException("CollectionBase - Invalid parameters:" + Arrays.toString(params));
        }
        return params;
    }

    protected DependencyMember getDependencyMember() throws InvalidDataException, ObjectNotFoundException {
        List<? extends CollectionMember> memberList = this.collection.resolveMembers(this.slotID, this.childPath);
        if (memberList.size() != 1) {
            throw new InvalidDataException(this.collectionName + "contains more the one member for slotID:" + this.slotID + " memberId:" + this.childPath);
        }
        CollectionMember member = memberList.get(0);
        if (!(member instanceof DependencyMember)) {
            throw new InvalidDataException(this.collectionName + " has to be Dependency (member class:" + member.getClass().getSimpleName() + ")");
        }
        return (DependencyMember)member;
    }

    protected void evaluateScript(ItemPath item, Dependency dependency, DependencyMember newMember, Object locker) throws ObjectNotFoundException, InvalidDataException, InvalidCollectionModification {
        if (dependency.containsBuiltInProperty(BuiltInVertexProperties.MEMBER_ADD_SCRIPT)) {
            CastorHashMap scriptProps = new CastorHashMap();
            scriptProps.put("collection", dependency);
            scriptProps.put("member", newMember);
            this.evaluateScript(item, (String)dependency.getBuiltInProperty(BuiltInVertexProperties.MEMBER_ADD_SCRIPT), scriptProps, locker);
        }
    }

    protected void evaluateScript(ItemPath item, String propertyValue, CastorHashMap scriptProps, Object locker) throws ObjectNotFoundException, InvalidDataException, InvalidCollectionModification {
        if (StringUtils.isBlank((CharSequence)propertyValue) || !propertyValue.contains(":")) {
            throw new InvalidDataException(this.getClass().getSimpleName() + " cannot resolve Script from '" + propertyValue + "' value");
        }
        String[] tokens = propertyValue.split(":");
        try {
            Script script = Script.getScript(tokens[0], Integer.valueOf(tokens[1]));
            script.evaluate(item, scriptProps, this.getActContext(), locker);
        }
        catch (ScriptingEngineException e) {
            log.error("evaluateScript() - failed to execute script:{}", (Object)propertyValue, (Object)e);
            throw new InvalidCollectionModification(e.getMessage());
        }
    }
}

