/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.persistency;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.entity.agent.JobList;
import org.cristalise.kernel.entity.proxy.ProxyMessage;
import org.cristalise.kernel.events.History;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterStorage;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.auth.Authenticator;
import org.cristalise.kernel.querying.Query;
import org.cristalise.kernel.utils.SoftCache;
import org.cristalise.kernel.utils.WeakCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterStorageManager {
    private static final Logger log = LoggerFactory.getLogger(ClusterStorageManager.class);
    HashMap<String, ClusterStorage> allStores = new HashMap();
    String[] clusterPriority = new String[0];
    HashMap<ClusterType, ArrayList<ClusterStorage>> clusterWriters = new HashMap();
    HashMap<ClusterType, ArrayList<ClusterStorage>> clusterReaders = new HashMap();
    HashMap<ItemPath, Map<String, C2KLocalObject>> memoryCache = new HashMap();
    Map<Object, Set<ProxyMessage>> proxyMessagesMap = new ConcurrentHashMap<Object, Set<ProxyMessage>>();
    private Map<ItemPath, Object> itemLocks = new ConcurrentHashMap<ItemPath, Object>();
    private Map<Object, Set<ItemPath>> lockCatalog = new ConcurrentHashMap<Object, Set<ItemPath>>();

    public ClusterStorageManager(Authenticator auth) throws PersistencyException {
        ArrayList<ClusterStorage> rootStores;
        Object clusterStorageProp = Gateway.getProperties().getObject("ClusterStorage");
        if (clusterStorageProp == null || "".equals(clusterStorageProp)) {
            throw new PersistencyException("init() - no ClusterStorages defined. No persistency!");
        }
        if (clusterStorageProp instanceof String) {
            rootStores = this.instantiateStores((String)clusterStorageProp);
        } else if (clusterStorageProp instanceof ArrayList) {
            ArrayList propStores = (ArrayList)clusterStorageProp;
            rootStores = new ArrayList();
            this.clusterPriority = new String[propStores.size()];
            for (ClusterStorage thisStore : propStores) {
                if (thisStore instanceof ClusterStorage) {
                    rootStores.add(thisStore);
                    continue;
                }
                throw new PersistencyException("Supplied ClusterStorage " + thisStore + " was not an instance of ClusterStorage");
            }
        } else {
            throw new PersistencyException("Unknown class of ClusterStorage property: " + clusterStorageProp.getClass().getName());
        }
        int clusterNo = 0;
        for (ClusterStorage newStorage : rootStores) {
            newStorage.open(auth);
            log.debug("init() - Cluster storage " + newStorage.getClass().getName() + " initialised successfully.");
            this.allStores.put(newStorage.getId(), newStorage);
            this.clusterPriority[clusterNo++] = newStorage.getId();
        }
        this.clusterReaders.put(ClusterType.ROOT, rootStores);
    }

    public ArrayList<ClusterStorage> instantiateStores(String allClusters) throws PersistencyException {
        ArrayList<ClusterStorage> rootStores = new ArrayList<ClusterStorage>();
        StringTokenizer tok = new StringTokenizer(allClusters, ",");
        this.clusterPriority = new String[tok.countTokens()];
        while (tok.hasMoreTokens()) {
            ClusterStorage newStorage = null;
            String newStorageClass = tok.nextToken();
            try {
                if (!newStorageClass.contains(".")) {
                    newStorageClass = "org.cristalise.storage." + newStorageClass;
                }
                newStorage = (ClusterStorage)Class.forName(newStorageClass).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                throw new PersistencyException("init() - The cluster storage handler class " + newStorageClass + " could not be found.");
            }
            rootStores.add(newStorage);
        }
        return rootStores;
    }

    public void close() {
        for (ClusterStorage thisStorage : this.allStores.values()) {
            try {
                thisStorage.close();
            }
            catch (PersistencyException ex) {
                log.error("Error closing storage " + thisStorage.getName(), (Throwable)ex);
            }
        }
    }

    private ClusterStorage findStorageForQuery(String language) {
        for (String element : this.clusterPriority) {
            ClusterStorage store = this.allStores.get(element);
            if (!store.checkQuerySupport(language)) continue;
            return store;
        }
        return null;
    }

    private ArrayList<ClusterStorage> findStorages(ClusterType clusterType, boolean forWrite) {
        HashMap<ClusterType, ArrayList<ClusterStorage>> cache = forWrite ? this.clusterWriters : this.clusterReaders;
        if (cache.containsKey((Object)clusterType)) {
            return cache.get((Object)clusterType);
        }
        log.debug("findStorages() - finding storage for " + (Object)((Object)clusterType) + " forWrite:" + forWrite);
        ArrayList<ClusterStorage> useableStorages = new ArrayList<ClusterStorage>();
        for (String element : this.clusterPriority) {
            int requiredSupport;
            ClusterStorage thisStorage = this.allStores.get(element);
            int n = requiredSupport = forWrite ? 2 : 1;
            if ((thisStorage.queryClusterSupport(clusterType) & requiredSupport) != requiredSupport) continue;
            log.debug("findStorages() - Got " + thisStorage.getName());
            useableStorages.add(thisStorage);
        }
        cache.put(clusterType, useableStorages);
        return useableStorages;
    }

    public String executeQuery(Query query) throws PersistencyException {
        return this.executeQuery(query, null);
    }

    public String executeQuery(Query query, Object transactionKey) throws PersistencyException {
        ClusterStorage reader = this.findStorageForQuery(query.getLanguage());
        if (reader != null) {
            return reader.executeQuery(query, transactionKey);
        }
        throw new PersistencyException("No storage was found supporting language:" + query.getLanguage() + " query:" + query.getName());
    }

    public String[] getClusterContents(ItemPath itemPath, ClusterType type) throws PersistencyException {
        return this.getClusterContents(itemPath, type, null);
    }

    public String[] getClusterContents(ItemPath itemPath, ClusterType type, Object transactionKey) throws PersistencyException {
        return this.getClusterContents(itemPath, type.getName(), transactionKey);
    }

    public String[] getClusterContents(ItemPath itemPath, String path) throws PersistencyException {
        return this.getClusterContents(itemPath, path, null);
    }

    public String[] getClusterContents(ItemPath itemPath, String path, Object transactionKey) throws PersistencyException {
        if (path.startsWith("/") && path.length() > 1) {
            path = path.substring(1);
        }
        ArrayList<String> contents = new ArrayList<String>();
        log.trace("getClusterContents() - path:" + path);
        ArrayList<ClusterStorage> readers = this.findStorages(ClusterStorage.getClusterType(path), false);
        for (ClusterStorage thisReader : readers) {
            try {
                String[] thisArr = thisReader.getClusterContents(itemPath, path, transactionKey);
                if (thisArr == null) continue;
                for (int j = 0; j < thisArr.length; ++j) {
                    if (contents.contains(thisArr[j])) continue;
                    log.trace("getClusterContents() - " + thisReader.getName() + " reports " + thisArr[j]);
                    contents.add(thisArr[j]);
                }
            }
            catch (PersistencyException e) {
                log.debug("getClusterContents() - reader " + thisReader.getName() + " could not retrieve contents of " + itemPath + "/" + path + ": " + e.getMessage());
            }
        }
        log.trace("getClusterContents() - Returning " + contents.size() + " elements of path:" + path);
        String[] retArr = new String[]{};
        retArr = contents.toArray(retArr);
        return retArr;
    }

    public C2KLocalObject get(ItemPath itemPath, String path) throws PersistencyException, ObjectNotFoundException {
        return this.get(itemPath, path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public C2KLocalObject get(ItemPath itemPath, String path, Object transactionKey) throws PersistencyException, ObjectNotFoundException {
        StringTokenizer tok;
        Map<String, C2KLocalObject> sysKeyMemCache;
        if (path.startsWith("/") && path.length() > 1) {
            path = path.substring(1);
        }
        if ((sysKeyMemCache = this.memoryCache.get(itemPath)) != null) {
            Map<String, C2KLocalObject> map = sysKeyMemCache;
            synchronized (map) {
                C2KLocalObject obj = sysKeyMemCache.get(path);
                if (obj != null) {
                    log.debug("get() - found " + itemPath + "/" + path + " in memcache");
                    return obj;
                }
            }
        }
        if (path.startsWith(ClusterType.VIEWPOINT.getName()) && path.endsWith("/data") && (tok = new StringTokenizer(path, "/")).countTokens() == 4) {
            Viewpoint view = (Viewpoint)this.get(itemPath, path.substring(0, path.lastIndexOf("/")), transactionKey);
            if (view != null) {
                return view.getOutcome();
            }
            return null;
        }
        C2KLocalObject result = null;
        if (path.indexOf(47) == -1) {
            if (path.equals(ClusterType.HISTORY.getName())) {
                result = new History(itemPath, transactionKey);
            } else if (path.equals(ClusterType.JOB.getName())) {
                if (itemPath instanceof AgentPath) {
                    result = new JobList((AgentPath)itemPath, transactionKey);
                } else {
                    throw new ObjectNotFoundException("Items do not have job lists");
                }
            }
        }
        if (result == null) {
            ArrayList<ClusterStorage> readers = this.findStorages(ClusterStorage.getClusterType(path), false);
            for (ClusterStorage thisReader : readers) {
                try {
                    result = thisReader.get(itemPath, path, transactionKey);
                    log.debug("get() - reading " + path + " from " + thisReader.getName() + " for item " + itemPath);
                    if (result == null) continue;
                    break;
                }
                catch (PersistencyException e) {
                    log.debug("get() - reader " + thisReader.getName() + " could not retrieve " + itemPath + "/" + path + ": " + e.getMessage());
                }
            }
        }
        if (result == null) {
            throw new ObjectNotFoundException("get() - Path " + path + " not found in " + itemPath);
        }
        this.putInMemoryCache(itemPath, path, result);
        return result;
    }

    public int getLastIntegerId(ItemPath itemPath, String path, Object transactionKey) throws PersistencyException {
        ArrayList<ClusterStorage> readers;
        Iterator<ClusterStorage> iterator;
        if (path.startsWith("/") && path.length() > 1) {
            path = path.substring(1);
        }
        if ((iterator = (readers = this.findStorages(ClusterType.HISTORY, false)).iterator()).hasNext()) {
            ClusterStorage storage = iterator.next();
            return storage.getLastIntegerId(itemPath, path, transactionKey);
        }
        return -1;
    }

    public void put(ItemPath itemPath, C2KLocalObject obj) throws PersistencyException {
        this.put(itemPath, obj, null);
    }

    public void put(ItemPath itemPath, C2KLocalObject obj, Object transactionKey) throws PersistencyException {
        this.lockItem(itemPath, transactionKey);
        String path = ClusterStorage.getPath(obj);
        ArrayList<ClusterStorage> writers = this.findStorages(ClusterStorage.getClusterType(path), true);
        for (ClusterStorage thisWriter : writers) {
            try {
                log.debug("put() - writing " + path + " to " + thisWriter.getName());
                thisWriter.put(itemPath, obj, transactionKey);
            }
            catch (PersistencyException e) {
                log.error("put() - writer " + thisWriter.getName() + " could not store " + itemPath + "/" + path + ": " + e.getMessage());
                throw e;
            }
        }
        this.putInMemoryCache(itemPath, path, obj);
        ProxyMessage message = new ProxyMessage(itemPath, path, false);
        if (transactionKey != null) {
            this.keepMessageForLater(message, transactionKey);
        } else {
            this.sendProxyEvent(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putInMemoryCache(ItemPath itemPath, String path, C2KLocalObject obj) {
        Map<String, C2KLocalObject> sysKeyMemCache;
        if (Gateway.getProperties().getBoolean("Storage.disableCache", false)) {
            log.trace("putInMemoryCache() - Cache is DISABLED");
            return;
        }
        if (this.memoryCache.containsKey(itemPath)) {
            sysKeyMemCache = this.memoryCache.get(itemPath);
        } else {
            boolean useWeak = Gateway.getProperties().getBoolean("Storage.useWeakCache", false);
            log.debug("putInMemoryCache() - Creating " + (useWeak ? "Weak" : "Strong") + " cache for item " + itemPath);
            sysKeyMemCache = useWeak ? new WeakCache() : new SoftCache(0);
            HashMap<ItemPath, Map<String, C2KLocalObject>> hashMap = this.memoryCache;
            synchronized (hashMap) {
                this.memoryCache.put(itemPath, sysKeyMemCache);
            }
        }
        Map<String, C2KLocalObject> map = sysKeyMemCache;
        synchronized (map) {
            sysKeyMemCache.put(path, obj);
        }
        if (log.isTraceEnabled()) {
            this.dumpCacheContents();
        }
    }

    public void remove(ItemPath itemPath, String path) throws PersistencyException {
        this.remove(itemPath, path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ItemPath itemPath, String path, Object transactionKey) throws PersistencyException {
        this.lockItem(itemPath, transactionKey);
        ArrayList<ClusterStorage> writers = this.findStorages(ClusterStorage.getClusterType(path), true);
        for (ClusterStorage thisWriter : writers) {
            try {
                log.debug("delete() - removing " + path + " from " + thisWriter.getName());
                thisWriter.delete(itemPath, path, transactionKey);
            }
            catch (PersistencyException e) {
                log.error("delete() - writer " + thisWriter.getName() + " could not delete " + itemPath + "/" + path + ": " + e.getMessage());
                throw e;
            }
        }
        if (this.memoryCache.containsKey(itemPath)) {
            Map<String, C2KLocalObject> itemMemCache;
            Map<String, C2KLocalObject> map = itemMemCache = this.memoryCache.get(itemPath);
            synchronized (map) {
                itemMemCache.remove(path);
            }
        }
        ProxyMessage message = new ProxyMessage(itemPath, path, true);
        if (transactionKey != null) {
            this.keepMessageForLater(message, transactionKey);
        } else {
            this.sendProxyEvent(message);
        }
    }

    public void removeCluster(ItemPath itemPath, String path, Object transactionKey) throws PersistencyException {
        String[] children;
        for (String element : children = this.getClusterContents(itemPath, path)) {
            this.removeCluster(itemPath, path + (path.length() > 0 ? "/" : "") + element, transactionKey);
        }
        if (children.length == 0 && path.indexOf("/") > -1) {
            this.remove(itemPath, path, transactionKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache(ItemPath itemPath, String path) {
        if (itemPath == null) {
            this.clearCache();
        } else if (path == null) {
            this.clearCache(itemPath);
        } else {
            log.debug("clearCache() - removing " + itemPath + "/" + path);
            if (this.memoryCache.containsKey(itemPath)) {
                Map<String, C2KLocalObject> sysKeyMemCache;
                Map<String, C2KLocalObject> map = sysKeyMemCache = this.memoryCache.get(itemPath);
                synchronized (map) {
                    Iterator<String> iter = sysKeyMemCache.keySet().iterator();
                    while (iter.hasNext()) {
                        String thisPath = iter.next();
                        if (!thisPath.startsWith(path)) continue;
                        log.trace("clearCache() - removing " + itemPath + "/" + thisPath);
                        iter.remove();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache(ItemPath itemPath) {
        if (itemPath == null) {
            this.clearCache();
        } else {
            log.debug("clearCache() - removing complete item:" + itemPath);
            if (this.memoryCache.containsKey(itemPath)) {
                HashMap<ItemPath, Map<String, C2KLocalObject>> hashMap = this.memoryCache;
                synchronized (hashMap) {
                    log.trace("clearCache() - {} objects to remove for {}", (Object)this.memoryCache.get(itemPath).size(), (Object)itemPath);
                    this.memoryCache.remove(itemPath);
                }
            } else {
                log.debug("No objects cached for {}", (Object)itemPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        log.debug("clearCache() - clearing entire cache, " + this.memoryCache.size() + " entities.");
        HashMap<ItemPath, Map<String, C2KLocalObject>> hashMap = this.memoryCache;
        synchronized (hashMap) {
            this.memoryCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpCacheContents() {
        HashMap<ItemPath, Map<String, C2KLocalObject>> hashMap = this.memoryCache;
        synchronized (hashMap) {
            for (ItemPath itemPath : this.memoryCache.keySet()) {
                log.info("Cached Objects of {}", (Object)itemPath);
                Map<String, C2KLocalObject> sysKeyMemCache = this.memoryCache.get(itemPath);
                try {
                    Map<String, C2KLocalObject> map = sysKeyMemCache;
                    synchronized (map) {
                        Iterator<String> iterator = sysKeyMemCache.keySet().iterator();
                        while (iterator.hasNext()) {
                            String name;
                            String path = name = iterator.next();
                            try {
                                log.info("    Path {}: {}", (Object)path, (Object)sysKeyMemCache.get(path).getClass().getName());
                            }
                            catch (NullPointerException e) {
                                log.info("    Path {}: reaped", (Object)path);
                            }
                        }
                    }
                }
                catch (ConcurrentModificationException ex) {
                    log.info("Cache modified - aborting");
                }
            }
            log.info("Total number of cached entities: " + this.memoryCache.size());
        }
    }

    public void begin(Object transactionKey) throws PersistencyException {
        if (transactionKey != null) {
            if (this.lockCatalog.containsKey(transactionKey)) {
                throw new PersistencyException("TransactionKey '" + transactionKey + "' is alsready in use");
            }
            this.lockCatalog.put(transactionKey, new LinkedHashSet());
        }
        for (ClusterStorage thisStore : this.allStores.values()) {
            thisStore.begin(transactionKey);
        }
    }

    public void commit(Object transactionKey) throws PersistencyException {
        for (ClusterStorage thisStore : this.allStores.values()) {
            thisStore.commit(transactionKey);
        }
        if (transactionKey != null) {
            if (this.lockCatalog.containsKey(transactionKey)) {
                for (ItemPath ip : this.lockCatalog.get(transactionKey)) {
                    this.itemLocks.remove(ip);
                }
            } else {
                throw new PersistencyException("TransactionKey '" + transactionKey + "' is unknown");
            }
            this.lockCatalog.remove(transactionKey);
            this.sendProxyMessages(this.proxyMessagesMap.remove(transactionKey));
        }
    }

    public void abort(Object transactionKey) throws PersistencyException {
        for (ClusterStorage thisStore : this.allStores.values()) {
            thisStore.abort(transactionKey);
        }
        if (transactionKey != null) {
            if (this.lockCatalog.containsKey(transactionKey)) {
                for (ItemPath ip : this.lockCatalog.get(transactionKey)) {
                    this.itemLocks.remove(ip);
                }
            } else {
                throw new PersistencyException("TransactionKey '" + transactionKey + "' is unknown");
            }
            this.lockCatalog.remove(transactionKey);
            this.proxyMessagesMap.remove(transactionKey);
        }
    }

    public void postConnect() throws PersistencyException {
        for (ClusterStorage thisStore : this.allStores.values()) {
            thisStore.postConnect();
        }
    }

    public void postBoostrap() throws PersistencyException {
        for (ClusterStorage thisStore : this.allStores.values()) {
            thisStore.postBoostrap();
        }
    }

    public void postStartServer() throws PersistencyException {
        for (ClusterStorage thisStore : this.allStores.values()) {
            thisStore.postStartServer();
        }
    }

    private void keepMessageForLater(ProxyMessage message, Object transactionKey) {
        Set<ProxyMessage> set = this.proxyMessagesMap.get(transactionKey);
        if (set == null) {
            set = new HashSet<ProxyMessage>();
            this.proxyMessagesMap.put(transactionKey, set);
        }
        set.add(message);
    }

    private void sendProxyMessages(Set<ProxyMessage> messageSet) {
        if (messageSet != null) {
            for (ProxyMessage message : messageSet) {
                this.sendProxyEvent(message);
            }
        }
    }

    private void sendProxyEvent(ProxyMessage message) {
        if (Gateway.getProxyServer() != null) {
            Gateway.getProxyServer().sendProxyEvent(message);
        } else {
            log.warn("sendProxyEvent: ProxyServer is null - Proxies are not notified of this event");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void lockItem(ItemPath itemPath, Object transactionKey) throws PersistencyException {
        Map<ItemPath, Object> map = this.itemLocks;
        synchronized (map) {
            if (this.itemLocks.containsKey(itemPath)) {
                Object thisLocker = this.itemLocks.get(itemPath);
                if (transactionKey == null || !thisLocker.equals(transactionKey)) throw new PersistencyException("Access denied: '" + itemPath + "' has been locked for writing by " + thisLocker);
                this.lockCatalog.get(transactionKey).add(itemPath);
            } else {
                if (transactionKey == null) return;
                this.lockCatalog.get(transactionKey).add(itemPath);
                this.itemLocks.put(itemPath, transactionKey);
            }
            return;
        }
    }
}

