/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.persistency;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.entity.agent.JobList;
import org.cristalise.kernel.events.History;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterStorage;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.AbstractMain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransactionalClusterStorageBase
extends ClusterStorage {
    private static final Logger log = LoggerFactory.getLogger(TransactionalClusterStorageBase.class);
    private HashMap<ItemPath, Object> locks = new HashMap();
    HashMap<Object, ArrayList<TransactionEntry>> pendingTransactions = new HashMap();

    public String[] getUncommittedClusterContents(ItemPath itemPath, String path, Object transactionKey) throws PersistencyException {
        if (path.startsWith("/") && path.length() > 1) {
            path = path.substring(1);
        }
        ArrayList<String> uncomittedContents = new ArrayList<String>();
        if (this.locks.containsKey(itemPath) && this.locks.get(itemPath).equals(transactionKey)) {
            for (TransactionEntry thisEntry : this.pendingTransactions.get(transactionKey)) {
                if (!itemPath.equals(thisEntry.itemPath) || !thisEntry.path.startsWith(path)) continue;
                if (thisEntry.obj == null) {
                    throw new PersistencyException("TransactionManager.get() - Cluster " + path + " has been deleted in " + itemPath + " but not yet committed");
                }
                String content = StringUtils.substringAfterLast((String)thisEntry.path, (String)"/");
                uncomittedContents.add(content);
            }
        }
        return uncomittedContents.toArray(new String[uncomittedContents.size()]);
    }

    public C2KLocalObject getUncommitted(ItemPath itemPath, String path, Object transactionKey) throws PersistencyException, ObjectNotFoundException {
        if (path.startsWith("/") && path.length() > 1) {
            path = path.substring(1);
        }
        if (path.indexOf(47) == -1) {
            if (path.equals(ClusterType.HISTORY.getName()) && transactionKey != null) {
                return new History(itemPath, transactionKey);
            }
            if (path.equals(ClusterType.JOB.getName()) && transactionKey != null) {
                if (itemPath instanceof AgentPath) {
                    return new JobList((AgentPath)itemPath, transactionKey);
                }
                throw new ObjectNotFoundException("TransactionManager.get() - Items do not have job lists");
            }
        }
        if (this.locks.containsKey(itemPath) && this.locks.get(itemPath).equals(transactionKey)) {
            ArrayList<TransactionEntry> lockerTransaction = this.pendingTransactions.get(transactionKey);
            for (TransactionEntry thisEntry : lockerTransaction) {
                if (!itemPath.equals(thisEntry.itemPath) || !path.equals(thisEntry.path)) continue;
                if (thisEntry.obj == null) {
                    throw new PersistencyException("TransactionManager.get() - Cluster " + path + " has been deleted in " + itemPath + " but not yet committed");
                }
                return thisEntry.obj;
            }
        }
        return null;
    }

    @Override
    public void put(ItemPath itemPath, C2KLocalObject obj, Object transactionKey) throws PersistencyException {
        ArrayList<TransactionEntry> lockingTransaction = this.getLockingTransaction(itemPath, transactionKey);
        if (lockingTransaction == null) {
            this.locks.remove(itemPath);
        } else {
            this.createTransactionEntry(itemPath, obj, null, lockingTransaction);
        }
    }

    @Override
    public void delete(ItemPath itemPath, String path, Object transactionKey) throws PersistencyException {
        ArrayList<TransactionEntry> lockingTransaction = this.getLockingTransaction(itemPath, transactionKey);
        if (lockingTransaction == null) {
            this.locks.remove(itemPath);
        } else {
            this.createTransactionEntry(itemPath, null, path, lockingTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ArrayList<TransactionEntry> getLockingTransaction(ItemPath itemPath, Object transactionKey) throws PersistencyException {
        HashMap<ItemPath, Object> hashMap = this.locks;
        synchronized (hashMap) {
            if (this.locks.containsKey(itemPath)) {
                Object thisLocker = this.locks.get(itemPath);
                if (!thisLocker.equals(transactionKey)) throw new PersistencyException("Access denied: '" + itemPath + "' has been locked for writing by " + thisLocker);
                return this.pendingTransactions.get(transactionKey);
            }
            if (transactionKey == null) {
                this.locks.put(itemPath, new Object());
                return null;
            }
            this.locks.put(itemPath, transactionKey);
            ArrayList<TransactionEntry> lockerTransaction = new ArrayList();
            this.pendingTransactions.put(transactionKey, lockerTransaction);
            return lockerTransaction;
        }
    }

    private void createTransactionEntry(ItemPath itemPath, C2KLocalObject obj, String path, ArrayList<TransactionEntry> lockerTransaction) throws PersistencyException {
        TransactionEntry newEntry;
        if (obj != null) {
            newEntry = new TransactionEntry(itemPath, obj);
        } else if (path != null) {
            newEntry = new TransactionEntry(itemPath, path);
        } else {
            throw new PersistencyException("");
        }
        if (lockerTransaction.contains(newEntry)) {
            lockerTransaction.remove(newEntry);
        }
        lockerTransaction.add(newEntry);
    }

    @Override
    public void begin(Object transactionKey) throws PersistencyException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Object transactionKey) throws PersistencyException {
        HashMap<ItemPath, Object> hashMap = this.locks;
        synchronized (hashMap) {
            ArrayList<TransactionEntry> lockerTransactions = this.pendingTransactions.get(transactionKey);
            if (lockerTransactions == null) {
                return;
            }
            try {
                for (TransactionEntry transactionEntry : lockerTransactions) {
                }
                for (TransactionEntry thisEntry : lockerTransactions) {
                    this.locks.remove(thisEntry.itemPath);
                }
                this.pendingTransactions.remove(transactionKey);
            }
            catch (Exception e) {
                log.error("commit() - Problems during transaction commit of transactionKey " + transactionKey.toString() + ". Database may be in an inconsistent state.");
                this.dumpPendingTransactions(0);
                AbstractMain.shutdown(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort(Object transactionKey) {
        HashMap<ItemPath, Object> hashMap = this.locks;
        synchronized (hashMap) {
            if (this.locks.containsValue(transactionKey)) {
                for (ItemPath thisPath : this.locks.keySet()) {
                    if (!this.locks.get(thisPath).equals(transactionKey)) continue;
                    this.locks.remove(thisPath);
                }
            }
            this.pendingTransactions.remove(transactionKey);
        }
    }

    public void dumpPendingTransactions(int logLevel) {
        log.error("Transaction dump. Locked Items:");
        if (this.locks.size() == 0) {
            log.error("  None");
        } else {
            for (ItemPath thisPath : this.locks.keySet()) {
                Object transactionKey = this.locks.get(thisPath);
                log.error("  " + thisPath + " locked by " + transactionKey);
            }
        }
        log.error("Open transactions:");
        if (this.pendingTransactions.size() == 0) {
            log.error("  None");
        } else {
            for (Object thisLocker : this.pendingTransactions.keySet()) {
                log.error("  Transaction owner:" + thisLocker);
                ArrayList<TransactionEntry> entries = this.pendingTransactions.get(thisLocker);
                for (TransactionEntry thisEntry : entries) {
                    log.error("    " + thisEntry.toString());
                }
            }
        }
    }

    static class TransactionEntry {
        public ItemPath itemPath;
        public String path;
        public C2KLocalObject obj;

        public TransactionEntry(ItemPath itemPath, C2KLocalObject obj) {
            this.itemPath = itemPath;
            this.path = ClusterStorage.getPath(obj);
            this.obj = obj;
        }

        public TransactionEntry(ItemPath itemPath, String path) {
            this.itemPath = itemPath;
            this.path = path;
            this.obj = null;
        }

        public String toString() {
            StringBuffer report = new StringBuffer();
            if (this.obj == null) {
                report.append("Delete");
            } else {
                report.append("Put " + this.obj.getClass().getName());
            }
            report.append(" at ").append(this.path).append(" in ").append(this.itemPath);
            return report.toString();
        }

        public int hashCode() {
            return this.itemPath.hashCode() * this.path.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof TransactionEntry) {
                return this.hashCode() == ((TransactionEntry)other).hashCode();
            }
            return false;
        }
    }
}

