/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process.module;

import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.collection.BuiltInCollections;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.collection.CollectionMember;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.imports.ImportAgent;
import org.cristalise.kernel.entity.imports.ImportDependency;
import org.cristalise.kernel.entity.imports.ImportDependencyMember;
import org.cristalise.kernel.entity.imports.ImportItem;
import org.cristalise.kernel.entity.imports.ImportOutcome;
import org.cristalise.kernel.entity.imports.ImportRole;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.lifecycle.instance.predefined.UpdateImportReport;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.AbstractMain;
import org.cristalise.kernel.process.Bootstrap;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.module.ModuleActivity;
import org.cristalise.kernel.process.module.ModuleConfig;
import org.cristalise.kernel.process.module.ModuleEmbeddedScript;
import org.cristalise.kernel.process.module.ModuleImports;
import org.cristalise.kernel.process.module.ModuleInfo;
import org.cristalise.kernel.process.module.ModuleResource;
import org.cristalise.kernel.process.module.ModuleWorkflow;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.scripting.ErrorInfo;
import org.cristalise.kernel.scripting.ScriptingEngineException;
import org.cristalise.kernel.security.BuiltInAuthc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Module
extends ImportItem {
    private static final Logger log = LoggerFactory.getLogger(Module.class);
    private ModuleInfo info;
    private String resURL;
    private ArrayList<ModuleConfig> config = new ArrayList();
    private ModuleImports imports = new ModuleImports();
    private ArrayList<ModuleEmbeddedScript> scripts = new ArrayList();

    public Module() {
        this.properties.add(new Property(BuiltInItemProperties.TYPE, "Module", false));
        this.setInitialPath(BuiltInResources.MODULE_RESOURCE.getTypeRoot());
        this.setWorkflow(BuiltInResources.MODULE_RESOURCE.getWorkflowDef());
        this.setWorkflowVer(0);
        this.dependencyList.add(new ImportDependency(BuiltInCollections.CONTENTS));
    }

    public void runScript(String event, AgentProxy agent, boolean isServer) throws ScriptingEngineException {
        for (ModuleEmbeddedScript script : this.scripts) {
            if (!script.shouldRun(event, isServer)) continue;
            log.info("Running " + script.event + " " + script.target + " script from " + this.name);
            Object result = script.getScript(this.ns, agent).execute();
            if (result instanceof ErrorInfo) {
                ErrorInfo error = (ErrorInfo)result;
                log.error(error.toString());
                if (!error.getFatal()) continue;
                throw new ScriptingEngineException("Fatal Script Error");
            }
            if (result == null) continue;
            log.info(result.toString());
        }
    }

    public void setModuleXML(String moduleXML) {
        ImportOutcome moduleOutcome = new ImportOutcome("Module", 0, "last", null);
        moduleOutcome.data = moduleXML;
        this.outcomes.add(moduleOutcome);
    }

    @Override
    public void setNamespace(String ns) {
        super.setNamespace(ns);
        this.replaceProp(new Property(BuiltInItemProperties.NAMESPACE, ns, false));
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.replaceProp(new Property(BuiltInItemProperties.NAME, name, false));
    }

    private void replaceProp(Property newProp) {
        for (Property prop : this.properties) {
            if (!prop.getName().equals(newProp.getName())) continue;
            prop.setMutable(newProp.isMutable());
            prop.setValue(newProp.getValue());
            return;
        }
        this.properties.add(newProp);
    }

    private void addItemToContents(Path itemPath) {
        ImportDependency contents = (ImportDependency)this.dependencyList.get(0);
        contents.dependencyMemberList.add(new ImportDependencyMember(itemPath.toString()));
    }

    public void importAll(ItemProxy serverEntity, AgentProxy systemAgent, boolean reset) throws Exception {
        String moduleChanges = "";
        Object transactionKey = null;
        Gateway.getStorage().begin(transactionKey);
        try {
            if (!Bootstrap.shutdown) {
                moduleChanges = this.importResources(systemAgent, reset, transactionKey);
            }
            if (!Bootstrap.shutdown) {
                this.importRoles(systemAgent, reset, transactionKey);
            }
            if (!Bootstrap.shutdown) {
                this.importAgents(systemAgent, reset, transactionKey);
            }
            if (!Bootstrap.shutdown) {
                this.importItems(systemAgent, reset, transactionKey);
            }
            if (!Bootstrap.shutdown) {
                this.create(systemAgent.getPath(), reset, transactionKey);
            }
            if (!Bootstrap.shutdown && StringUtils.isNotBlank((CharSequence)moduleChanges)) {
                new UpdateImportReport().request((AgentPath)BuiltInAuthc.SYSTEM_AGENT.getPath(), this.itemPath, moduleChanges, transactionKey);
            }
            Gateway.getStorage().commit(transactionKey);
        }
        catch (Exception e) {
            Gateway.getStorage().abort(transactionKey);
            throw e;
        }
    }

    private void importItems(AgentProxy systemAgent, boolean reset, Object transactionKey) throws Exception {
        for (ImportItem thisItem : this.imports.getItems()) {
            if (Bootstrap.shutdown) {
                return;
            }
            thisItem.setNamespace(this.ns);
            this.addItemToContents(thisItem.create(systemAgent.getPath(), reset, transactionKey));
        }
    }

    private void importAgents(AgentProxy systemAgent, boolean reset, Object transactionKey) throws Exception {
        for (ImportAgent thisAgent : this.imports.getAgents()) {
            if (Bootstrap.shutdown) {
                return;
            }
            try {
                Gateway.getLookup().getAgentPath(thisAgent.name);
                log.info("importAgents() - Agent '" + thisAgent.name + "' found.");
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                log.info("importAgents() - Agent '" + thisAgent.name + "' not found. Creating.");
                this.addItemToContents(thisAgent.create(systemAgent.getPath(), reset, transactionKey));
            }
        }
    }

    private void importRoles(AgentProxy systemAgent, boolean reset, Object transactionKey) throws Exception {
        for (ImportRole thisRole : this.imports.getRoles()) {
            if (Bootstrap.shutdown) {
                return;
            }
            thisRole.create(systemAgent.getPath(), reset, transactionKey);
        }
    }

    private String importResources(AgentProxy systemAgent, boolean reset, Object transactionKey) throws Exception {
        ArrayList<String> moduleChanges = new ArrayList<String>();
        for (ModuleResource thisRes : this.imports.getResources()) {
            if (Bootstrap.shutdown) {
                return "";
            }
            try {
                thisRes.setNamespace(this.ns);
                this.addItemToContents(thisRes.create(systemAgent.getPath(), reset, transactionKey));
                moduleChanges.add(thisRes.getResourceChangeDetails());
            }
            catch (Exception ex) {
                log.error("Error importing module resources. Unsafe to continue.", (Throwable)ex);
                AbstractMain.shutdown(1);
            }
        }
        StringBuffer moduleChangesXML = new StringBuffer("<ModuleChanges>\n");
        moduleChangesXML.append("<ModuleName>" + this.name.replaceAll("\\s+", "") + "</ModuleName>");
        moduleChangesXML.append("<ModuleVersion>" + this.getVersion() + "</ModuleVersion>");
        for (String oneChange : moduleChanges) {
            moduleChangesXML.append(oneChange).append("\n");
        }
        moduleChangesXML.append("</ModuleChanges>");
        return moduleChangesXML.toString();
    }

    public Properties getProperties(boolean isServer) {
        Properties props = new Properties();
        for (ModuleConfig thisProp : this.config) {
            if (!thisProp.include(isServer)) continue;
            props.put(thisProp.name, thisProp.value);
        }
        return props;
    }

    public ArrayList<ModuleEmbeddedScript> getScripts() {
        return this.scripts;
    }

    public void setResURL(String resURL) {
        this.resURL = resURL;
    }

    public String getDesc() {
        return this.info.desc;
    }

    public Integer getVersion() {
        try {
            return new Integer(this.info.version);
        }
        catch (NumberFormatException e) {
            log.warn("getVersion() - failed to convert module version to integer", (Throwable)e);
            return -1;
        }
    }

    public String getResURL() {
        return this.resURL;
    }

    public ArrayList<String> getDependencies() {
        return this.info.dependency;
    }

    public boolean hasDependency(String dep) {
        return this.info.dependency.contains(dep);
    }

    public ModuleInfo getInfo() {
        return this.info;
    }

    public void setInfo(ModuleInfo info) {
        this.info = info;
        this.replaceProp(new Property(BuiltInItemProperties.VERSION, info.version, true));
    }

    public ModuleImports getImports() {
        return this.imports;
    }

    public void setImports(ModuleImports theImports) {
        this.imports = theImports;
    }

    public void setImports(Collection<?> contents) throws ObjectNotFoundException, InvalidDataException {
        this.imports.list.clear();
        this.addImports(contents);
    }

    public void addImports(Collection<?> contents) throws ObjectNotFoundException, InvalidDataException {
        for (CollectionMember mem : contents.getMembers().list) {
            ModuleResource newImport;
            String[] type;
            if (mem.getItemPath() == null) continue;
            ItemProxy child = mem.resolveItem();
            String name = child.getName();
            Integer version = Integer.valueOf(mem.getProperties().get(BuiltInItemProperties.VERSION.getName()).toString());
            switch (type = child.getProperty(BuiltInItemProperties.TYPE)) {
                case "ActivityDesc": {
                    String complex = child.getProperty(BuiltInItemProperties.COMPLEXITY);
                    if (complex.equals("Elementary")) {
                        newImport = new ModuleActivity(child, version);
                        break;
                    }
                    newImport = new ModuleWorkflow(child, version);
                    break;
                }
                case "Script": 
                case "Query": 
                case "StateMachine": 
                case "Schema": {
                    newImport = new ModuleResource();
                    break;
                }
                default: {
                    throw new InvalidDataException("Resource type '" + (String)type + "' unknown for module export");
                }
            }
            newImport.setName(name);
            newImport.setItemPath(mem.getItemPath());
            newImport.setNamespace(this.getNamespace());
            if (this.imports.list.contains(newImport)) continue;
            try {
                String childModule = child.getProperty(BuiltInItemProperties.MODULE);
                if (StringUtils.isNotBlank((CharSequence)childModule) && !childModule.equals(this.getNamespace())) {
                    return;
                }
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
            this.imports.list.add(newImport);
            for (String collName : child.getContents(ClusterType.COLLECTION)) {
                Collection<?> childColl = child.getCollection(collName, version);
                this.addImports(childColl);
            }
        }
    }

    public void setConfig(ArrayList<ModuleConfig> config) {
        this.config = config;
    }

    public void setScripts(ArrayList<ModuleEmbeddedScript> scripts) {
        this.scripts = scripts;
    }

    public ArrayList<ModuleConfig> getConfig() {
        return this.config;
    }

    public void export(File location) {
    }
}

