/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.utils;

import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.SystemKey;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.ActivityDef;
import org.cristalise.kernel.lifecycle.CompositeActivityDef;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.querying.Query;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.utils.ActDefCache;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.DescriptionObject;
import org.cristalise.kernel.utils.PropertyDescriptionCache;
import org.cristalise.kernel.utils.QueryCache;
import org.cristalise.kernel.utils.SchemaCache;
import org.cristalise.kernel.utils.ScriptCache;
import org.cristalise.kernel.utils.StateMachineCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalObjectLoader {
    private static final Logger log = LoggerFactory.getLogger(LocalObjectLoader.class);
    private static ActDefCache actCache = new ActDefCache(null);
    private static ActDefCache compActCache = new ActDefCache(true);
    private static ActDefCache elemActCache = new ActDefCache(false);
    private static StateMachineCache smCache = new StateMachineCache();
    private static SchemaCache schCache = new SchemaCache();
    private static ScriptCache scrCache = new ScriptCache();
    private static QueryCache queryCache = new QueryCache();
    private static PropertyDescriptionCache propDescCache = new PropertyDescriptionCache();

    public static Script getScript(String scriptName, int scriptVersion) throws ObjectNotFoundException, InvalidDataException {
        log.trace("getScript(" + scriptName + " v" + scriptVersion + ")");
        return (Script)scrCache.get(scriptName, scriptVersion);
    }

    public static Script getScript(CastorHashMap properties) throws InvalidDataException, ObjectNotFoundException {
        return (Script)LocalObjectLoader.getDescObjectByProperty(properties, BuiltInVertexProperties.SCRIPT_NAME, BuiltInVertexProperties.SCRIPT_VERSION);
    }

    public static Query getQuery(String queryName, int queryVersion) throws ObjectNotFoundException, InvalidDataException {
        log.trace("getQuery(" + queryName + " v" + queryVersion + ")");
        return (Query)queryCache.get(queryName, queryVersion);
    }

    public static Query getQuery(CastorHashMap properties) throws InvalidDataException, ObjectNotFoundException {
        return (Query)LocalObjectLoader.getDescObjectByProperty(properties, BuiltInVertexProperties.QUERY_NAME, BuiltInVertexProperties.QUERY_VERSION);
    }

    public static Schema getSchema(String schemaName, int schemaVersion) throws ObjectNotFoundException, InvalidDataException {
        log.trace("getSchema(" + schemaName + " v" + schemaVersion + ")");
        if (schemaName.equals("Schema") && schemaVersion == 0) {
            return new Schema(schemaName, schemaVersion, new ItemPath(new SystemKey(0L, 5L)), "");
        }
        return (Schema)schCache.get(schemaName, schemaVersion);
    }

    public static Schema getSchema(CastorHashMap properties) throws InvalidDataException, ObjectNotFoundException {
        return (Schema)LocalObjectLoader.getDescObjectByProperty(properties, BuiltInVertexProperties.SCHEMA_NAME, BuiltInVertexProperties.SCHEMA_VERSION);
    }

    public static ActivityDef getActDef(String actName, int actVersion) throws ObjectNotFoundException, InvalidDataException {
        log.trace("getActDef(" + actName + " v" + actVersion + ")");
        return (ActivityDef)actCache.get(actName, actVersion);
    }

    public static CompositeActivityDef getCompActDef(String actName, int actVersion) throws ObjectNotFoundException, InvalidDataException {
        log.trace("getCompActDef(" + actName + " v" + actVersion + ")");
        return (CompositeActivityDef)compActCache.get(actName, actVersion);
    }

    public static ActivityDef getElemActDef(String actName, int actVersion) throws ObjectNotFoundException, InvalidDataException {
        log.trace("getElemActDef(" + actName + " v" + actVersion + ")");
        return (ActivityDef)elemActCache.get(actName, actVersion);
    }

    public static StateMachine getStateMachine(String smName, int smVersion) throws ObjectNotFoundException, InvalidDataException {
        log.trace("getStateMachine(" + smName + " v" + smVersion + ")");
        return (StateMachine)smCache.get(smName, smVersion);
    }

    public static StateMachine getStateMachine(CastorHashMap properties) throws InvalidDataException, ObjectNotFoundException {
        return (StateMachine)LocalObjectLoader.getDescObjectByProperty(properties, BuiltInVertexProperties.STATE_MACHINE_NAME, BuiltInVertexProperties.STATE_MACHINE_VERSION);
    }

    public static PropertyDescriptionList getPropertyDescriptionList(String name, int version) throws ObjectNotFoundException, InvalidDataException {
        log.trace("PropertyDescriptionList(" + name + " v" + version + ")");
        return (PropertyDescriptionList)propDescCache.get(name, version);
    }

    public static PropertyDescriptionList getPropertyDescriptionList(CastorHashMap properties) throws InvalidDataException, ObjectNotFoundException {
        return (PropertyDescriptionList)LocalObjectLoader.getDescObjectByProperty(properties, BuiltInVertexProperties.PROPERTY_DEF_NAME, BuiltInVertexProperties.PROPERTY_DEF_VERSION);
    }

    private static DescriptionObject getDescObjectByProperty(CastorHashMap properties, BuiltInVertexProperties nameProp, BuiltInVertexProperties verProp) throws InvalidDataException, ObjectNotFoundException {
        String resName = (String)properties.getBuiltInProperty(nameProp);
        if (!properties.isAbstract(nameProp) && StringUtils.isNotBlank((CharSequence)resName)) {
            Integer resVer = LocalObjectLoader.deriveVersionNumber(properties.getBuiltInProperty(verProp));
            log.trace("getDescObjectByProperty() - " + (Object)((Object)nameProp) + ":" + resName + " v" + resVer + ")");
            if (resVer == null && !properties.isAbstract(verProp)) {
                throw new InvalidDataException("Invalid version property '" + resVer + "' in " + (Object)((Object)verProp));
            }
            switch (nameProp) {
                case SCHEMA_NAME: {
                    return LocalObjectLoader.getSchema(resName, resVer);
                }
                case SCRIPT_NAME: {
                    return LocalObjectLoader.getScript(resName, resVer);
                }
                case QUERY_NAME: {
                    return LocalObjectLoader.getQuery(resName, resVer);
                }
                case STATE_MACHINE_NAME: {
                    return LocalObjectLoader.getStateMachine(resName, resVer);
                }
                case PROPERTY_DEF_NAME: {
                    return LocalObjectLoader.getPropertyDescriptionList(resName, resVer);
                }
            }
            throw new InvalidDataException("LocalObjectLoader CANNOT handle BuiltInVertexPropertie:" + (Object)((Object)nameProp));
        }
        return null;
    }

    public static Integer deriveVersionNumber(Object value) throws InvalidDataException {
        if (value == null || "".equals(value)) {
            return null;
        }
        try {
            Integer version = Integer.valueOf(value.toString());
            if (version == -1) {
                return null;
            }
            return version;
        }
        catch (NumberFormatException ex) {
            throw new InvalidDataException("Invalid version number : " + value.toString());
        }
    }
}

