/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.persistency;

import java.util.ArrayList;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.auth.Authenticator;
import org.cristalise.kernel.querying.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClusterStorage {
    private static final Logger log = LoggerFactory.getLogger(ClusterStorage.class);
    public static final short NONE = 0;
    public static final short READ = 1;
    public static final short WRITE = 2;
    public static final short READWRITE = 3;

    public abstract void open(Authenticator var1) throws PersistencyException;

    public abstract void close() throws PersistencyException;

    public abstract void postBoostrap() throws PersistencyException;

    public abstract void postStartServer() throws PersistencyException;

    public abstract void postConnect() throws PersistencyException;

    public abstract short queryClusterSupport(ClusterType var1);

    public abstract boolean checkQuerySupport(String var1);

    public abstract String getName();

    public abstract String getId();

    protected static ClusterType getClusterType(String path) {
        try {
            if (path == null || path.length() == 0) {
                return ClusterType.ROOT;
            }
            int start = path.charAt(0) == '/' ? 1 : 0;
            int end = path.indexOf(47, start + 1);
            if (end == -1) {
                end = path.length();
            }
            return ClusterType.getValue(path.substring(start, end));
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
            return ClusterType.ROOT;
        }
    }

    public static String getPath(C2KLocalObject obj) {
        if (obj.getClusterType() == null) {
            return null;
        }
        return obj.getClusterPath();
    }

    public abstract String executeQuery(Query var1, Object var2) throws PersistencyException;

    public abstract int getLastIntegerId(ItemPath var1, String var2, Object var3) throws PersistencyException;

    public abstract C2KLocalObject get(ItemPath var1, String var2, Object var3) throws PersistencyException;

    public abstract void put(ItemPath var1, C2KLocalObject var2, Object var3) throws PersistencyException;

    public abstract void delete(ItemPath var1, String var2, Object var3) throws PersistencyException;

    public abstract String[] getClusterContents(ItemPath var1, String var2, Object var3) throws PersistencyException;

    public String[] getClusterContents(ItemPath itemPath, ClusterType type, Object transactionKey) throws PersistencyException {
        return this.getClusterContents(itemPath, type.getName(), transactionKey);
    }

    public ClusterType[] getClusters(ItemPath itemPath, Object transactionKey) throws PersistencyException {
        String[] contents = this.getClusterContents(itemPath, "", transactionKey);
        ArrayList<ClusterType> types = new ArrayList<ClusterType>();
        for (String content : contents) {
            ClusterType type = ClusterType.getValue(content);
            if (type != null) {
                types.add(type);
                continue;
            }
            log.warn("Cannot convert content '{}' to ClusterType", (Object)content);
        }
        return types.toArray(new ClusterType[0]);
    }

    public abstract void begin(Object var1) throws PersistencyException;

    public abstract void commit(Object var1) throws PersistencyException;

    public abstract void abort(Object var1) throws PersistencyException;
}

