/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.InvalidTransitionException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.common.SystemKey;
import org.cristalise.kernel.entity.ItemOperations;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.entity.agent.JobArrayList;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.Workflow;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStepContainer;
import org.cristalise.kernel.lifecycle.instance.predefined.item.CreateItemFromDescription;
import org.cristalise.kernel.lifecycle.instance.predefined.item.ItemPredefinedStepContainer;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.InvalidAgentPathException;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.persistency.ClusterStorageManager;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.property.PropertyArrayList;
import org.cristalise.kernel.scripting.ErrorInfo;
import org.cristalise.kernel.security.SecurityManager;
import org.cristalise.kernel.utils.CastorXMLUtility;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemImplementation
implements ItemOperations {
    private static final Logger log = LoggerFactory.getLogger(ItemImplementation.class);
    protected final ClusterStorageManager mStorage = Gateway.getStorage();
    protected final ItemPath mItemPath;

    protected ItemImplementation(ItemPath key) {
        this.mItemPath = key;
    }

    public SystemKey getSystemKey() {
        return this.mItemPath.getSystemKey();
    }

    public UUID getUUID() {
        return this.mItemPath.getUUID();
    }

    public void initialise(SystemKey agentId, String propString, String initWfString, String initCollsString, String initViewpointString, String initOutcomeString) throws AccessRightsException, InvalidDataException, PersistencyException {
        AgentPath agentPath;
        log.debug("initialise(" + this.mItemPath + ") - agent:" + agentId);
        Object locker = new Object();
        this.mStorage.begin(locker);
        try {
            agentPath = new AgentPath(agentId);
        }
        catch (InvalidItemPathException e) {
            throw new AccessRightsException("Invalid Agent Id:" + agentId);
        }
        if (StringUtils.isBlank((CharSequence)propString) || propString.equals("<NULL/>")) {
            throw new InvalidDataException("No properties supplied");
        }
        try {
            CastorXMLUtility xml = Gateway.getMarshaller();
            CreateItemFromDescription.storeItem(agentPath, this.mItemPath, (PropertyArrayList)xml.unmarshall(propString), StringUtils.isNotBlank((CharSequence)initCollsString) && !initCollsString.equals("<NULL/>") ? (CollectionArrayList)xml.unmarshall(initCollsString) : null, StringUtils.isNotBlank((CharSequence)initWfString) && !initWfString.equals("<NULL/>") ? (CompositeActivity)xml.unmarshall(initWfString) : null, StringUtils.isNotBlank((CharSequence)initViewpointString) ? (Viewpoint)xml.unmarshall(initViewpointString) : null, initOutcomeString, locker);
        }
        catch (InvalidDataException | PersistencyException e) {
            log.error("initialise({}) - invalid data: {}", (Object)this.mItemPath, (Object)e);
            this.mStorage.abort(locker);
            throw e;
        }
        catch (Exception e) {
            log.error("initialise({}) - invalid data: {}", (Object)this.mItemPath, (Object)e);
            this.mStorage.abort(locker);
            throw new InvalidDataException("Properties were invalid");
        }
        this.mStorage.commit(locker);
        log.info("Initialisation of item " + this.mItemPath + " was successful");
    }

    protected PredefinedStepContainer getNewPredefStepContainer() {
        return new ItemPredefinedStepContainer();
    }

    public String requestAction(SystemKey agentId, String stepPath, int transitionID, String requestData, String fileName, byte[] attachment) throws AccessRightsException, InvalidTransitionException, ObjectNotFoundException, InvalidDataException, PersistencyException, ObjectAlreadyExistsException, InvalidCollectionModification {
        return this.delegatedAction(agentId, null, stepPath, transitionID, requestData, fileName, attachment);
    }

    public String delegatedAction(SystemKey agentId, SystemKey delegateId, String stepPath, int transitionID, String requestData, String fileName, byte[] attachment) throws AccessRightsException, InvalidTransitionException, ObjectNotFoundException, InvalidDataException, PersistencyException, ObjectAlreadyExistsException, InvalidCollectionModification {
        Workflow lifeCycle = null;
        try {
            AgentPath agent = new AgentPath(agentId);
            AgentPath delegate = delegateId == null ? null : new AgentPath(delegateId);
            AgentPath agentToUse = delegate == null ? agent : delegate;
            log.info("request(" + this.mItemPath + ") Transition " + transitionID + " on " + stepPath + " by " + (delegate == null ? "" : delegate + " on behalf of ") + agent);
            lifeCycle = (Workflow)this.mStorage.get(this.mItemPath, (Object)((Object)ClusterType.LIFECYCLE) + "/workflow", null);
            this.mStorage.begin(lifeCycle);
            SecurityManager secMan = Gateway.getSecurityManager();
            Activity act = (Activity)lifeCycle.search(stepPath);
            if (act != null) {
                if (secMan.isShiroEnabled() && !secMan.checkPermissions(agentToUse, act, this.mItemPath)) {
                    if (log.isTraceEnabled()) {
                        for (RolePath role : agent.getRoles()) {
                            log.error(role.dump());
                        }
                    }
                    throw new AccessRightsException("'" + agentToUse.getAgentName() + "' is NOT permitted to execute step:" + stepPath);
                }
            } else {
                throw new InvalidDataException("Step '" + stepPath + "' is not available for item:" + this.mItemPath);
            }
            String finalOutcome = lifeCycle.requestAction(agent, delegate, stepPath, this.mItemPath, transitionID, requestData, fileName, attachment);
            if (!stepPath.startsWith("workflow/predefined")) {
                this.mStorage.put(this.mItemPath, lifeCycle, lifeCycle);
            }
            if (stepPath.equals("workflow/predefined/Erase")) {
                log.info("Erasing item path " + this.mItemPath.toString());
                Gateway.getLookupManager().delete(this.mItemPath);
            }
            this.mStorage.commit(lifeCycle);
            return finalOutcome;
        }
        catch (AccessRightsException | InvalidCollectionModification | InvalidDataException | InvalidTransitionException | ObjectAlreadyExistsException | ObjectNotFoundException | PersistencyException ex) {
            log.error("", ex);
            String errorOutcome = this.handleError(agentId, delegateId, stepPath, lifeCycle, (Exception)ex);
            if (StringUtils.isBlank((CharSequence)errorOutcome)) {
                this.mStorage.abort(lifeCycle);
                throw ex;
            }
            this.mStorage.commit(lifeCycle);
            return errorOutcome;
        }
        catch (CannotManageException | ObjectCannotBeUpdated | InvalidAgentPathException ex) {
            log.error("", ex);
            String errorOutcome = this.handleError(agentId, delegateId, stepPath, lifeCycle, (Exception)ex);
            if (StringUtils.isBlank((CharSequence)errorOutcome)) {
                this.mStorage.abort(lifeCycle);
                throw new InvalidDataException(ex.getClass().getName() + " - " + ex.getMessage());
            }
            this.mStorage.commit(lifeCycle);
            return errorOutcome;
        }
        catch (Exception ex) {
            log.error("Unknown Error: requestAction on " + this.mItemPath + " by " + agentId + " executing " + stepPath, (Throwable)ex);
            String errorOutcome = this.handleError(agentId, delegateId, stepPath, lifeCycle, ex);
            if (StringUtils.isBlank((CharSequence)errorOutcome)) {
                this.mStorage.abort(lifeCycle);
                throw new InvalidDataException("Extraordinary Exception during execution:" + ex.getClass().getName() + " - " + ex.getMessage());
            }
            this.mStorage.commit(lifeCycle);
            return errorOutcome;
        }
    }

    private String handleError(SystemKey agentId, SystemKey delegateId, String stepPath, Workflow lifeCycle, Exception ex) throws PersistencyException, ObjectNotFoundException, AccessRightsException, InvalidTransitionException, InvalidDataException, ObjectAlreadyExistsException, InvalidCollectionModification {
        if (!Gateway.getProperties().getBoolean("StateMachine.enableErrorHandling", false)) {
            return null;
        }
        int errorTransId = ((Activity)lifeCycle.search(stepPath)).getErrorTransitionId();
        if (errorTransId == -1) {
            return null;
        }
        try {
            AgentPath agent = new AgentPath(agentId);
            AgentPath delegate = delegateId == null ? null : new AgentPath(delegateId);
            String errorOutcome = Gateway.getMarshaller().marshall(new ErrorInfo(ex));
            lifeCycle.requestAction(agent, delegate, stepPath, this.mItemPath, errorTransId, errorOutcome, "", null);
            if (!stepPath.startsWith("workflow/predefined")) {
                this.mStorage.put(this.mItemPath, lifeCycle, lifeCycle);
            }
            return errorOutcome;
        }
        catch (IOException | CannotManageException | ObjectCannotBeUpdated | InvalidAgentPathException | MappingException | MarshalException | ValidationException e) {
            log.error("", e);
            return "";
        }
    }

    public String queryLifeCycle(SystemKey agentId, boolean filter) throws AccessRightsException, ObjectNotFoundException, PersistencyException {
        log.info("queryLifeCycle(" + this.mItemPath + ") - agent: " + agentId);
        try {
            AgentPath agent;
            try {
                agent = new AgentPath(agentId);
            }
            catch (InvalidItemPathException e) {
                throw new AccessRightsException("Agent " + agentId + " doesn't exist");
            }
            Workflow wf = (Workflow)this.mStorage.get(this.mItemPath, (Object)((Object)ClusterType.LIFECYCLE) + "/workflow", null);
            JobArrayList jobBag = new JobArrayList();
            CompositeActivity domainWf = (CompositeActivity)wf.search("workflow/domain");
            ArrayList<Job> jobs = filter ? domainWf.calculateJobs(agent, this.mItemPath, true) : domainWf.calculateAllJobs(agent, this.mItemPath, true);
            SecurityManager secMan = Gateway.getSecurityManager();
            if (secMan.isShiroEnabled()) {
                for (Job j : jobs) {
                    Activity act = (Activity)wf.search(j.getStepPath());
                    if (!secMan.checkPermissions(agent, act, this.mItemPath)) continue;
                    try {
                        j.getTransition().getPerformingRole(act, agent);
                        jobBag.list.add(j);
                    }
                    catch (AccessRightsException accessRightsException) {}
                }
            } else {
                jobBag.list = jobs;
            }
            log.info("queryLifeCycle(" + this.mItemPath + ") - Returning " + jobBag.list.size() + " jobs.");
            try {
                return Gateway.getMarshaller().marshall(jobBag);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                throw new PersistencyException("Error marshalling job bag");
            }
        }
        catch (AccessRightsException | ObjectNotFoundException | PersistencyException e) {
            log.error("", e);
            throw e;
        }
        catch (Exception ex) {
            log.error("queryLifeCycle(" + this.mItemPath + ") - Unknown error", (Throwable)ex);
            throw new PersistencyException("Unknown error querying jobs. Please see server log.");
        }
    }

    public String queryData(String path) throws AccessRightsException, ObjectNotFoundException, PersistencyException {
        String result = "";
        log.info("queryData(" + this.mItemPath + ") - " + path);
        try {
            if (path.endsWith("/all")) {
                int allPos = path.lastIndexOf("all");
                String query = path.substring(0, allPos);
                String[] ids = this.mStorage.getClusterContents(this.mItemPath, query);
                for (int i = 0; i < ids.length; ++i) {
                    result = result + ids[i];
                    if (i == ids.length - 1) continue;
                    result = result + ",";
                }
            } else {
                result = Gateway.getMarshaller().marshall(this.mStorage.get(this.mItemPath, path, null));
            }
        }
        catch (ObjectNotFoundException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.warn("queryData(" + this.mItemPath + ") - " + path + " Failed: " + ex.getClass().getName());
            throw new PersistencyException("Server exception: " + ex.getClass().getName());
        }
        log.trace("queryData(" + this.mItemPath + ") - result:" + result);
        return result;
    }

    protected void finalize() throws Throwable {
        log.debug("finalize reaping " + this.mItemPath);
        Gateway.getStorage().clearCache(this.mItemPath, null);
        super.finalize();
    }
}

