/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.agent;

import java.util.List;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.common.SystemKey;
import org.cristalise.kernel.entity.AgentOperations;
import org.cristalise.kernel.entity.ItemImplementation;
import org.cristalise.kernel.entity.agent.Job;
import org.cristalise.kernel.entity.agent.JobArrayList;
import org.cristalise.kernel.entity.agent.JobList;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStepContainer;
import org.cristalise.kernel.lifecycle.instance.predefined.agent.AgentPredefinedStepContainer;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.process.Gateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentImplementation
extends ItemImplementation
implements AgentOperations {
    private static final Logger log = LoggerFactory.getLogger(AgentImplementation.class);

    public AgentImplementation(AgentPath path) {
        super(path);
    }

    public synchronized void refreshJobList(SystemKey sysKey, String stepPath, String newJobs) {
        try {
            ItemPath itemPath = new ItemPath(sysKey);
            this.mStorage.begin(this.mItemPath);
            JobArrayList newJobList = (JobArrayList)Gateway.getMarshaller().unmarshall(newJobs);
            JobList currentJobs = new JobList((AgentPath)this.mItemPath, this.mItemPath);
            List<String> keysToRemove = currentJobs.getKeysForStep(itemPath, stepPath);
            for (Job newJob : newJobList.list) {
                log.debug("refreshJobList() - Adding job:" + newJob.getItemPath() + "/" + newJob.getStepPath() + ":" + newJob.getTransition().getName());
                currentJobs.addJob(newJob);
            }
            for (String key : keysToRemove) {
                currentJobs.remove(key);
            }
            this.mStorage.commit(this.mItemPath);
        }
        catch (Throwable ex) {
            log.error("Could not refresh job list.", ex);
            try {
                Gateway.getStorage().abort(this.mItemPath);
            }
            catch (PersistencyException e) {
                log.error("Could not abort transaction.", (Throwable)e);
            }
        }
    }

    public void addRole(String roleName) throws CannotManageException, ObjectNotFoundException {
        RolePath newRole = Gateway.getLookup().getRolePath(roleName);
        try {
            Gateway.getLookupManager().addRole((AgentPath)this.mItemPath, newRole);
        }
        catch (ObjectCannotBeUpdated ex) {
            throw new CannotManageException("Could not update role");
        }
    }

    public void removeRole(String roleName) throws CannotManageException, ObjectNotFoundException {
        RolePath rolePath = Gateway.getLookup().getRolePath(roleName);
        try {
            Gateway.getLookupManager().removeRole((AgentPath)this.mItemPath, rolePath);
        }
        catch (ObjectCannotBeUpdated ex) {
            throw new CannotManageException("Could not update role");
        }
    }

    @Override
    protected PredefinedStepContainer getNewPredefStepContainer() {
        return new AgentPredefinedStepContainer();
    }

    @Override
    protected void finalize() throws Throwable {
        log.debug("finalize() - Reaping " + this.mItemPath);
        Gateway.getStorage().clearCache(this.mItemPath, null);
        super.finalize();
    }
}

