/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.agent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.GTimeStamp;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.lifecycle.instance.stateMachine.Transition;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.InvalidAgentPathException;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.OutcomeAttachment;
import org.cristalise.kernel.persistency.outcome.OutcomeInitiator;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.querying.Query;
import org.cristalise.kernel.scripting.ErrorInfo;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.DateUtility;
import org.cristalise.kernel.utils.KeyValuePair;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Job
implements C2KLocalObject {
    private static final Logger log = LoggerFactory.getLogger(Job.class);
    private int id;
    private ItemPath itemPath;
    private String stepName;
    private String stepPath;
    private String stepType;
    private Transition transition;
    private String originStateName;
    private String targetStateName;
    private String agentRole;
    private AgentPath agentPath;
    private AgentPath delegatePath;
    private CastorHashMap actProps = new CastorHashMap();
    private GTimeStamp creationDate;
    private ErrorInfo error;
    private ItemProxy item = null;
    private boolean transitionResolved = false;
    private Outcome outcome = null;
    private OutcomeAttachment attachment = null;
    private static HashMap<String, OutcomeInitiator> ocInitCache = new HashMap();

    public Job() {
        this.setCreationDate(DateUtility.getNow());
        this.setActProps(new CastorHashMap());
    }

    public Job(Activity act, ItemPath itemPath, Transition transition, AgentPath agent, AgentPath delegate, String role) throws InvalidDataException, ObjectNotFoundException, InvalidAgentPathException {
        this.setCreationDate(DateUtility.getNow());
        this.setItemPath(itemPath);
        this.setStepPath(act.getPath());
        this.setTransition(transition);
        this.setOriginStateName(act.getStateMachine().getState(transition.getOriginStateId()).getName());
        this.setTargetStateName(act.getStateMachine().getState(transition.getTargetStateId()).getName());
        this.setStepName(act.getName());
        this.setStepType(act.getType());
        this.setAgentPath(agent);
        this.setAgentRole(role);
        this.setActPropsAndEvaluateValues(act);
        this.getItem();
    }

    public Job(int id, ItemPath itemPath, String stepName, String stepPath, String stepType, Transition transition, String originStateName, String targetStateName, String agentRole, AgentPath agentPath, AgentPath delegatePath, CastorHashMap actProps, GTimeStamp creationDate) {
        this.setId(id);
        this.setItemPath(itemPath);
        this.setStepName(stepName);
        this.setStepPath(stepPath);
        this.setStepType(stepType);
        this.setTransition(transition);
        this.setOriginStateName(originStateName);
        this.setTargetStateName(targetStateName);
        this.setAgentRole(agentRole);
        this.setAgentPath(agentPath);
        this.setDelegatePath(delegatePath);
        this.setActProps(actProps);
        this.setCreationDate(creationDate);
    }

    public void setItemPath(ItemPath path) {
        this.itemPath = path;
        this.item = null;
    }

    public void setItemUUID(String uuid) throws InvalidItemPathException {
        this.setItemPath(new ItemPath(uuid));
    }

    public String getItemUUID() {
        return this.getItemPath().getUUID().toString();
    }

    public ItemProxy getItem() throws InvalidDataException {
        try {
            return this.getItemProxy();
        }
        catch (ObjectNotFoundException | InvalidItemPathException e) {
            throw new InvalidDataException(e.getMessage());
        }
    }

    public Transition getTransition() {
        if (this.transition != null && !this.transitionResolved) {
            log.debug("getTransition() - retrieving state machine for actProps:{}", (Object)this.actProps);
            try {
                StateMachine sm = LocalObjectLoader.getStateMachine(this.actProps);
                this.transition = sm.getTransition(this.transition.getId());
                this.transitionResolved = true;
            }
            catch (Exception e) {
                log.error("Cannot retrieve state machine for actProps:{}", (Object)this.actProps, (Object)e);
                return this.transition;
            }
        }
        return this.transition;
    }

    public void setTransition(Transition transition) {
        this.transition = transition;
        this.transitionResolved = false;
    }

    public void setAgentUUID(String uuid) throws InvalidItemPathException {
        if (StringUtils.isBlank((CharSequence)uuid)) {
            this.agentPath = null;
            this.delegatePath = null;
        } else if (uuid.contains(":")) {
            String[] agentStr = uuid.split(":");
            if (agentStr.length != 2) {
                throw new InvalidItemPathException("Cannot set UUID of agent and delegate from string:" + uuid);
            }
            this.setAgentPath(new AgentPath(agentStr[0]));
            this.setDelegatePath(new AgentPath(agentStr[1]));
        } else {
            this.setAgentPath(new AgentPath(uuid));
        }
    }

    public String getAgentUUID() {
        if (this.agentPath != null) {
            if (this.delegatePath != null) {
                return this.getAgentPath().getUUID().toString() + ":" + this.getDelegatePath().getUUID().toString();
            }
            return this.getAgentPath().getUUID().toString();
        }
        return null;
    }

    public String getAgentName() {
        String agentName = null;
        if (this.agentPath != null) {
            agentName = this.agentPath.getAgentName();
        }
        if (agentName == null) {
            agentName = (String)this.actProps.getBuiltInProperty(BuiltInVertexProperties.AGENT_NAME);
        }
        return agentName;
    }

    public String getDelegateName() {
        String delegateName = null;
        if (this.delegatePath != null) {
            delegateName = this.delegatePath.getAgentName();
        }
        if (delegateName == null) {
            delegateName = (String)this.actProps.getBuiltInProperty(BuiltInVertexProperties.DELEGATE_NAME);
        }
        return delegateName;
    }

    public Schema getSchema() throws InvalidDataException, ObjectNotFoundException {
        if (this.getTransition().hasOutcome(this.actProps)) {
            return this.getTransition().getSchema(this.actProps);
        }
        return null;
    }

    @Deprecated
    public String getSchemaName() throws InvalidDataException, ObjectNotFoundException {
        try {
            return this.getSchema().getName();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Deprecated
    public int getSchemaVersion() throws InvalidDataException, ObjectNotFoundException {
        try {
            return this.getSchema().getVersion();
        }
        catch (Exception e) {
            return -1;
        }
    }

    public boolean isOutcomeRequired() {
        return this.getTransition().hasOutcome(this.actProps) && this.getTransition().getOutcome().isRequired();
    }

    public Script getScript() throws ObjectNotFoundException, InvalidDataException {
        if (this.getTransition().hasScript(this.actProps)) {
            return this.getTransition().getScript(this.actProps);
        }
        return null;
    }

    public Query getQuery() throws ObjectNotFoundException, InvalidDataException {
        if (this.hasQuery()) {
            Query query = this.getTransition().getQuery(this.actProps);
            query.setParemeterValues(this.itemPath.getUUID().toString(), this.getSchemaName(), this.actProps);
            return query;
        }
        return null;
    }

    @Deprecated
    public String getScriptName() {
        try {
            return this.getScript().getName();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Deprecated
    public int getScriptVersion() throws InvalidDataException {
        try {
            return this.getScript().getVersion();
        }
        catch (Exception e) {
            return -1;
        }
    }

    public KeyValuePair[] getKeyValuePairs() {
        return this.actProps.getKeyValuePairs();
    }

    public void setKeyValuePairs(KeyValuePair[] pairs) {
        this.actProps.setKeyValuePairs(pairs);
    }

    @Override
    public String getName() {
        return Integer.toString(this.id);
    }

    @Override
    public void setName(String name) {
        this.id = Integer.parseInt(name);
    }

    public ItemProxy getItemProxy() throws ObjectNotFoundException, InvalidItemPathException {
        if (this.item == null) {
            this.item = Gateway.getProxyManager().getProxy(this.itemPath);
        }
        return this.item;
    }

    public String getDescription() {
        String desc = (String)this.actProps.get("Description");
        if (desc == null) {
            desc = "No Description";
        }
        return desc;
    }

    public void setOutcome(String outcomeData) throws InvalidDataException, ObjectNotFoundException {
        this.setOutcome(new Outcome(-1, outcomeData, this.transition.getSchema(this.actProps)));
    }

    public void setOutcome(Outcome o) {
        this.outcome = o;
    }

    public void setError(ErrorInfo errors) {
        this.error = errors;
        try {
            this.setOutcome(Gateway.getMarshaller().marshall(this.error));
        }
        catch (Exception e) {
            log.error("Error marshalling ErrorInfo in job", (Throwable)e);
        }
    }

    public String getValidViewpointName() {
        String viewName = this.getActPropString("Viewpoint");
        if (StringUtils.isBlank((CharSequence)viewName) || viewName.startsWith("xpath:")) {
            viewName = "last";
        }
        log.info("Job.getValidViewpointName() - returning Viewpoint:'{}'", (Object)viewName);
        return viewName;
    }

    public Outcome getLastOutcome() throws InvalidDataException, ObjectNotFoundException {
        try {
            return this.item.getViewpoint(this.getSchema().getName(), this.getValidViewpointName()).getOutcome();
        }
        catch (PersistencyException e) {
            log.error("Error loading viewpoint", (Throwable)e);
            throw new InvalidDataException("Error loading viewpoint:" + e.getMessage());
        }
    }

    public String getLastView() throws InvalidDataException, ObjectNotFoundException {
        return this.getLastOutcome().getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutcomeInitiator getOutcomeInitiator() throws InvalidDataException {
        String ocInitName = this.getActPropString(BuiltInVertexProperties.OUTCOME_INIT);
        if (StringUtils.isNotBlank((CharSequence)ocInitName)) {
            OutcomeInitiator ocInit;
            String ocConfigPropName = BuiltInVertexProperties.OUTCOME_INIT.getName() + "." + ocInitName;
            HashMap<String, OutcomeInitiator> hashMap = ocInitCache;
            synchronized (hashMap) {
                log.info("Job.getOutcomeInitiator() - ocConfigPropName:{}", (Object)ocConfigPropName);
                ocInit = ocInitCache.get(ocConfigPropName);
                if (ocInit == null) {
                    if (!Gateway.getProperties().containsKey(ocConfigPropName)) {
                        throw new InvalidDataException("Property OutcomeInstantiator " + ocConfigPropName + " isn't defined. Check module.xml");
                    }
                    try {
                        ocInit = (OutcomeInitiator)Gateway.getProperties().getInstance(ocConfigPropName);
                        ocInitCache.put(ocConfigPropName, ocInit);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        log.error("OutcomeInstantiator {} couldn't be instantiated", (Object)ocConfigPropName, (Object)e);
                        throw new InvalidDataException("OutcomeInstantiator " + ocConfigPropName + " couldn't be instantiated:" + e.getMessage());
                    }
                }
            }
            return ocInit;
        }
        return null;
    }

    public String getOutcomeString() throws InvalidDataException, ObjectNotFoundException {
        if (this.outcome != null) {
            return this.outcome.getData();
        }
        this.getOutcome();
        if (this.outcome != null) {
            return this.outcome.getData();
        }
        return null;
    }

    public Outcome getOutcome() throws InvalidDataException, ObjectNotFoundException {
        if (this.outcome == null && this.hasOutcome()) {
            OutcomeInitiator ocInit;
            boolean useViewpoint = Gateway.getProperties().getBoolean("OutcomeInit.jobUseViewpoint", false);
            if (useViewpoint && this.getItem().checkViewpoint(this.getSchema().getName(), this.getValidViewpointName())) {
                Outcome tempOutcome = this.getLastOutcome();
                this.outcome = new Outcome(tempOutcome.getData(), tempOutcome.getSchema());
            }
            if (this.outcome == null && (ocInit = this.getOutcomeInitiator()) != null) {
                this.outcome = ocInit.initOutcomeInstance(this);
            }
            if (this.outcome == null) {
                log.warn("getOutcome() - Could not initilase Outcome for Job:{}", (Object)this);
            }
        } else if (!this.hasOutcome()) {
            log.debug("getOutcome() - No Outcome description for Job:{}", (Object)this);
        }
        return this.outcome;
    }

    public boolean hasOutcome() {
        return this.transition.hasOutcome(this.actProps);
    }

    public boolean hasScript() {
        return this.transition.hasScript(this.actProps);
    }

    public boolean hasQuery() {
        return this.transition.hasQuery(this.actProps);
    }

    public boolean isOutcomeSet() {
        return this.outcome != null;
    }

    @Override
    public ClusterType getClusterType() {
        return ClusterType.JOB;
    }

    @Override
    public String getClusterPath() {
        return (Object)((Object)this.getClusterType()) + "/" + this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.itemPath == null ? 0 : this.itemPath.hashCode());
        result = 31 * result + (this.stepPath == null ? 0 : this.stepPath.hashCode());
        result = 31 * result + (this.transition == null ? 0 : this.transition.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Job otherJob = (Job)other;
        if (this.itemPath == null) {
            if (otherJob.itemPath != null) {
                return false;
            }
            if (!this.itemPath.equals(otherJob.itemPath)) {
                return false;
            }
        }
        if (this.stepPath == null) {
            if (otherJob.stepPath != null) {
                return false;
            }
            if (!this.stepPath.equals(otherJob.stepPath)) {
                return false;
            }
        }
        if (this.transition == null) {
            if (otherJob.transition != null) {
                return false;
            }
            if (!this.transition.equals(otherJob.transition)) {
                return false;
            }
        }
        return true;
    }

    private void setActPropsAndEvaluateValues(Activity act) throws InvalidDataException {
        this.setActProps(act.getProperties());
        ArrayList<String> errors = new ArrayList<String>();
        for (Map.Entry entry : act.getProperties().entrySet()) {
            try {
                Object newVal = act.evaluatePropertyValue(null, entry.getValue(), null);
                if (newVal == null) continue;
                this.actProps.put(entry.getKey(), newVal);
            }
            catch (InvalidDataException | ObjectNotFoundException | PersistencyException e) {
                log.error("setActPropsAndEvaluateValues() - error evaluating act property '{}:{}'", new Object[]{entry.getKey(), entry.getValue(), e});
                errors.add(e.getMessage());
            }
        }
        if (errors.size() != 0) {
            StringBuffer buffer = new StringBuffer();
            for (String msg : errors) {
                buffer.append(msg);
            }
            throw new InvalidDataException(buffer.toString());
        }
    }

    private void setActProps(CastorHashMap actProps) {
        this.actProps = actProps;
    }

    public Object getActProp(String name) {
        return this.actProps.get(name);
    }

    public Object getActProp(String name, Object defaultValue) {
        Object value = this.getActProp(name);
        return value == null ? defaultValue : value;
    }

    public Object getActProp(BuiltInVertexProperties name) {
        return this.getActProp(name.getName());
    }

    public Object getActProp(BuiltInVertexProperties name, Object defaultValue) {
        return this.getActProp(name.getName(), defaultValue);
    }

    public String getActPropString(String name) {
        Object obj = this.getActProp(name);
        return obj == null ? null : String.valueOf(obj);
    }

    public void setActProp(BuiltInVertexProperties prop, Object value) {
        this.actProps.setBuiltInProperty(prop, value);
    }

    public void setActProp(String name, Object value) {
        this.actProps.put(name, value);
    }

    public String getActPropString(BuiltInVertexProperties name) {
        return this.getActPropString(name.getName());
    }

    public Map<String, Object> matchActPropNames(String pattern) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String propName : this.actProps.keySet()) {
            if (!propName.startsWith(pattern)) continue;
            result.put(propName, this.actProps.get(propName));
        }
        if (result.size() == 0) {
            log.info("Job.matchActPropNames() - NO properties were found for propName.startsWith(pattern:'{}')", (Object)pattern);
            log.trace("matchActPropNames() - actProps:", (Object)this.actProps);
        }
        return result;
    }

    public String toString() {
        String agent = this.agentPath.toString();
        if (Gateway.getLookup() != null) {
            agent = this.agentPath.getAgentName();
        }
        return "[item:" + this.itemPath + " step:" + this.stepName + " trans:" + this.getTransition() + " agent:" + agent + "]";
    }

    public int getId() {
        return this.id;
    }

    public ItemPath getItemPath() {
        return this.itemPath;
    }

    public String getStepName() {
        return this.stepName;
    }

    public String getStepPath() {
        return this.stepPath;
    }

    public String getStepType() {
        return this.stepType;
    }

    public String getOriginStateName() {
        return this.originStateName;
    }

    public String getTargetStateName() {
        return this.targetStateName;
    }

    public String getAgentRole() {
        return this.agentRole;
    }

    public AgentPath getAgentPath() {
        return this.agentPath;
    }

    public AgentPath getDelegatePath() {
        return this.delegatePath;
    }

    public CastorHashMap getActProps() {
        return this.actProps;
    }

    public GTimeStamp getCreationDate() {
        return this.creationDate;
    }

    public ErrorInfo getError() {
        return this.error;
    }

    public boolean isTransitionResolved() {
        return this.transitionResolved;
    }

    public OutcomeAttachment getAttachment() {
        return this.attachment;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setStepName(String stepName) {
        this.stepName = stepName;
    }

    public void setStepPath(String stepPath) {
        this.stepPath = stepPath;
    }

    public void setStepType(String stepType) {
        this.stepType = stepType;
    }

    public void setOriginStateName(String originStateName) {
        this.originStateName = originStateName;
    }

    public void setTargetStateName(String targetStateName) {
        this.targetStateName = targetStateName;
    }

    public void setAgentRole(String agentRole) {
        this.agentRole = agentRole;
    }

    public void setAgentPath(AgentPath agentPath) {
        this.agentPath = agentPath;
    }

    public void setDelegatePath(AgentPath delegatePath) {
        this.delegatePath = delegatePath;
    }

    public void setCreationDate(GTimeStamp creationDate) {
        this.creationDate = creationDate;
    }

    public void setItem(ItemProxy item) {
        this.item = item;
    }

    public void setTransitionResolved(boolean transitionResolved) {
        this.transitionResolved = transitionResolved;
    }

    public void setAttachment(OutcomeAttachment attachment) {
        this.attachment = attachment;
    }
}

