/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.imports;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.collection.Aggregation;
import org.cristalise.kernel.collection.CollectionArrayList;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.TraceableEntity;
import org.cristalise.kernel.entity.imports.ImportAggregation;
import org.cristalise.kernel.entity.imports.ImportDependency;
import org.cristalise.kernel.entity.imports.ImportOutcome;
import org.cristalise.kernel.events.Event;
import org.cristalise.kernel.events.History;
import org.cristalise.kernel.lifecycle.CompositeActivityDef;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.Workflow;
import org.cristalise.kernel.lifecycle.instance.predefined.item.CreateItemFromDescription;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.module.ModuleImport;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyArrayList;
import org.cristalise.kernel.security.BuiltInAuthc;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportItem
extends ModuleImport {
    private static final Logger log = LoggerFactory.getLogger(ImportItem.class);
    protected String initialPath;
    protected String workflow;
    protected Integer workflowVer;
    protected ArrayList<Property> properties = new ArrayList();
    protected ArrayList<ImportAggregation> aggregationList = new ArrayList();
    protected ArrayList<ImportDependency> dependencyList = new ArrayList();
    protected ArrayList<ImportOutcome> outcomes = new ArrayList();
    protected CompositeActivityDef compActDef;
    protected Workflow wf;

    public ImportItem() {
    }

    public ImportItem(String ns, String name, String initialPath, ItemPath itemPath, String wf, int wfVer) {
        this.setNamespace(ns);
        this.setName(name);
        this.setItemPath(itemPath);
        this.setInitialPath(initialPath);
        this.setWorkflow(wf);
        this.setWorkflowVer(wfVer);
        this.compActDef = null;
        wf = null;
    }

    @Override
    public ItemPath getItemPath() {
        DomainPath existingItem;
        if (this.itemPath == null && (existingItem = new DomainPath(this.initialPath + "/" + this.name)).exists()) {
            try {
                this.itemPath = existingItem.getItemPath();
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
        }
        if (this.itemPath == null) {
            this.itemPath = new ItemPath();
        }
        return this.itemPath;
    }

    @Override
    public void setNamespace(String ns) {
        super.setNamespace(ns);
        if (this.initialPath == null) {
            this.initialPath = "/desc/" + ns;
        }
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    private TraceableEntity getTraceableEntitiy() throws ObjectNotFoundException, CannotManageException, ObjectAlreadyExistsException, ObjectCannotBeUpdated {
        TraceableEntity newItem;
        ItemPath ip = this.getItemPath();
        if (ip.exists()) {
            log.info("getTraceableEntitiy() - Verifying module item " + this.domainPath + " at " + ip);
            newItem = Gateway.getCorbaServer().getItem(this.getItemPath());
            this.isNewItem = false;
        } else {
            log.info("getTraceableEntitiy() - Creating module item " + ip + " at " + this.domainPath);
            newItem = Gateway.getCorbaServer().createItem(ip);
            Gateway.getLookupManager().add(ip);
        }
        return newItem;
    }

    @Override
    public Path create(AgentPath agentPath, boolean reset, Object transactionKey) throws InvalidDataException, ObjectCannotBeUpdated, ObjectNotFoundException, CannotManageException, ObjectAlreadyExistsException, InvalidCollectionModification, PersistencyException {
        this.domainPath = new DomainPath(new DomainPath(this.initialPath), this.name);
        log.info("create() - path:{}", (Object)this.domainPath);
        if (this.domainPath.exists()) {
            ItemPath domItem = this.domainPath.getItemPath();
            if (!this.getItemPath().equals(domItem)) {
                throw new CannotManageException("Item " + this.domainPath + " was found with the wrong itemPath (" + this.domainPath.getItemPath() + " vs " + this.getItemPath() + ")");
            }
        } else {
            this.isDOMPathExists = false;
        }
        this.getTraceableEntitiy();
        try {
            CreateItemFromDescription.storeItem(agentPath, this.getItemPath(), this.createItemProperties(), this.createCollections(), this.createCompositeActivity(), null, null, transactionKey);
        }
        catch (Exception ex) {
            log.error("Error initialising new item " + this.ns + "/" + this.name, (Throwable)ex);
            if (this.isNewItem) {
                Gateway.getLookupManager().delete(this.itemPath);
            }
            throw new CannotManageException("Problem initialising new item. See server log:" + ex.getMessage());
        }
        History hist = new History(this.getItemPath(), transactionKey);
        for (ImportOutcome thisOutcome : this.outcomes) {
            Viewpoint impView;
            String outcomeData = thisOutcome.getData(this.ns);
            Schema schema = LocalObjectLoader.getSchema(thisOutcome.schema, thisOutcome.version);
            Outcome newOutcome = new Outcome(-1, outcomeData, schema);
            newOutcome.validateAndCheck();
            try {
                impView = (Viewpoint)Gateway.getStorage().get(this.getItemPath(), (Object)((Object)ClusterType.VIEWPOINT) + "/" + thisOutcome.schema + "/" + thisOutcome.viewname, transactionKey);
                if (newOutcome.isIdentical(impView.getOutcome())) {
                    log.debug("create() - View " + thisOutcome.schema + "/" + thisOutcome.viewname + " in " + this.ns + "/" + this.name + " identical, no update required");
                    continue;
                }
                log.info("create() - Difference found in view " + thisOutcome.schema + "/" + thisOutcome.viewname + " in " + this.ns + "/" + this.name);
                if (!reset && !impView.getEvent().getStepPath().equals("Import")) {
                    log.info("create() - Last edit was not done by import, and reset not requested. Not overwriting.");
                    continue;
                }
            }
            catch (ObjectNotFoundException ex) {
                log.info("create() - View " + thisOutcome.schema + "/" + thisOutcome.viewname + " not found in " + this.ns + "/" + this.name + ". Creating.");
                impView = new Viewpoint(this.getItemPath(), schema, thisOutcome.viewname, -1);
            }
            Event newEvent = hist.addEvent(agentPath, null, BuiltInAuthc.ADMIN_ROLE.getName(), "Import", "Import", "Import", schema, LocalObjectLoader.getStateMachine("PredefinedStep", 0), 0, thisOutcome.viewname);
            newOutcome.setID(newEvent.getID());
            impView.setEventId(newEvent.getID());
            Gateway.getStorage().put(this.getItemPath(), newOutcome, transactionKey);
            Gateway.getStorage().put(this.getItemPath(), impView, transactionKey);
        }
        if (!this.isDOMPathExists) {
            this.domainPath.setItemPath(this.getItemPath());
            Gateway.getLookupManager().add(this.domainPath);
        }
        return this.domainPath;
    }

    protected PropertyArrayList createItemProperties() {
        this.properties.add(new Property(BuiltInItemProperties.NAME, this.name, true));
        this.properties.add(new Property(BuiltInItemProperties.CREATOR, "bootstrap", true));
        return new PropertyArrayList(this.properties);
    }

    protected CompositeActivity createCompositeActivity() throws ObjectNotFoundException, InvalidDataException {
        if (this.wf != null) {
            return (CompositeActivity)this.wf.search("workflow/domain");
        }
        if (this.compActDef == null) {
            if (StringUtils.isNotBlank((CharSequence)this.workflow)) {
                this.compActDef = (CompositeActivityDef)LocalObjectLoader.getActDef(this.workflow, this.workflowVer == null ? 0 : this.workflowVer);
            } else {
                log.warn("createCompositeActivity() - NO Workflow was set for domainPath:" + this.domainPath);
                this.compActDef = (CompositeActivityDef)LocalObjectLoader.getActDef("NoWorkflow", this.workflowVer == null ? 0 : this.workflowVer);
            }
        }
        return (CompositeActivity)this.compActDef.instantiate();
    }

    protected CollectionArrayList createCollections() throws InvalidCollectionModification, ObjectNotFoundException, ObjectAlreadyExistsException {
        CollectionArrayList colls = new CollectionArrayList();
        for (ImportDependency importDependency : this.dependencyList) {
            Dependency newDep = importDependency.create();
            colls.put(newDep);
        }
        for (ImportAggregation importAggregation : this.aggregationList) {
            Aggregation newAgg = importAggregation.create();
            colls.put(newAgg);
        }
        log.info("createCollections() - name:{} number of colls:{}", (Object)this.name, (Object)colls.list.size());
        return colls;
    }

    public String getInitialPath() {
        return this.initialPath;
    }

    public String getWorkflow() {
        return this.workflow;
    }

    public Integer getWorkflowVer() {
        return this.workflowVer;
    }

    public ArrayList<Property> getProperties() {
        return this.properties;
    }

    public ArrayList<ImportAggregation> getAggregationList() {
        return this.aggregationList;
    }

    public ArrayList<ImportDependency> getDependencyList() {
        return this.dependencyList;
    }

    public ArrayList<ImportOutcome> getOutcomes() {
        return this.outcomes;
    }

    public CompositeActivityDef getCompActDef() {
        return this.compActDef;
    }

    public Workflow getWf() {
        return this.wf;
    }

    public void setInitialPath(String initialPath) {
        this.initialPath = initialPath;
    }

    public void setWorkflow(String workflow) {
        this.workflow = workflow;
    }

    public void setWorkflowVer(Integer workflowVer) {
        this.workflowVer = workflowVer;
    }

    public void setProperties(ArrayList<Property> properties) {
        this.properties = properties;
    }

    public void setAggregationList(ArrayList<ImportAggregation> aggregationList) {
        this.aggregationList = aggregationList;
    }

    public void setDependencyList(ArrayList<ImportDependency> dependencyList) {
        this.dependencyList = dependencyList;
    }

    public void setOutcomes(ArrayList<ImportOutcome> outcomes) {
        this.outcomes = outcomes;
    }

    public void setCompActDef(CompositeActivityDef compActDef) {
        this.compActDef = compActDef;
    }

    public void setWf(Workflow wf) {
        this.wf = wf;
    }
}

