/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.imports;

import java.util.ArrayList;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.module.ModuleImport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportRole
extends ModuleImport {
    private static final Logger log = LoggerFactory.getLogger(ImportRole.class);
    public Boolean jobList;
    public ArrayList<String> permissions = new ArrayList();

    @Override
    public Path create(AgentPath agentPath, boolean reset, Object transactionKey) throws ObjectAlreadyExistsException, ObjectCannotBeUpdated, CannotManageException, ObjectNotFoundException {
        RolePath newRolePath = new RolePath(this.name.split("/"), this.jobList == null ? false : this.jobList, this.permissions);
        if (Gateway.getLookup().exists(newRolePath)) {
            if (this.jobList != null) {
                this.update(agentPath);
            }
        } else {
            log.info("ImportRole.create() - Creating Role:" + this.name + " joblist:" + this.jobList);
            newRolePath.getParent();
            Gateway.getLookupManager().createRole(newRolePath);
            Gateway.getLookupManager().setPermissions(newRolePath, newRolePath.getPermissionsList());
        }
        return newRolePath;
    }

    public void update(AgentPath agentPath) throws ObjectAlreadyExistsException, ObjectCannotBeUpdated, CannotManageException, ObjectNotFoundException {
        RolePath rolePath = new RolePath(this.name.split("/"), this.jobList == null ? false : this.jobList, this.permissions);
        if (!Gateway.getLookup().exists(rolePath)) {
            throw new ObjectNotFoundException("Role '" + rolePath.getName() + "' does NOT exists.");
        }
        Gateway.getLookupManager().setHasJobList(rolePath, this.jobList == null ? false : this.jobList);
        Gateway.getLookupManager().setPermissions(rolePath, rolePath.getPermissionsList());
    }

    public static ImportRole getImportRole(RolePath rp) {
        ImportRole ir = new ImportRole();
        ir.setName(rp.getName());
        ir.jobList = rp.hasJobList();
        ir.permissions = (ArrayList)rp.getPermissionsList();
        return ir;
    }
}

