/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.util.Arrays;
import org.cristalise.kernel.collection.Collection;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.process.Gateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateNewCollectionVersion
extends PredefinedStep {
    private static final Logger log = LoggerFactory.getLogger(CreateNewCollectionVersion.class);

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, Object locker) throws InvalidDataException, PersistencyException, ObjectNotFoundException {
        int newVersion;
        Object[] params = CreateNewCollectionVersion.getDataList(requestData);
        log.debug("Called by {} on {} with parameters {}", new Object[]{agent.getAgentName(), item, params});
        if (params.length == 0 || params.length > 2) {
            throw new InvalidDataException("CreateNewCollectionVersion: Invalid parameters " + Arrays.toString(params));
        }
        String collName = params[0];
        Collection coll = (Collection)Gateway.getStorage().get(item, (Object)((Object)ClusterType.COLLECTION) + "/" + collName + "/last", locker);
        if (params.length > 1) {
            newVersion = Integer.valueOf((String)params[1]);
        } else {
            String[] versions = Gateway.getStorage().getClusterContents(item, (Object)((Object)ClusterType.COLLECTION) + "/" + collName);
            int lastVer = -1;
            for (String thisVerStr : versions) {
                try {
                    int thisVer = Integer.parseInt(thisVerStr);
                    if (thisVer <= lastVer) continue;
                    lastVer = thisVer;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            newVersion = lastVer + 1;
        }
        Gateway.getStorage().clearCache(item, (Object)((Object)ClusterType.COLLECTION) + "/" + collName + "/last");
        coll.setVersion(newVersion);
        Gateway.getStorage().put(item, coll, locker);
        return requestData;
    }
}

