/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.AccessRightsException;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.InvalidTransitionException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.events.History;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.instance.Activity;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStepContainer;
import org.cristalise.kernel.lifecycle.instance.predefined.agent.AgentPredefinedStepContainer;
import org.cristalise.kernel.lifecycle.instance.predefined.item.ItemPredefinedStepContainer;
import org.cristalise.kernel.lifecycle.instance.predefined.server.ServerPredefinedStepContainer;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.security.BuiltInAuthc;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public abstract class PredefinedStep
extends Activity {
    private static final Logger log = LoggerFactory.getLogger(PredefinedStep.class);
    private boolean isPredefined = false;
    public static final int DONE = 0;
    public static final int AVAILABLE = 0;

    public PredefinedStep() {
        this.setBuiltInProperty(BuiltInVertexProperties.STATE_MACHINE_NAME, "PredefinedStep");
        this.setBuiltInProperty(BuiltInVertexProperties.SCHEMA_NAME, "PredefinedStepOutcome");
        this.setBuiltInProperty(BuiltInVertexProperties.SCHEMA_VERSION, "0");
        this.addAdminAgentRole();
    }

    @Override
    public boolean getActive() {
        if (this.isPredefined) {
            return true;
        }
        return super.getActive();
    }

    @Override
    public String getErrors() {
        if (this.isPredefined) {
            return this.getName();
        }
        return super.getErrors();
    }

    @Override
    public boolean verify() {
        if (this.isPredefined) {
            return true;
        }
        return super.verify();
    }

    public boolean getIsPredefined() {
        return this.isPredefined;
    }

    public void setIsPredefined(boolean isPredefined) {
        this.isPredefined = isPredefined;
    }

    @Override
    public String getType() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    public static String getPredefStepSchemaName(String stepName) {
        Activity step = PredefinedStep.getStepInstance(stepName);
        if (step != null) {
            return (String)step.getBuiltInProperty(BuiltInVertexProperties.SCHEMA_NAME);
        }
        return "PredefinedStepOutcome";
    }

    public static Activity getStepInstance(String stepName) {
        PredefinedStepContainer[] allSteps;
        for (PredefinedStepContainer thisContainer : allSteps = new PredefinedStepContainer[]{new ItemPredefinedStepContainer(), new AgentPredefinedStepContainer(), new ServerPredefinedStepContainer()}) {
            String stepPath = thisContainer.getName() + "/" + stepName;
            Activity step = (Activity)thisContainer.search(stepPath);
            if (step == null) continue;
            return step;
        }
        return null;
    }

    @Override
    protected abstract String runActivityLogic(AgentPath var1, ItemPath var2, int var3, String var4, Object var5) throws InvalidDataException, InvalidCollectionModification, ObjectAlreadyExistsException, ObjectCannotBeUpdated, ObjectNotFoundException, PersistencyException, CannotManageException, AccessRightsException;

    public static String bundleData(String ... data) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document dom = builder.newDocument();
            Element root = dom.createElement("PredefinedStepOutcome");
            dom.appendChild(root);
            for (String element : data) {
                Element param = dom.createElement("param");
                Text t = dom.createTextNode(element);
                param.appendChild(t);
                root.appendChild(param);
            }
            return Outcome.serialize(dom, false);
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
            StringBuffer xmlData = new StringBuffer().append("<PredefinedStepOutcome>");
            for (String element : data) {
                xmlData.append("<param><![CDATA[").append(element).append("]]></param>");
            }
            xmlData.append("</PredefinedStepOutcome>");
            return xmlData.toString();
        }
    }

    public static String bundleData(String data) {
        return PredefinedStep.bundleData(new String[]{data});
    }

    public static String[] getDataList(String xmlData) {
        try {
            Document scriptDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(xmlData)));
            NodeList nodeList = scriptDoc.getElementsByTagName("param");
            String[] result = new String[nodeList.getLength()];
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node n = nodeList.item(i).getFirstChild();
                if (n instanceof CDATASection) {
                    result[i] = ((CDATASection)n).getData();
                    continue;
                }
                if (!(n instanceof Text)) continue;
                result[i] = ((Text)n).getData();
            }
            return result;
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
            return null;
        }
    }

    protected void addAdminAgentRole() {
        if (Gateway.getProperties().getBoolean("PredefinedStep.AgentRole.enableAdmin", false)) {
            String extraRoles = Gateway.getProperties().getString("PredefinedStep." + this.getClass().getSimpleName() + ".roles");
            this.getProperties().setBuiltInProperty(BuiltInVertexProperties.AGENT_ROLE, (Object)(BuiltInAuthc.ADMIN_ROLE.getName() + (StringUtils.isNotBlank((CharSequence)extraRoles) ? "," + extraRoles : "")));
        }
    }

    public static void storeOutcomeEventAndViews(ItemPath itemPath, Outcome newOutcome, Object transactionKey) throws PersistencyException, ObjectNotFoundException, InvalidDataException {
        PredefinedStep.storeOutcomeEventAndViews(itemPath, newOutcome, null, transactionKey);
    }

    public static void storeOutcomeEventAndViews(ItemPath itemPath, Outcome newOutcome, Integer version, Object transactionKey) throws PersistencyException, ObjectNotFoundException, InvalidDataException {
        String viewName = "";
        if (version != null) {
            viewName = String.valueOf(version);
        }
        log.info("storeOutcomeEventAndViews() - Schema '{}' of version '{}' to '{}'", new Object[]{newOutcome.getSchema().getName(), version != null ? viewName : "last", itemPath});
        History hist = new History(itemPath, null);
        int eventID = hist.addEvent((AgentPath)BuiltInAuthc.SYSTEM_AGENT.getPath(), null, BuiltInAuthc.ADMIN_ROLE.getName(), "Bootstrap", "Bootstrap", "Bootstrap", newOutcome.getSchema(), LocalObjectLoader.getStateMachine("PredefinedStep", 0), 0, version != null ? viewName : "last").getID();
        newOutcome.setID(eventID);
        Viewpoint newLastView = new Viewpoint(itemPath, newOutcome.getSchema(), "last", eventID);
        Gateway.getStorage().put(itemPath, newOutcome, transactionKey);
        Gateway.getStorage().put(itemPath, newLastView, transactionKey);
        if (version != null) {
            Viewpoint newNumberView = new Viewpoint(itemPath, newOutcome.getSchema(), viewName, eventID);
            Gateway.getStorage().put(itemPath, newNumberView, transactionKey);
        }
    }

    public String request(AgentPath agent, ItemPath itemPath, String requestData, Object transactionKey) throws AccessRightsException, InvalidTransitionException, InvalidDataException, ObjectNotFoundException, PersistencyException, ObjectAlreadyExistsException, ObjectCannotBeUpdated, CannotManageException, InvalidCollectionModification {
        log.info("request({}) - Type:{}", (Object)itemPath, (Object)this.getType());
        this.setActive(true);
        return this.request(agent, agent, itemPath, 0, requestData, null, new byte[0], true, transactionKey);
    }
}

