/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.lifecycle.CompositeActivityDef;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.Workflow;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lifecycle.instance.predefined.UpdateImportReport;
import org.cristalise.kernel.lifecycle.instance.predefined.server.ServerPredefinedStepContainer;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.LookupManager;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.process.AbstractMain;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.resource.BuiltInResources;
import org.cristalise.kernel.process.resource.ResourceImportHandler;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.scripting.ScriptConsole;
import org.cristalise.kernel.security.BuiltInAuthc;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bootstrap {
    private static final Logger log = LoggerFactory.getLogger(Bootstrap.class);
    static DomainPath thisServerPath;
    static HashMap<String, AgentProxy> systemAgents;
    public static boolean shutdown;

    static void init() throws Exception {
        Object transactionKey = null;
        Gateway.getStorage().begin(transactionKey);
        try {
            Bootstrap.checkAdminAgents(transactionKey);
            ItemPath serverItem = Bootstrap.createServerItem(transactionKey);
            Bootstrap.storeSystemProperties(serverItem, transactionKey);
            Gateway.getStorage().commit(transactionKey);
        }
        catch (Exception e) {
            Gateway.getStorage().abort(transactionKey);
            throw e;
        }
    }

    static void run() throws Exception {
        Bootstrap.init();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.currentThread().setName("Bootstrapper");
                    log.info("run() - Bootstrapper started");
                    ClassLoader wClassLoader = Bootstrap.class.getClassLoader();
                    log.info("run() setContextClassLoader=[{}]", (Object)wClassLoader);
                    Thread.currentThread().setContextClassLoader(wClassLoader);
                    if (!shutdown) {
                        log.info("run() - Verifying kernel boot data items");
                        Bootstrap.verifyBootDataItems();
                    }
                    if (!shutdown) {
                        Gateway.getModuleManager().setUser(systemAgents.get(BuiltInAuthc.SYSTEM_AGENT.getName()));
                        Gateway.getModuleManager().registerModules();
                    }
                    if (!shutdown) {
                        log.info("run() - Bootstrapper complete");
                        Gateway.getModuleManager().runScripts("initialized");
                        if (Gateway.getLookupManager() != null) {
                            Gateway.getLookupManager().postBoostrap();
                        }
                        Gateway.getStorage().postBoostrap();
                    }
                }
                catch (Throwable e) {
                    log.error("Exception performing bootstrap. Check that everything is OK.", e);
                    AbstractMain.shutdown(1);
                }
            }
        }).start();
    }

    public static void abort() {
        shutdown = true;
    }

    public static void verifyBootDataItems() throws Exception {
        log.info("verifyBootDataItems() - Start checking kernel descriptions ...");
        String bootItems = FileStringUtility.url2String(Gateway.getResource().getKernelResourceURL("boot/allbootitems.txt"));
        Object transactionKey = null;
        Gateway.getStorage().begin(transactionKey);
        try {
            Bootstrap.verifyBootDataItems(bootItems, null, true, transactionKey);
            Gateway.getStorage().commit(transactionKey);
        }
        catch (Exception e) {
            Gateway.getStorage().abort(transactionKey);
            throw e;
        }
        log.info("verifyBootDataItems() - DONE.");
    }

    private static void verifyBootDataItems(String bootList, String ns, boolean reset, Object transactionKey) throws Exception {
        StringTokenizer str = new StringTokenizer(bootList, "\n\r");
        ArrayList<String> kernelChanges = new ArrayList<String>();
        while (str.hasMoreTokens() && !shutdown) {
            String thisItem = str.nextToken();
            String[] idFilename = thisItem.split(",");
            String id = idFilename[0];
            String filename = idFilename[1];
            ItemPath itemPath = new ItemPath(id);
            String[] fileParts = filename.split("/");
            String itemType = fileParts[0];
            String itemName = fileParts[1];
            try {
                String location = "boot/" + filename + (itemType.equals("OD") ? ".xsd" : ".xml");
                ResourceImportHandler importHandler = Gateway.getResourceImportHandler(BuiltInResources.getValue(itemType));
                importHandler.importResource(ns, itemName, 0, itemPath, location, reset, transactionKey);
                kernelChanges.add(importHandler.getResourceChangeDetails());
            }
            catch (Exception e) {
                log.error("Error importing bootstrap items. Unsafe to continue.", (Throwable)e);
                AbstractMain.shutdown(1);
            }
        }
        StringBuffer moduleChangesXML = new StringBuffer("<ModuleChanges>\n");
        moduleChangesXML.append("<ModuleName>kernel</ModuleName>");
        moduleChangesXML.append("<ModuleVersion>0</ModuleVersion>");
        for (String oneChange : kernelChanges) {
            moduleChangesXML.append(oneChange).append("\n");
        }
        moduleChangesXML.append("</ModuleChanges>");
        if (StringUtils.isNotBlank((CharSequence)moduleChangesXML)) {
            new UpdateImportReport().request((AgentPath)BuiltInAuthc.SYSTEM_AGENT.getPath(), thisServerPath.getItemPath(), moduleChangesXML.toString(), transactionKey);
        }
    }

    private static AgentProxy checkAgent(String name, String pass, RolePath rolePath, String uuid, Object transactionKey) throws Exception {
        log.info("checkAgent() - Checking for existence of '" + name + "' agent.");
        LookupManager lookup = Gateway.getLookupManager();
        try {
            AgentProxy agentProxy = Gateway.getProxyManager().getAgentProxy(lookup.getAgentPath(name));
            systemAgents.put(name, agentProxy);
            log.info("checkAgent() - Agent '" + name + "' found.");
            return agentProxy;
        }
        catch (ObjectNotFoundException agentProxy) {
            log.info("checkAgent() - Agent '" + name + "' not found. Creating.");
            try {
                AgentPath agentPath = new AgentPath(new ItemPath(uuid), name);
                Gateway.getCorbaServer().createAgent(agentPath);
                lookup.add(agentPath);
                if (StringUtils.isNotBlank((CharSequence)pass)) {
                    lookup.setAgentPassword(agentPath, pass);
                }
                log.info("checkAgent() - Assigning role '" + rolePath.getName() + "'");
                Gateway.getLookupManager().addRole(agentPath, rolePath);
                Gateway.getStorage().put(agentPath, new Property(BuiltInItemProperties.NAME, name, true), transactionKey);
                Gateway.getStorage().put(agentPath, new Property(BuiltInItemProperties.TYPE, "Agent", false), transactionKey);
                AgentProxy agentProxy2 = Gateway.getProxyManager().getAgentProxy(agentPath);
                systemAgents.put(name, agentProxy2);
                return agentProxy2;
            }
            catch (Exception ex) {
                log.error("Unable to create '" + name + "' Agent.", (Throwable)ex);
                throw ex;
            }
        }
    }

    public static void checkAdminAgents(Object transactionKey) throws Exception {
        RolePath adminRole;
        RolePath rootRole = new RolePath();
        if (!rootRole.exists()) {
            Gateway.getLookupManager().createRole(rootRole);
        }
        if (!(adminRole = new RolePath(rootRole, BuiltInAuthc.ADMIN_ROLE.getName(), false)).exists()) {
            Gateway.getLookupManager().createRole(adminRole);
        }
        Gateway.getLookupManager().setPermission(adminRole, "*");
        AgentProxy system = Bootstrap.checkAgent(BuiltInAuthc.SYSTEM_AGENT.getName(), null, adminRole, new UUID(0L, 1L).toString(), transactionKey);
        ScriptConsole.setUser(system);
        String ucRole = Gateway.getProperties().getString("UserCode.roleOverride", "UserCode");
        String ucPermissions = Gateway.getProperties().getString(ucRole + ".permissions", "");
        RolePath usercodeRole = new RolePath(rootRole, ucRole, true);
        if (!usercodeRole.exists()) {
            Gateway.getLookupManager().createRole(usercodeRole);
        }
        Gateway.getLookupManager().setPermissions(usercodeRole, Arrays.asList(ucPermissions.split(",")));
        Bootstrap.checkAgent(Gateway.getProperties().getString(ucRole + ".agent", InetAddress.getLocalHost().getHostName()), Gateway.getProperties().getString(ucRole + ".password", "uc"), usercodeRole, UUID.randomUUID().toString(), transactionKey);
    }

    private static ItemPath createServerItem(Object transactionKey) throws Exception {
        ItemPath serverItem;
        LookupManager lookupManager = Gateway.getLookupManager();
        String serverName = Gateway.getProperties().getString("ItemServer.name", InetAddress.getLocalHost().getHostName());
        thisServerPath = new DomainPath("/servers/" + serverName);
        try {
            serverItem = thisServerPath.getItemPath();
        }
        catch (ObjectNotFoundException ex) {
            log.info("Creating server item " + thisServerPath);
            serverItem = new ItemPath();
            Gateway.getCorbaServer().createItem(serverItem);
            lookupManager.add(serverItem);
            thisServerPath.setItemPath(serverItem);
            lookupManager.add(thisServerPath);
        }
        int proxyPort = Gateway.getProperties().getInt("ItemServer.Proxy.port", 1553);
        int consolePort = org.cristalise.kernel.utils.Logger.getConsolePort();
        Gateway.getStorage().put(serverItem, new Property(BuiltInItemProperties.NAME, serverName, false), transactionKey);
        Gateway.getStorage().put(serverItem, new Property(BuiltInItemProperties.TYPE, "Server", false), transactionKey);
        Gateway.getStorage().put(serverItem, new Property(BuiltInItemProperties.KERNEL_VERSION, Gateway.getKernelVersion(), true), transactionKey);
        Gateway.getStorage().put(serverItem, new Property("ProxyPort", String.valueOf(proxyPort), false), transactionKey);
        Gateway.getStorage().put(serverItem, new Property("ConsolePort", String.valueOf(consolePort), true), transactionKey);
        Bootstrap.initServerItemWf(transactionKey);
        Gateway.getProxyManager().connectToProxyServer(serverName, proxyPort);
        return serverItem;
    }

    private static void storeSystemProperties(ItemPath serverItem, Object transactionKey) throws Exception {
        Outcome newOutcome = Gateway.getProperties().convertToOutcome("ItemServer");
        PredefinedStep.storeOutcomeEventAndViews(serverItem, newOutcome, transactionKey);
    }

    private static void initServerItemWf(Object transactionKey) throws Exception {
        CompositeActivityDef serverWfCa = (CompositeActivityDef)LocalObjectLoader.getActDef("ServerItemWorkflow", 0);
        Workflow wf = new Workflow((CompositeActivity)serverWfCa.instantiate(), new ServerPredefinedStepContainer());
        wf.initialise(thisServerPath.getItemPath(), systemAgents.get(BuiltInAuthc.SYSTEM_AGENT.getName()).getPath(), null);
        Gateway.getStorage().put(thisServerPath.getItemPath(), wf, transactionKey);
    }

    static {
        systemAgents = new HashMap();
        shutdown = false;
    }
}

