/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.process;

import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.process.AbstractMain;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StandardClient
extends AbstractMain {
    private static final Logger log = LoggerFactory.getLogger(StandardClient.class);
    protected AgentProxy agent = null;

    protected void login(String agentName, String agentPass, String resource) throws InvalidDataException {
        for (int i = 1; i < 6; ++i) {
            try {
                log.info("Login attempt " + i + " of 5");
                this.agent = Gateway.connect(agentName, agentPass, resource);
                break;
            }
            catch (Exception ex) {
                log.error("Could not log in.", (Throwable)ex);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        if (this.agent == null) {
            throw new InvalidDataException("Could not login agent:" + agentName);
        }
    }

    protected static StateMachine getRequiredStateMachine(String propPrefix, String namesSpaceDefault, String bootfileDefault) throws InvalidDataException {
        if (StringUtils.isBlank((CharSequence)propPrefix)) {
            throw new InvalidDataException("propertyPrefix must contain a value");
        }
        String smName = Gateway.getProperties().getString(propPrefix + ".StateMachine.name");
        int smVersion = Gateway.getProperties().getInt(propPrefix + ".StateMachine.version");
        try {
            if (StringUtils.isNotBlank((CharSequence)smName) && smVersion != -1) {
                return LocalObjectLoader.getStateMachine(smName, smVersion);
            }
            log.warn("getRequiredStateMachine() - SM Name and/or Version was not specified, trying to load from bootsrap resource.");
            String stateMachineNS = Gateway.getProperties().getString(propPrefix + ".StateMachine.namespace", namesSpaceDefault);
            String stateMachinePath = Gateway.getProperties().getString(propPrefix + ".StateMachine.bootfile", bootfileDefault);
            return (StateMachine)Gateway.getMarshaller().unmarshall(Gateway.getResource().getTextResource(stateMachineNS, stateMachinePath));
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new InvalidDataException(e.getMessage());
        }
    }
}

