/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.scripting;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import org.cristalise.kernel.entity.proxy.AgentProxy;
import org.cristalise.kernel.process.AbstractMain;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.utils.server.SocketHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptConsole
implements SocketHandler {
    private static final Logger log = LoggerFactory.getLogger(ScriptConsole.class);
    BufferedReader input;
    PrintStream output;
    Socket socket = null;
    ScriptEngine engine;
    Bindings beans;
    static AgentProxy agent;
    static ArrayList<String> securityHosts;
    public static final short NONE = 0;
    public static final short ALLOW = 1;
    public static final short DENY = 2;
    static short securityMode;

    @Override
    public String getName() {
        return "Script Console";
    }

    @Override
    public boolean isBusy() {
        return this.socket != null;
    }

    public static void setUser(AgentProxy a) {
        agent = a;
    }

    @Override
    public void setSocket(Socket newSocket) {
        try {
            this.input = new BufferedReader(new InputStreamReader(newSocket.getInputStream()));
            this.output = new PrintStream(newSocket.getOutputStream());
            newSocket.setSoTimeout(0);
            this.socket = newSocket;
        }
        catch (IOException ex) {
            try {
                newSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
            return;
        }
    }

    @Override
    public void shutdown() {
        Socket closingSocket = this.socket;
        this.socket = null;
        if (closingSocket == null) {
            return;
        }
        try {
            closingSocket.shutdownInput();
            closingSocket.shutdownOutput();
            closingSocket.close();
            log.info("Script console to " + closingSocket.getInetAddress() + " closed");
        }
        catch (IOException e) {
            log.error("Script Console to " + closingSocket.getInetAddress() + " - Error closing.", (Throwable)e);
        }
    }

    @Override
    public void run() {
        boolean allowed = true;
        if (securityMode != 0) {
            String wHostAddress = this.socket.getInetAddress().getHostAddress();
            if (securityHosts.contains(wHostAddress)) {
                if (securityMode == 2) {
                    allowed = false;
                }
            } else if (securityMode == 1) {
                allowed = false;
            }
        }
        if (!allowed) {
            log.error("Host " + this.socket.getInetAddress() + " access denied");
            this.output.println("Host " + this.socket.getInetAddress() + " access denied");
            this.shutdown();
            return;
        }
        try {
            Script context;
            try {
                String lang = Gateway.getProperties().getString("ItemServer.Console.language", "javascript");
                context = new Script(lang, agent, this.output);
            }
            catch (Exception ex) {
                this.output.println("Error initializing console script context");
                ex.printStackTrace(this.output);
                this.shutdown();
                return;
            }
            StringBuffer commandBuffer = new StringBuffer();
            while (this.socket != null) {
                this.output.println();
                this.output.print('>');
                String command = null;
                boolean gotCommand = false;
                while (!gotCommand) {
                    try {
                        command = this.input.readLine();
                        gotCommand = true;
                    }
                    catch (InterruptedIOException interruptedIOException) {}
                }
                if (command == null) {
                    this.shutdown();
                    continue;
                }
                if (command.equals("exit")) {
                    this.shutdown();
                    continue;
                }
                try {
                    if (command.endsWith("\\")) {
                        commandBuffer.append(command.substring(0, command.length() - 1));
                        continue;
                    }
                    commandBuffer.append(command);
                    command = commandBuffer.toString();
                    commandBuffer = new StringBuffer();
                    log.info("Console command from " + this.socket.getInetAddress() + ": " + command);
                    if (command.equals("shutdown")) {
                        AbstractMain.shutdown(0);
                    } else {
                        context.setScriptData(command);
                        Object response = context.execute();
                        if (response == null) {
                            this.output.println("Ok");
                        } else {
                            this.output.println(response);
                        }
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace(this.output);
                }
                this.output.flush();
            }
        }
        catch (IOException ex) {
            log.error("IO Exception reading from script console socket");
            this.shutdown();
        }
    }

    static {
        securityHosts = new ArrayList();
        securityMode = 1;
        String hosts = Gateway.getProperties().getString("ItemServer.Console.allow");
        if (hosts == null || hosts.equals("")) {
            securityMode = (short)2;
            hosts = Gateway.getProperties().getString("ItemServer.Console.deny");
        }
        if (hosts == null || hosts.equals("")) {
            securityMode = 1;
            securityHosts.add("localhost");
            securityHosts.add("127.0.0.1");
            securityHosts.add("0:0:0:0:0:0:0:1");
        } else {
            StringTokenizer tok = new StringTokenizer(hosts, ",");
            while (tok.hasMoreTokens()) {
                String wHostName = tok.nextToken();
                try {
                    securityHosts.add(InetAddress.getByName(wHostName).getHostAddress());
                    if (!"localhost".equals(wHostName)) continue;
                    securityHosts.add("127.0.0.1");
                    securityHosts.add("0:0:0:0:0:0:0:1");
                }
                catch (UnknownHostException ex) {
                    log.error("Host not found ", (Throwable)ex);
                }
            }
        }
    }
}

