/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.persistency.outcome;

import java.io.IOException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.OutcomeValidator;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class SchemaValidator
extends OutcomeValidator {
    private static final Logger log = LoggerFactory.getLogger(SchemaValidator.class);

    @Override
    public synchronized String validate(String outcome) {
        Schema schema = new Schema(outcome);
        try {
            return schema.validate();
        }
        catch (IOException e) {
            return "Error reading schema";
        }
    }

    @Override
    public synchronized String validate(Document outcome) {
        try {
            return this.validate(Outcome.serialize(outcome, false));
        }
        catch (InvalidDataException e) {
            log.error("Could not validate Outcome", (Throwable)e);
            return null;
        }
    }
}

