/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.graph.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.graph.model.DirectedEdge;
import org.cristalise.kernel.graph.model.GraphPoint;
import org.cristalise.kernel.graph.renderer.DirectedEdgeRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDirectedEdgeRenderer
implements DirectedEdgeRenderer {
    private static final Logger log = LoggerFactory.getLogger(DefaultDirectedEdgeRenderer.class);
    public static final Paint LINE_PAINT = Color.BLACK;
    public static final Paint TEXT_PAINT = Color.BLACK;
    public static final Paint ERROR_PAINT = Color.RED;
    private GeneralPath mArrowTemplate = new GeneralPath();

    public DefaultDirectedEdgeRenderer() {
        this.mArrowTemplate.moveTo(-5.0f, 5.0f);
        this.mArrowTemplate.lineTo(0.0f, 0.0f);
        this.mArrowTemplate.lineTo(5.0f, 5.0f);
    }

    @Override
    public void draw(Graphics2D g2d, DirectedEdge directedEdge) {
        g2d.setPaint(LINE_PAINT);
        this.drawStraightWithArrow(g2d, directedEdge);
    }

    public void draw(Graphics2D g2d, DirectedEdge directedEdge, String label, String type, boolean hasError) {
        g2d.setPaint(hasError ? ERROR_PAINT : LINE_PAINT);
        switch (EdgeRouting.getValue(type)) {
            case STRAIGHT: {
                this.drawStraightWithArrow(g2d, directedEdge);
                break;
            }
            case BROKEN_PLUS: {
                this.drawBrokenPlusWithArrow(g2d, directedEdge);
                break;
            }
            case BROKEN_MINUS: {
                this.drawBrokenMinusWithArrow(g2d, directedEdge);
                break;
            }
            case BROKEN_PIPE: {
                this.drawBrokenPipeWithArrow(g2d, directedEdge);
                break;
            }
            default: {
                log.warn("draw() - unknow edge type:{} - drawing straight line", (Object)type);
                this.drawStraightWithArrow(g2d, directedEdge);
            }
        }
        GraphPoint originPoint = directedEdge.getOriginPoint();
        GraphPoint terminusPoint = directedEdge.getTerminusPoint();
        GraphPoint midPoint = new GraphPoint();
        midPoint.x = (originPoint.x + terminusPoint.x) / 2;
        midPoint.y = (originPoint.y + terminusPoint.y) / 2;
        if (StringUtils.isNotBlank((CharSequence)label)) {
            g2d.drawString(label, midPoint.x + 10, midPoint.y);
        }
    }

    private void drawBrokenPlusWithArrow(Graphics2D g2d, DirectedEdge directedEdge) {
        GraphPoint originPoint = directedEdge.getOriginPoint();
        GraphPoint terminusPoint = directedEdge.getTerminusPoint();
        g2d.drawLine(originPoint.x, originPoint.y, originPoint.x, (originPoint.y + terminusPoint.y) / 2);
        g2d.drawLine(originPoint.x, (originPoint.y + terminusPoint.y) / 2, terminusPoint.x, (originPoint.y + terminusPoint.y) / 2);
        g2d.drawLine(terminusPoint.x, (originPoint.y + terminusPoint.y) / 2, terminusPoint.x, terminusPoint.y);
        GraphPoint midPoint = new GraphPoint();
        midPoint.x = (originPoint.x + terminusPoint.x) / 2;
        midPoint.y = (originPoint.y + terminusPoint.y) / 2;
        AffineTransform transform = new AffineTransform();
        transform.translate(midPoint.x, midPoint.y);
        transform.rotate(DefaultDirectedEdgeRenderer.calcArrowAngle(originPoint.x, originPoint.x - terminusPoint.x > -5 && originPoint.x - terminusPoint.x < 5 ? originPoint.y : (originPoint.y + terminusPoint.y) / 2, terminusPoint.x, originPoint.x - terminusPoint.x > -5 && originPoint.x - terminusPoint.x < 5 ? terminusPoint.y : (originPoint.y + terminusPoint.y) / 2));
        g2d.draw(this.mArrowTemplate.createTransformedShape(transform));
    }

    private void drawBrokenMinusWithArrow(Graphics2D g2d, DirectedEdge directedEdge) {
        GraphPoint originPoint = directedEdge.getOriginPoint();
        GraphPoint terminusPoint = directedEdge.getTerminusPoint();
        g2d.drawLine(originPoint.x, originPoint.y, terminusPoint.x, originPoint.y);
        g2d.drawLine(terminusPoint.x, originPoint.y, terminusPoint.x, terminusPoint.y);
        boolean arrowOnY = originPoint.y - terminusPoint.y >= 60 || originPoint.y - terminusPoint.y <= -60;
        GraphPoint midPoint = new GraphPoint();
        midPoint.x = arrowOnY ? terminusPoint.x : (originPoint.x + terminusPoint.x) / 2;
        midPoint.y = arrowOnY ? (originPoint.y + terminusPoint.y) / 2 : originPoint.y;
        AffineTransform transform = new AffineTransform();
        transform.translate(midPoint.x, midPoint.y);
        transform.rotate(DefaultDirectedEdgeRenderer.calcArrowAngle(arrowOnY ? terminusPoint.x : originPoint.x, arrowOnY ? originPoint.y : originPoint.y, arrowOnY ? terminusPoint.x : terminusPoint.x, arrowOnY ? terminusPoint.y : originPoint.y));
        g2d.draw(this.mArrowTemplate.createTransformedShape(transform));
    }

    private void drawBrokenPipeWithArrow(Graphics2D g2d, DirectedEdge directedEdge) {
        GraphPoint originPoint = directedEdge.getOriginPoint();
        GraphPoint terminusPoint = directedEdge.getTerminusPoint();
        g2d.drawLine(originPoint.x, originPoint.y, originPoint.x, terminusPoint.y);
        g2d.drawLine(originPoint.x, terminusPoint.y, terminusPoint.x, terminusPoint.y);
        boolean arrowOnY = originPoint.y - terminusPoint.y >= 60 || originPoint.y - terminusPoint.y <= -60;
        GraphPoint midPoint = new GraphPoint();
        midPoint.x = arrowOnY ? originPoint.x : (originPoint.x + terminusPoint.x) / 2;
        midPoint.y = arrowOnY ? (originPoint.y + terminusPoint.y) / 2 : terminusPoint.y;
        AffineTransform transform = new AffineTransform();
        transform.translate(midPoint.x, midPoint.y);
        transform.rotate(DefaultDirectedEdgeRenderer.calcArrowAngle(arrowOnY ? terminusPoint.x : originPoint.x, arrowOnY ? originPoint.y : originPoint.y, arrowOnY ? terminusPoint.x : terminusPoint.x, arrowOnY ? terminusPoint.y : originPoint.y));
        g2d.draw(this.mArrowTemplate.createTransformedShape(transform));
    }

    private void drawStraightWithArrow(Graphics2D g2d, DirectedEdge directedEdge) {
        GraphPoint originPoint = directedEdge.getOriginPoint();
        GraphPoint terminusPoint = directedEdge.getTerminusPoint();
        g2d.drawLine(originPoint.x, originPoint.y, terminusPoint.x, terminusPoint.y);
        GraphPoint midPoint = new GraphPoint();
        midPoint.x = originPoint.x + (terminusPoint.x - originPoint.x) / 2;
        midPoint.y = originPoint.y + (terminusPoint.y - originPoint.y) / 2;
        AffineTransform transform = new AffineTransform();
        transform.translate(midPoint.x, midPoint.y);
        transform.rotate(DefaultDirectedEdgeRenderer.calcArrowAngle(originPoint.x, originPoint.y, terminusPoint.x, terminusPoint.y));
        g2d.draw(this.mArrowTemplate.createTransformedShape(transform));
    }

    private static double calcArrowAngle(int originX, int originY, int terminusX, int terminusY) {
        double width = terminusX - originX;
        double height = terminusY - originY;
        if (width == 0.0 && height > 0.0) {
            return Math.PI;
        }
        if (width == 0.0 && height < 0.0) {
            return 0.0;
        }
        if (width > 0.0 && height == 0.0) {
            return 1.5707963267948966;
        }
        if (width < 0.0 && height == 0.0) {
            return -1.5707963267948966;
        }
        if (width > 0.0 && height > 0.0) {
            return 1.5707963267948966 + Math.atan(Math.abs(height) / Math.abs(width));
        }
        if (width > 0.0 && height < 0.0) {
            return Math.atan(Math.abs(width) / Math.abs(height));
        }
        if (width < 0.0 && height < 0.0) {
            return -1.0 * Math.atan(Math.abs(width) / Math.abs(height));
        }
        if (width < 0.0 && height > 0.0) {
            return -1.0 * (1.5707963267948966 + Math.atan(Math.abs(height) / Math.abs(width)));
        }
        return 0.0;
    }

    public static enum EdgeRouting {
        STRAIGHT("Straight"),
        BROKEN_PLUS("Broken +"),
        BROKEN_MINUS("Broken -"),
        BROKEN_PIPE("Broken |");

        private String routingName;

        private EdgeRouting(String n2) {
            this.routingName = n2;
        }

        public String getName() {
            return this.routingName;
        }

        public String toString() {
            return this.getName();
        }

        public static EdgeRouting getValue(String name) {
            if (StringUtils.isBlank((CharSequence)name)) {
                return STRAIGHT;
            }
            for (EdgeRouting routing : EdgeRouting.values()) {
                if (!routing.getName().equals(name) && !routing.name().equals(name)) continue;
                return routing;
            }
            return null;
        }
    }
}

