/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance;

import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.graph.model.GraphableVertex;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.Next;
import org.cristalise.kernel.lifecycle.instance.Workflow;
import org.cristalise.kernel.lifecycle.routingHelpers.DataHelperUtility;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.scripting.Script;
import org.cristalise.kernel.scripting.ScriptingEngineException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WfVertex
extends GraphableVertex {
    private static final Logger log = LoggerFactory.getLogger(WfVertex.class);

    public abstract void runFirst(AgentPath var1, ItemPath var2, TransactionKey var3) throws InvalidDataException;

    public WfVertex() {
        this.setIsLayoutable(true);
        this.setIsComposite(false);
    }

    public abstract void runNext(AgentPath var1, ItemPath var2, TransactionKey var3) throws InvalidDataException;

    public abstract void reinit(int var1) throws InvalidDataException;

    public void abort() {
    }

    public abstract boolean verify();

    public abstract String getErrors();

    public abstract void run(AgentPath var1, ItemPath var2, TransactionKey var3) throws InvalidDataException;

    public abstract boolean loop();

    public String getActContext() {
        return this.getPath().substring(0, this.getPath().lastIndexOf(47));
    }

    public abstract Next addNext(WfVertex var1);

    public Object evaluateProperty(ItemPath itemPath, String propName, TransactionKey transactionKey) throws InvalidDataException, PersistencyException, ObjectNotFoundException {
        return this.evaluatePropertyValue(itemPath, this.getProperties().get(propName), transactionKey);
    }

    public Object evaluatePropertyValue(ItemPath itemPath, Object propValue, TransactionKey transactionKey) throws InvalidDataException, PersistencyException, ObjectNotFoundException {
        if (itemPath == null) {
            itemPath = this.getWf().getItemPath();
        }
        return DataHelperUtility.evaluateValue(itemPath, propValue, this.getActContext(), transactionKey);
    }

    protected Object evaluateScript(String scriptName, Integer scriptVersion, ItemPath itemPath, TransactionKey transactionKey) throws ScriptingEngineException {
        try {
            if (itemPath == null) {
                itemPath = this.getWf().getItemPath();
            }
            Script script = Script.getScript(scriptName, scriptVersion);
            return script.evaluate(itemPath, this.getProperties(), this.getActContext(), transactionKey);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new ScriptingEngineException(e.getMessage());
        }
    }

    public Workflow getWf() {
        return ((CompositeActivity)this.getParent()).getWf();
    }

    protected GraphableVertex findPair(String pairingID) {
        if (StringUtils.isBlank((CharSequence)pairingID)) {
            return null;
        }
        for (GraphableVertex vertex : this.getParent().getLayoutableChildren()) {
            if (!pairingID.equals(vertex.getBuiltInProperty(BuiltInVertexProperties.PAIRING_ID)) || vertex.equals(this)) continue;
            return vertex;
        }
        return null;
    }

    protected Boolean isMyPair(WfVertex otherVertex) {
        String loopPairingID = (String)this.getBuiltInProperty(BuiltInVertexProperties.PAIRING_ID);
        if (StringUtils.isNotBlank((CharSequence)loopPairingID)) {
            return loopPairingID.equals(this.getOtherPairingID(otherVertex));
        }
        return null;
    }

    protected String getOtherPairingID(WfVertex otherVertex) {
        if (otherVertex.getProperties().containsKey(BuiltInVertexProperties.PAIRING_ID.getName())) {
            return (String)otherVertex.getBuiltInProperty(BuiltInVertexProperties.PAIRING_ID);
        }
        return "";
    }

    public static enum Types {
        Atomic,
        Composite,
        OrSplit,
        XOrSplit,
        AndSplit,
        LoopSplit,
        Join,
        Route;

    }
}

