/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined.server;

import java.util.Arrays;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.LookupManager;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveRole
extends PredefinedStep {
    private static final Logger log = LoggerFactory.getLogger(RemoveRole.class);

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, TransactionKey transactionKey) throws InvalidDataException, CannotManageException, ObjectNotFoundException, ObjectCannotBeUpdated {
        Object[] params = RemoveRole.getDataList(requestData);
        log.debug("Called by {} on {} with parameters {}", new Object[]{agent.getAgentName(transactionKey), item, params});
        if (params.length != 1) {
            throw new InvalidDataException("RemoveRole must have one paramater:" + Arrays.toString(params));
        }
        LookupManager lookup = Gateway.getLookupManager();
        RolePath thisRole = lookup.getRolePath(params[0], transactionKey);
        AgentPath[] agents = Gateway.getLookup().getAgents(thisRole, transactionKey);
        if (agents.length > 0) {
            throw new ObjectCannotBeUpdated("Cannot remove role as " + agents.length + " other agents still hold it.");
        }
        lookup.delete(thisRole, transactionKey);
        return requestData;
    }
}

