/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.imports;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.imports.ImportRole;
import org.cristalise.kernel.lifecycle.instance.CompositeActivity;
import org.cristalise.kernel.lifecycle.instance.predefined.item.CreateItemFromDescription;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.lookup.RolePath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.module.ModuleImport;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyArrayList;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportAgent
extends ModuleImport {
    private static final Logger log = LoggerFactory.getLogger(ImportAgent.class);
    private String initialPath;
    private String password;
    private ArrayList<Property> properties = new ArrayList();
    private ArrayList<ImportRole> roles = new ArrayList();

    public ImportAgent() {
    }

    public ImportAgent(String folder, String aName, String pwd) {
        this.initialPath = folder;
        this.name = aName;
        this.password = pwd;
    }

    public ImportAgent(String aName, String pwd) {
        this(null, aName, pwd);
    }

    @Override
    public void setID(String uuid) throws InvalidItemPathException {
        if (StringUtils.isNotBlank((CharSequence)uuid)) {
            this.itemPath = new AgentPath(new ItemPath(uuid), this.name);
        }
    }

    @Override
    public Path create(AgentPath agentPath, boolean reset, TransactionKey transactionKey) throws ObjectNotFoundException, ObjectCannotBeUpdated, CannotManageException, ObjectAlreadyExistsException {
        if (this.roles.isEmpty()) {
            throw new ObjectNotFoundException("Agent '" + this.name + "' must declare at least one Role ");
        }
        if (StringUtils.isNotBlank((CharSequence)this.initialPath)) {
            this.domainPath = new DomainPath(new DomainPath(this.initialPath), this.name);
            if (this.domainPath.exists(transactionKey)) {
                ItemPath domItem = this.domainPath.getItemPath(transactionKey);
                if (!this.getItemPath(transactionKey).equals(domItem)) {
                    throw new CannotManageException("'" + this.domainPath + "' was found with the different itemPath (" + this.domainPath.getItemPath(transactionKey) + " vs " + this.getItemPath(transactionKey) + ")");
                }
            } else {
                this.isDOMPathExists = false;
            }
        }
        AgentPath newAgent = new AgentPath(this.getItemPath(transactionKey), this.name);
        Gateway.getCorbaServer().createAgent(newAgent, transactionKey);
        Gateway.getLookupManager().add(newAgent, transactionKey);
        this.properties.add(new Property(BuiltInItemProperties.NAME, this.name, true));
        this.properties.add(new Property(BuiltInItemProperties.TYPE, "Agent", false));
        try {
            if (StringUtils.isNotBlank((CharSequence)this.password)) {
                Gateway.getLookupManager().setAgentPassword(newAgent, this.password, false, transactionKey);
            }
            CreateItemFromDescription.storeItem(agentPath, this.getItemPath(transactionKey), new PropertyArrayList(this.properties), null, (CompositeActivity)LocalObjectLoader.getCompActDef("NoWorkflow", 0, transactionKey).instantiate(transactionKey), null, null, transactionKey);
        }
        catch (Exception ex) {
            log.error("Error initialising new agent name:{}", (Object)this.name, (Object)ex);
            Gateway.getLookupManager().delete(newAgent, transactionKey);
            throw new CannotManageException("Error initialising new agent name:" + this.name);
        }
        for (ImportRole role : this.roles) {
            RolePath thisRole = (RolePath)role.create(agentPath, reset, transactionKey);
            Gateway.getLookupManager().addRole(newAgent, thisRole, transactionKey);
        }
        if (this.domainPath != null && !this.isDOMPathExists) {
            this.domainPath.setItemPath(this.getItemPath(transactionKey));
            Gateway.getLookupManager().add(this.domainPath, transactionKey);
        }
        return newAgent;
    }

    @Override
    public ItemPath getItemPath() {
        return this.getItemPath(null);
    }

    @Override
    public ItemPath getItemPath(TransactionKey transactionKey) {
        if (this.itemPath == null) {
            try {
                this.itemPath = Gateway.getLookup().getAgentPath(this.name, transactionKey);
            }
            catch (ObjectNotFoundException ex) {
                this.itemPath = new AgentPath(new ItemPath(), this.name);
            }
        }
        return this.itemPath;
    }

    public void addRoles(List<RolePath> newRoles) {
        for (RolePath rp : newRoles) {
            this.roles.add(ImportRole.getImportRole(rp));
        }
    }

    public String getInitialPath() {
        return this.initialPath;
    }

    public String getPassword() {
        return this.password;
    }

    public ArrayList<Property> getProperties() {
        return this.properties;
    }

    public ArrayList<ImportRole> getRoles() {
        return this.roles;
    }

    public void setInitialPath(String initialPath) {
        this.initialPath = initialPath;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setProperties(ArrayList<Property> properties) {
        this.properties = properties;
    }

    public void setRoles(ArrayList<ImportRole> roles) {
        this.roles = roles;
    }
}

