/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance;

import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.graph.model.BuiltInEdgeProperties;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.graph.traversal.GraphTraversal;
import org.cristalise.kernel.lifecycle.instance.Loop;
import org.cristalise.kernel.lifecycle.instance.Next;
import org.cristalise.kernel.lifecycle.instance.WfVertex;
import org.cristalise.kernel.lifecycle.routingHelpers.DataHelperUtility;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.scripting.ScriptingEngineException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Split
extends WfVertex {
    private static final Logger log = LoggerFactory.getLogger(Split.class);
    public Vector<String> mErrors = new Vector(0, 1);
    private boolean loopTested;

    public Split() {
        this.setBuiltInProperty(BuiltInVertexProperties.ROUTING_SCRIPT_NAME, "");
        this.setBuiltInProperty(BuiltInVertexProperties.ROUTING_SCRIPT_VERSION, "");
        this.setBuiltInProperty(BuiltInVertexProperties.ROUTING_EXPR, "");
    }

    @Override
    public abstract void runNext(AgentPath var1, ItemPath var2, TransactionKey var3) throws InvalidDataException;

    void addNext(String idNext) {
        new Next(this, (WfVertex)this.getParent().search(idNext));
    }

    @Override
    public Next addNext(WfVertex vertex) {
        Next nxt = new Next(this, vertex);
        int num = this.getOutGraphables().length;
        try {
            num = Integer.parseInt((String)this.getBuiltInProperty(BuiltInVertexProperties.LAST_NUM));
        }
        catch (Exception e) {
            log.debug("addNext() - Exception:" + e.getMessage());
        }
        nxt.setBuiltInProperty(BuiltInEdgeProperties.ALIAS, String.valueOf(num));
        this.setBuiltInProperty(BuiltInVertexProperties.LAST_NUM, String.valueOf(num + 1));
        return nxt;
    }

    @Override
    public void reinit(int idLoop) throws InvalidDataException {
        Vertex[] outVertices;
        log.debug("reinit(id:{}, idLoop:{}) - parent:{}", new Object[]{this.getID(), idLoop, this.getParent().getName()});
        for (Vertex outVertice : outVertices = this.getOutGraphables()) {
            ((WfVertex)outVertice).reinit(idLoop);
        }
    }

    @Override
    public boolean verify() {
        this.mErrors.removeAllElements();
        int nbInEdgres = this.getParent().getChildrenGraphModel().getInEdges(this).length;
        if (nbInEdgres == 0 && this.getID() != this.getParent().getChildrenGraphModel().getStartVertexId()) {
            this.mErrors.add("not enough previous");
            return false;
        }
        if (nbInEdgres > 1) {
            this.mErrors.add("Bad nb of previous");
            return false;
        }
        if (this.getOutEdges().length <= 1 && !(this instanceof Loop)) {
            this.mErrors.add("not enough next");
            return false;
        }
        if (!(this instanceof Loop)) {
            Vertex[] outV = this.getOutGraphables();
            Vertex[] anteVertices = GraphTraversal.getTraversal(this.getParent().getChildrenGraphModel(), this, 1, false);
            boolean loop = false;
            boolean errInLoop = true;
            for (int i = 0; i < outV.length; ++i) {
                for (int j = 0; j < anteVertices.length; ++j) {
                    if (loop || outV[i].getID() != anteVertices[j].getID()) continue;
                    if (outV[i] instanceof Loop) {
                        loop = true;
                        j = anteVertices.length;
                        i = outV.length;
                        continue;
                    }
                    errInLoop = false;
                }
            }
            if (errInLoop && loop) {
                this.mErrors.add("Problem in Loop");
                return false;
            }
        }
        return true;
    }

    @Override
    public String getErrors() {
        if (this.mErrors.size() == 0) {
            return "No error";
        }
        return this.mErrors.elementAt(0);
    }

    @Override
    public void run(AgentPath agent, ItemPath itemPath, TransactionKey transactionKey) throws InvalidDataException {
        this.runNext(agent, itemPath, transactionKey);
    }

    @Override
    public boolean loop() {
        boolean loop2 = false;
        if (!this.loopTested) {
            this.loopTested = true;
            if (this.getOutGraphables().length != 0) {
                Vertex[] outVertices = this.getOutGraphables();
                for (int i = 0; i < outVertices.length; ++i) {
                    WfVertex tmp = (WfVertex)this.getOutGraphables()[i];
                    loop2 = loop2 || tmp.loop();
                }
            }
        }
        this.loopTested = false;
        return loop2;
    }

    private String[] getRoutingReturnValue(Object value) throws InvalidDataException {
        String stringValue;
        if (value == null) {
            return new String[0];
        }
        if (value instanceof String) {
            stringValue = (String)value;
        } else {
            if (Gateway.getProperties().getBoolean("RoutingScript.enforceStringReturnValue", false)) {
                throw new InvalidDataException("Routing script or expression must return String");
            }
            stringValue = value.toString();
        }
        return stringValue.split(",");
    }

    protected String[] calculateNexts(ItemPath itemPath, TransactionKey transactionKey) throws InvalidDataException {
        String expr = (String)this.getBuiltInProperty(BuiltInVertexProperties.ROUTING_EXPR);
        String scriptName = (String)this.getBuiltInProperty(BuiltInVertexProperties.ROUTING_SCRIPT_NAME);
        Integer scriptVersion = this.deriveVersionNumber(this.getBuiltInProperty(BuiltInVertexProperties.ROUTING_SCRIPT_VERSION));
        if (StringUtils.isNotBlank((CharSequence)expr)) {
            try {
                Object returnValue = DataHelperUtility.evaluateValue(itemPath, expr, this.getActContext(), transactionKey);
                return this.getRoutingReturnValue(returnValue);
            }
            catch (ObjectNotFoundException | PersistencyException e) {
                log.error("", e);
                throw new InvalidDataException("Routing expression evaluation failed: " + expr + " with " + e.getMessage());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)scriptName)) {
            try {
                Object returnValue = this.evaluateScript(scriptName, scriptVersion, itemPath, transactionKey);
                return this.getRoutingReturnValue(returnValue);
            }
            catch (ScriptingEngineException e) {
                String msg = "Error running Routing script " + scriptName + " v" + scriptVersion;
                log.error(msg, (Throwable)e);
                throw new InvalidDataException(msg + " error:" + e.getMessage());
            }
        }
        throw new InvalidDataException("Split is invalid without valid Routing script or expression");
    }

    public String[] nextNames() {
        Vertex[] vs = this.getOutGraphables();
        String[] result = new String[vs.length];
        for (int i = 0; i < vs.length; ++i) {
            result[i] = vs[i].getName();
        }
        return result;
    }

    protected boolean isInTable(String test, String[] list) {
        if (test == null) {
            return false;
        }
        for (String element : list) {
            for (String value : test.split("\\|")) {
                if (!value.equals(element)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void runFirst(AgentPath agent, ItemPath itemPath, TransactionKey transactionKey) throws InvalidDataException {
        this.runNext(agent, itemPath, transactionKey);
    }
}

