/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.instance.predefined.server;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.CannotManageException;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectCannotBeUpdated;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.graph.model.BuiltInVertexProperties;
import org.cristalise.kernel.lifecycle.instance.predefined.PredefinedStep;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.persistency.outcome.Outcome;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.cristalise.kernel.utils.LocalObjectLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigureLogback
extends PredefinedStep {
    private static final Logger log = LoggerFactory.getLogger(ConfigureLogback.class);
    public static final String description = "Updates the log levels for Root level and for the named Loggers";
    private static final String LOGBACK_CLASSIC = "ch.qos.logback.classic";
    private static final String LOGBACK_CLASSIC_LOGGER = "ch.qos.logback.classic.Logger";
    private static final String LOGBACK_CLASSIC_LEVEL = "ch.qos.logback.classic.Level";

    public ConfigureLogback() {
        this.setBuiltInProperty(BuiltInVertexProperties.SCHEMA_NAME, "LoggerConfig");
    }

    @Override
    protected String runActivityLogic(AgentPath agent, ItemPath item, int transitionID, String requestData, TransactionKey transactionKey) throws InvalidDataException, ObjectCannotBeUpdated, ObjectNotFoundException, CannotManageException, ObjectAlreadyExistsException, InvalidCollectionModification {
        Schema schema = LocalObjectLoader.getSchema((String)this.getBuiltInProperty(BuiltInVertexProperties.SCHEMA_NAME), Integer.parseInt((String)this.getBuiltInProperty(BuiltInVertexProperties.SCHEMA_VERSION)), transactionKey);
        Outcome config = new Outcome(requestData, schema);
        config.validateAndCheck();
        try {
            if (config.hasField("Root")) {
                ConfigureLogback.setLogLevel(null, config.getField("Root"));
            }
            for (Map<String, String> record : config.getAllRecords("//Logger")) {
                ConfigureLogback.setLogLevel(record.get("Name"), record.get("Level"));
            }
        }
        catch (ReflectiveOperationException | XPathExpressionException | InvalidDataException e) {
            log.warn("Could not configure logback", e);
            log.debug("requestData: {}", (Object)requestData);
        }
        return requestData;
    }

    public static boolean setLogLevel(String loggerName, String logLevel) throws InvalidDataException, ReflectiveOperationException {
        Logger loggerObtained;
        Package logbackPackage = Package.getPackage(LOGBACK_CLASSIC);
        if (logbackPackage == null) {
            throw new InvalidDataException("Logback is not in the classpath!");
        }
        if (StringUtils.isBlank((CharSequence)loggerName)) {
            loggerName = (String)ConfigureLogback.getFieldVaulue(LOGBACK_CLASSIC_LOGGER, "ROOT_LOGGER_NAME");
        }
        if ((loggerObtained = LoggerFactory.getLogger((String)loggerName)) == null) {
            log.warn("No logger found for the name: {}", (Object)loggerName);
            return false;
        }
        Object logLevelObj = ConfigureLogback.getFieldVaulue(LOGBACK_CLASSIC_LEVEL, logLevel);
        if (logLevelObj == null) {
            log.warn("No such log level: {}", (Object)logLevel);
            return false;
        }
        Class[] paramTypes = new Class[]{logLevelObj.getClass()};
        Object[] params = new Object[]{logLevelObj};
        Class<?> clazz = Class.forName(LOGBACK_CLASSIC_LOGGER);
        Method method = clazz.getMethod("setLevel", paramTypes);
        method.invoke((Object)loggerObtained, params);
        log.debug("Log level set to '{}' for the logger '{}'", (Object)logLevel, (Object)loggerName);
        return true;
    }

    private static Object getFieldVaulue(String fullClassName, String fieldName) {
        try {
            Class<?> clazz = Class.forName(fullClassName);
            Field field = clazz.getField(fieldName);
            return field.get(null);
        }
        catch (ReflectiveOperationException ignored) {
            return null;
        }
    }
}

