/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.lifecycle.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.util.ArrayList;
import org.cristalise.kernel.graph.model.Vertex;
import org.cristalise.kernel.graph.renderer.DefaultVertexRenderer;
import org.cristalise.kernel.lifecycle.ActivitySlotDef;
import org.cristalise.kernel.lifecycle.WfVertexDef;

public class ActivityDefRenderer
extends DefaultVertexRenderer {
    private Paint mInactivePaint = Color.WHITE;
    private Paint mErrorPaint = new Color(255, 50, 0);
    private Paint mCompositePaint = new Color(200, 200, 255);
    private Paint mTextPaint = Color.black;

    @Override
    public void draw(Graphics2D g2d, Vertex vertex) {
        boolean hasError;
        WfVertexDef activityDef = (WfVertexDef)vertex;
        boolean bl = hasError = !activityDef.verify();
        Paint fillPaint = hasError ? this.mErrorPaint : (activityDef.getIsComposite() ? this.mCompositePaint : this.mInactivePaint);
        this.drawOutline3DRect(g2d, vertex, fillPaint);
        ArrayList<String> linesOfText = new ArrayList<String>();
        if (activityDef instanceof ActivitySlotDef) {
            try {
                linesOfText.add((String)activityDef.getProperties().get("Name"));
                linesOfText.add("(" + ((ActivitySlotDef)activityDef).getTheActivityDef(null).getActName() + ")");
            }
            catch (Exception e) {
                linesOfText.add("(Not found)");
            }
        } else {
            linesOfText.add(activityDef.getName());
        }
        if (hasError) {
            linesOfText.add(activityDef.getErrors());
        }
        this.drawLinesOfTexts(g2d, activityDef, linesOfText, this.mTextPaint);
    }
}

