/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.persistency;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.C2KLocalObject;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.entity.proxy.MemberSubscription;
import org.cristalise.kernel.entity.proxy.ProxyObserver;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterStorageManager;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.process.Gateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteMap<V extends C2KLocalObject>
extends TreeMap<String, V>
implements C2KLocalObject {
    private static final Logger log = LoggerFactory.getLogger(RemoteMap.class);
    private static final long serialVersionUID = -2356840109407419763L;
    private int mID = -1;
    private String mName;
    protected ItemPath mItemPath;
    private String mPath = "";
    Object keyLock = null;
    ClusterStorageManager storage;
    Comparator<String> comp;
    ItemProxy source;
    ProxyObserver<V> listener;
    TransactionKey mTransactionKey;

    public RemoteMap(ItemPath itemPath, String path, TransactionKey transactionKey) {
        super(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Integer i1 = null;
                Integer i2 = null;
                try {
                    i1 = Integer.valueOf(o1);
                    i2 = Integer.valueOf(o2);
                    return i1.compareTo(i2);
                }
                catch (NumberFormatException numberFormatException) {
                    return o1.compareTo(o2);
                }
            }
        });
        this.mItemPath = itemPath;
        this.mTransactionKey = transactionKey;
        int lastSlash = path.lastIndexOf("/");
        this.mName = path.substring(lastSlash + 1);
        if (lastSlash > 0) {
            this.mPath = path.substring(0, lastSlash);
        }
        try {
            this.mID = Integer.parseInt(this.mName);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.storage = Gateway.getStorage();
    }

    public void activate() {
        if (this.listener != null) {
            log.debug("activate() - ALREADY active name:{}", (Object)this.mItemPath);
            return;
        }
        this.listener = new ProxyObserver<V>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void add(V obj) {
                2 var2_2 = this;
                synchronized (var2_2) {
                    log.debug("ProxyObserver.add() - id:" + obj.getName());
                    RemoteMap.this.putLocal(obj.getName(), obj);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove(String id) {
                2 var2_2 = this;
                synchronized (var2_2) {
                    log.debug("ProxyObserver.remove() - id:" + id);
                    RemoteMap.this.removeLocal(id);
                }
            }

            @Override
            public void control(String control, String msg) {
            }
        };
        try {
            this.source = Gateway.getProxyManager().getProxy(this.mItemPath, this.mTransactionKey);
            this.source.subscribe(new MemberSubscription<V>(this.listener, this.mPath + this.mName, false));
            log.debug("activate() - name:" + this.mName + " " + this.mItemPath);
        }
        catch (Exception ex) {
            log.error("Error subscribing to remote map. Changes will NOT be received", (Throwable)ex);
        }
    }

    public void deactivate() {
        if (this.source != null) {
            this.source.unsubscribe(this.listener);
        }
    }

    public void finalize() {
        this.deactivate();
        Gateway.getStorage().clearCache(this.mItemPath, this.mPath + this.mName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadKeys() {
        if (this.keyLock != null) {
            return;
        }
        this.clear();
        this.keyLock = new Object();
        RemoteMap remoteMap = this;
        synchronized (remoteMap) {
            try {
                String[] keys;
                for (String key : keys = this.storage.getClusterContents(this.mItemPath, this.mPath + this.mName)) {
                    super.put(key, null);
                }
            }
            catch (PersistencyException e) {
                log.error("Error loading keys", (Throwable)e);
            }
        }
    }

    public synchronized int getLastId() {
        try {
            return this.storage.getLastIntegerId(this.mItemPath, this.mPath + this.mName, this.mTransactionKey);
        }
        catch (PersistencyException ex) {
            log.error("Failed to get last integer id for path:{}", (Object)("/" + this.mItemPath + "/" + this.mPath + this.mName), (Object)ex);
            return -1;
        }
    }

    public void setID(int id) {
        this.mID = id;
    }

    public int getID() {
        return this.mID;
    }

    @Override
    public void setName(String name) {
        this.mName = name;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public ClusterType getClusterType() {
        return null;
    }

    @Override
    public String getClusterPath() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void clear() {
        RemoteMap remoteMap = this;
        synchronized (remoteMap) {
            super.clear();
        }
        this.keyLock = null;
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        if (this.keyLock == null) {
            this.loadKeys();
        }
        return super.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean containsValue(Object value) {
        this.loadKeys();
        RemoteMap remoteMap = this;
        synchronized (remoteMap) {
            for (String key : this.keySet()) {
                if (!this.get(key).equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized V get(Object objKey) {
        String key;
        if (objKey instanceof Integer) {
            key = ((Integer)objKey).toString();
        } else if (objKey instanceof String) {
            key = (String)objKey;
        } else {
            return null;
        }
        RemoteMap remoteMap = this;
        synchronized (remoteMap) {
            try {
                C2KLocalObject value = this.storage.get(this.mItemPath, this.mPath + this.mName + "/" + key, this.mTransactionKey);
                super.put(key, value);
                return (V)value;
            }
            catch (ObjectNotFoundException | PersistencyException e) {
                log.error("get()", e);
                throw new IllegalArgumentException(e);
            }
        }
    }

    @Override
    public synchronized boolean isEmpty() {
        this.loadKeys();
        return super.isEmpty();
    }

    @Override
    public synchronized Set<String> keySet() {
        this.loadKeys();
        return super.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized V put(String key, V value) {
        if (this.source != null) {
            throw new UnsupportedOperationException("Cannot use an activated RemoteMap to write to storage.");
        }
        try {
            RemoteMap remoteMap = this;
            synchronized (remoteMap) {
                this.storage.put(this.mItemPath, (C2KLocalObject)value, this.mTransactionKey);
                return this.putLocal(key, value);
            }
        }
        catch (PersistencyException e) {
            log.error("put()", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    protected synchronized V putLocal(String key, V value) {
        return (V)((C2KLocalObject)super.put(key, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized V remove(Object key) {
        if (this.source != null) {
            throw new UnsupportedOperationException("Cannot use an activated RemoteMap to write to storage.");
        }
        try {
            Object object = this.keyLock;
            synchronized (object) {
                this.storage.remove(this.mItemPath, this.mPath + this.mName + "/" + key, this.mTransactionKey);
                return this.removeLocal(key);
            }
        }
        catch (PersistencyException e) {
            log.error("remove()", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    protected synchronized V removeLocal(Object key) {
        return (V)((C2KLocalObject)super.remove(key));
    }

    @Override
    public synchronized int size() {
        this.loadKeys();
        return super.size();
    }

    @Override
    public synchronized Collection<V> values() {
        return new RemoteSet(this);
    }

    private class RemoteIterator<C extends C2KLocalObject>
    implements Iterator<C> {
        RemoteMap<C> mParent;
        Iterator<String> iter;
        String currentKey;

        public RemoteIterator(RemoteMap<C> parent) {
            this.mParent = parent;
            this.iter = this.mParent.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public C next() {
            this.currentKey = this.iter.next();
            return (C)this.mParent.get(this.currentKey);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class RemoteSet<E extends C2KLocalObject>
    extends AbstractSet<E> {
        RemoteMap<E> mParent;

        public RemoteSet(RemoteMap<E> parent) {
            this.mParent = parent;
        }

        @Override
        public boolean add(E o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<E> iterator() {
            return new RemoteIterator<E>(this.mParent);
        }

        @Override
        public int size() {
            return this.mParent.size();
        }
    }
}

