/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.common.PersistencyException;
import org.cristalise.kernel.entity.proxy.ItemProxy;
import org.cristalise.kernel.entity.proxy.MemberSubscription;
import org.cristalise.kernel.entity.proxy.ProxyObserver;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.lookup.Lookup;
import org.cristalise.kernel.lookup.Path;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.persistency.outcome.Viewpoint;
import org.cristalise.kernel.process.Gateway;
import org.cristalise.kernel.process.module.Module;
import org.cristalise.kernel.process.module.ModuleResource;
import org.cristalise.kernel.property.BuiltInItemProperties;
import org.cristalise.kernel.property.Property;
import org.cristalise.kernel.property.PropertyDescription;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.utils.DescriptionObject;
import org.cristalise.kernel.utils.FileStringUtility;
import org.cristalise.kernel.utils.SoftCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DescriptionObjectCache<D extends DescriptionObject> {
    private static final Logger log = LoggerFactory.getLogger(DescriptionObjectCache.class);
    SoftCache<String, CacheEntry<D>> cache = new SoftCache();
    Property[] classIdProps;

    public DescriptionObjectCache() {
        try {
            String propDescXML = Gateway.getResource().findTextResource("boot/property/" + this.getTypeCode() + "Prop.xml");
            PropertyDescriptionList propDescs = (PropertyDescriptionList)Gateway.getMarshaller().unmarshall(propDescXML);
            ArrayList<Property> classIdPropList = new ArrayList<Property>();
            for (PropertyDescription propDesc : propDescs.list) {
                if (!propDesc.getIsClassIdentifier()) continue;
                classIdPropList.add(propDesc.getProperty());
            }
            this.classIdProps = classIdPropList.toArray(new Property[classIdPropList.size()]);
        }
        catch (Exception ex) {
            log.error("Could not load property description for " + this.getTypeCode() + ". Cannot filter.", (Throwable)ex);
            this.classIdProps = new Property[0];
        }
    }

    public D loadObjectFromBootstrap(String name) throws InvalidDataException, ObjectNotFoundException {
        try {
            log.trace("loadObjectFromBootstrap() - name:" + name + " Loading it from kernel items");
            String bootItems = FileStringUtility.url2String(Gateway.getResource().getKernelResourceURL("boot/allbootitems.txt"));
            StringTokenizer str = new StringTokenizer(bootItems, "\n\r");
            while (str.hasMoreTokens()) {
                String resLine = str.nextToken();
                String[] resElem = resLine.split(",");
                if (!resElem[0].equals(name) && !this.isBootResource(resElem[1], name)) continue;
                log.trace("loadObjectFromBootstrap() - Shimming " + this.getTypeCode() + " " + name + " from bootstrap");
                String resData = Gateway.getResource().getTextResource(null, "boot/" + resElem[1] + (resElem[1].startsWith("OD") ? ".xsd" : ".xml"));
                return this.buildObject(name, 0, new ItemPath(resElem[0]), resData);
            }
            for (Module module : Gateway.getModuleManager().getModules()) {
                log.trace("loadObjectFromBootstrap() - name:" + name + " Lodaing it from module:" + module.getName());
                ModuleResource res = (ModuleResource)module.getImports().findImport(name);
                if (res == null) continue;
                res.setNs(module.getNs());
                String resData = Gateway.getResource().getTextResource(module.getNs(), res.getResourceLocation());
                String uuid = res.getID() == null ? UUID.randomUUID().toString() : res.getID();
                return this.buildObject(name, 0, new ItemPath(uuid), resData);
            }
        }
        catch (Exception e) {
            log.error("Error finding bootstrap resources", (Throwable)e);
            throw new InvalidDataException("Error finding bootstrap resources");
        }
        throw new ObjectNotFoundException("Resource " + this.getSchemaName() + " " + name + " not found in bootstrap resources");
    }

    protected boolean isBootResource(String filename, String resName) {
        return filename.equals(this.getTypeCode() + "/" + resName);
    }

    protected ItemPath findItem(String name, TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException {
        DomainPath directPath;
        if (Gateway.getLookup() == null) {
            throw new ObjectNotFoundException("Cannot find Items without a Lookup");
        }
        if (ItemPath.isUUID(name)) {
            try {
                ItemPath resItem = new ItemPath(name);
                if (resItem.exists(transactionKey)) {
                    return resItem;
                }
            }
            catch (InvalidItemPathException resItem) {
                // empty catch block
            }
        }
        if ((directPath = new DomainPath(name)).exists(transactionKey) && directPath.getItemPath(transactionKey) != null) {
            return directPath.getItemPath(transactionKey);
        }
        Iterator<Path> searchResult = null;
        if (Gateway.getProperties().getBoolean("LocalObjectLoader.lookupUseProperties", false) || StringUtils.isBlank((CharSequence)this.getTypeRoot())) {
            Property[] searchProps = new Property[this.classIdProps.length + 1];
            searchProps[0] = new Property(BuiltInItemProperties.NAME, name);
            System.arraycopy(this.classIdProps, 0, searchProps, 1, this.classIdProps.length);
            searchResult = Gateway.getLookup().search((Path)new DomainPath(this.getTypeRoot()), transactionKey, searchProps);
        } else {
            searchResult = Gateway.getLookup().search((Path)new DomainPath(this.getTypeRoot()), name, Lookup.SearchConstraints.EXACT_NAME_MATCH, transactionKey);
        }
        if (searchResult.hasNext()) {
            Path defPath = searchResult.next();
            if (searchResult.hasNext()) {
                throw new InvalidDataException("Too many matches for name:" + name + " typeCode:" + this.getTypeCode());
            }
            if (defPath.getItemPath(transactionKey) == null) {
                throw new InvalidDataException("name:" + name + " typeCode:" + this.getTypeCode() + " was found, but was not an Item");
            }
            return defPath.getItemPath(transactionKey);
        }
        throw new ObjectNotFoundException("No match for name:" + name + " typeCode:" + this.getTypeCode());
    }

    public D get(String name, int version) throws ObjectNotFoundException, InvalidDataException {
        return this.get(name, version, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public D get(String name, int version, TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException {
        try {
            String itemName;
            CacheEntry<D> thisDefEntry = null;
            SoftCache<String, CacheEntry<D>> softCache = this.cache;
            synchronized (softCache) {
                thisDefEntry = this.cache.get(name + "_" + version);
            }
            if (thisDefEntry != null) {
                log.trace("get() - key:{}_{} found in cache.", (Object)name, (Object)version);
                return (D)thisDefEntry.def;
            }
            ItemPath defItemPath = this.findItem(name, transactionKey);
            String defUuid = defItemPath.getUUID().toString();
            SoftCache<String, CacheEntry<D>> softCache2 = this.cache;
            synchronized (softCache2) {
                log.trace("get() - key:{}_{} not found in cache. Checking key using uuid:{}", new Object[]{name, version, defUuid});
                thisDefEntry = this.cache.get(defUuid + "_" + version);
                if (thisDefEntry != null) {
                    log.trace("get() - key:{}_{} found in cache.", (Object)defUuid, (Object)version);
                    return (D)thisDefEntry.def;
                }
            }
            log.trace("get() - key:{}_{} not found in cache. Loading from database.", (Object)name, (Object)version);
            ItemProxy defItemProxy = Gateway.getProxyManager().getProxy(defItemPath, transactionKey);
            if (name.equals(defUuid) && (itemName = defItemProxy.getName(transactionKey)) != null) {
                name = itemName;
            }
            D thisDef = this.loadObject(name, version, defItemProxy, transactionKey);
            this.addToCache(name, version, defUuid, defItemProxy, thisDef);
            return thisDef;
        }
        catch (ObjectNotFoundException ex) {
            log.trace("get - failed to load resource key:{}_{} from database, loading from classpath.", (Object)name, (Object)version);
            if (version == 0) {
                try {
                    return this.loadObjectFromBootstrap(name);
                }
                catch (ObjectNotFoundException ex2) {
                    log.error("get() - ", (Throwable)ex2);
                }
            } else {
                log.error("get() - only resources with version zero can be loaded from classpath - name:{} version:{}", (Object)name, (Object)version);
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToCache(String name, int version, String defUuid, ItemProxy defItemProxy, D thisDef) {
        log.trace("addToCache() - key1:{}_{} and key2:{}_{}", new Object[]{name, version, defUuid, version});
        CacheEntry entry = new CacheEntry(this, thisDef, defItemProxy, this);
        SoftCache<String, CacheEntry<D>> softCache = this.cache;
        synchronized (softCache) {
            this.cache.put(defUuid + "_" + version, entry);
            this.cache.put(name + "_" + version, entry);
        }
    }

    public abstract String getTypeCode();

    public abstract String getSchemaName();

    public abstract String getTypeRoot();

    public abstract D buildObject(String var1, int var2, ItemPath var3, String var4) throws InvalidDataException;

    public D loadObject(String name, int version, ItemProxy proxy, TransactionKey transactionKey) throws ObjectNotFoundException, InvalidDataException {
        Viewpoint smView = proxy.getViewpoint(this.getSchemaName(), String.valueOf(version), transactionKey);
        try {
            String rawRes = smView.getOutcome(transactionKey).getData();
            return this.buildObject(name, version, proxy.getPath(), rawRes);
        }
        catch (PersistencyException ex) {
            log.error("Problem loading " + this.getSchemaName() + " " + name + " v" + version, (Throwable)ex);
            throw new ObjectNotFoundException("Problem loading " + this.getSchemaName() + " " + name + " v" + version + ": " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObject(String id, String idName) {
        SoftCache<String, CacheEntry<D>> softCache = this.cache;
        synchronized (softCache) {
            if (this.cache.keySet().contains(id) || this.cache.keySet().contains(idName)) {
                log.debug("remove() - key:{} and key:{}", (Object)id, (Object)idName);
                this.cache.remove(id);
                this.cache.remove(idName);
            }
        }
    }

    public static class CacheEntry<E extends DescriptionObject>
    implements ProxyObserver<Viewpoint> {
        public String id;
        public String idName;
        public ItemProxy proxy;
        public E def;
        public DescriptionObjectCache<E> parent;
        final /* synthetic */ DescriptionObjectCache this$0;

        public CacheEntry(E def, ItemProxy proxy, DescriptionObjectCache<E> parent) {
            this.this$0 = this$0;
            this.id = def.getItemID() + "_" + def.getVersion();
            this.idName = def.getName() + "_" + def.getVersion();
            this.def = def;
            this.parent = parent;
            this.proxy = proxy;
            proxy.subscribe(new MemberSubscription<Viewpoint>(this, ClusterType.VIEWPOINT.getName(), false));
        }

        public void finalize() {
            this.parent.removeObject(this.id, this.idName);
            this.proxy.unsubscribe(this);
        }

        @Override
        public void add(Viewpoint contents) {
            this.parent.removeObject(this.id, this.idName);
        }

        @Override
        public void remove(String oldId) {
            this.parent.removeObject(this.id, this.idName);
        }

        public String toString() {
            return "Cache entry: " + this.id;
        }

        @Override
        public void control(String control, String msg) {
        }
    }
}

