/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.entity.imports;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.cristalise.kernel.collection.BuiltInCollections;
import org.cristalise.kernel.collection.Dependency;
import org.cristalise.kernel.collection.DependencyDescription;
import org.cristalise.kernel.collection.DependencyMember;
import org.cristalise.kernel.common.InvalidCollectionModification;
import org.cristalise.kernel.common.ObjectAlreadyExistsException;
import org.cristalise.kernel.common.ObjectNotFoundException;
import org.cristalise.kernel.entity.imports.ImportDependencyMember;
import org.cristalise.kernel.lookup.DomainPath;
import org.cristalise.kernel.lookup.InvalidItemPathException;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.property.PropertyDescription;
import org.cristalise.kernel.property.PropertyDescriptionList;
import org.cristalise.kernel.property.PropertyUtility;
import org.cristalise.kernel.utils.CastorHashMap;
import org.cristalise.kernel.utils.KeyValuePair;

public class ImportDependency {
    public String name;
    public Integer version;
    public boolean isDescription;
    public String itemDescriptionPath;
    public String itemDescriptionVersion = null;
    public ArrayList<ImportDependencyMember> dependencyMemberList = new ArrayList();
    public CastorHashMap props = new CastorHashMap();
    public String classProps = "";

    public ImportDependency() {
    }

    public ImportDependency(BuiltInCollections collection) {
        this(collection.getName());
    }

    public ImportDependency(String name) {
        this();
        this.name = name;
    }

    public KeyValuePair[] getKeyValuePairs() {
        return this.props.getKeyValuePairs();
    }

    public void setKeyValuePairs(KeyValuePair[] pairs) {
        this.props.setKeyValuePairs(pairs);
    }

    public Dependency create(TransactionKey transactionKey) throws InvalidCollectionModification, ObjectNotFoundException, ObjectAlreadyExistsException {
        Dependency newDep;
        Dependency dependency = newDep = this.isDescription ? new DependencyDescription(this.name) : new Dependency(this.name);
        if (this.version != null) {
            newDep.setVersion(this.version);
        }
        if (StringUtils.isNotBlank((CharSequence)this.classProps)) {
            newDep.setClassProps(this.classProps);
        }
        if (StringUtils.isNotBlank((CharSequence)this.itemDescriptionPath)) {
            ItemPath itemPath;
            try {
                itemPath = new ItemPath(this.itemDescriptionPath);
            }
            catch (InvalidItemPathException ex) {
                itemPath = new DomainPath(this.itemDescriptionPath).getItemPath(transactionKey);
            }
            String descVer = this.itemDescriptionVersion == null ? "last" : this.itemDescriptionVersion;
            PropertyDescriptionList propDescList = PropertyUtility.getPropertyDescriptionOutcome(itemPath, descVer, transactionKey);
            StringBuffer descClassProps = new StringBuffer();
            for (PropertyDescription pd : propDescList.list) {
                this.props.put(pd.getName(), pd.getDefaultValue());
                if (!pd.getIsClassIdentifier()) continue;
                descClassProps.append(descClassProps.length() > 0 ? "," : "").append(pd.getName());
            }
            if (StringUtils.isBlank((CharSequence)this.classProps)) {
                newDep.setClassProps(descClassProps.toString());
            } else {
                newDep.setClassProps(this.classProps + "," + descClassProps.toString());
            }
        }
        newDep.setProperties(this.props);
        for (ImportDependencyMember thisMem : this.dependencyMemberList) {
            ItemPath itemPath;
            try {
                itemPath = new ItemPath(thisMem.itemPath);
            }
            catch (InvalidItemPathException ex) {
                itemPath = new DomainPath(thisMem.itemPath).getItemPath(transactionKey);
            }
            DependencyMember newDepMem = newDep.addMember(itemPath, transactionKey);
            newDepMem.getProperties().putAll(thisMem.props);
        }
        return newDep;
    }
}

