/*
 * Decompiled with CFR 0.152.
 */
package org.cristalise.kernel.events;

import org.cristalise.kernel.common.InvalidDataException;
import org.cristalise.kernel.events.Event;
import org.cristalise.kernel.lifecycle.instance.stateMachine.StateMachine;
import org.cristalise.kernel.lookup.AgentPath;
import org.cristalise.kernel.lookup.ItemPath;
import org.cristalise.kernel.persistency.ClusterType;
import org.cristalise.kernel.persistency.RemoteMap;
import org.cristalise.kernel.persistency.TransactionKey;
import org.cristalise.kernel.persistency.outcome.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class History
extends RemoteMap<Event> {
    private static final Logger log = LoggerFactory.getLogger(History.class);
    private static final long serialVersionUID = 3273324106002587993L;

    public History(ItemPath itemPath, TransactionKey transactionKey) {
        super(itemPath, ClusterType.HISTORY.getName(), transactionKey);
    }

    public Event getEvent(int id) {
        return (Event)this.get(String.valueOf(id));
    }

    public Event get(Integer id) {
        return (Event)this.get(String.valueOf(id));
    }

    @Override
    public Event remove(Object key) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Event storeNewEvent(Event newEvent) {
        History history = this;
        synchronized (history) {
            newEvent.setID(this.getLastId() + 1);
            this.put(newEvent.getName(), newEvent);
            return newEvent;
        }
    }

    public Event addEvent(AgentPath agentPath, AgentPath delegatePath, String agentRole, String stepName, String stepPath, String stepType, StateMachine stateMachine, int transitionId) {
        return this.storeNewEvent(new Event(this.mItemPath, agentPath, delegatePath, agentRole, stepName, stepPath, stepType, stateMachine, transitionId));
    }

    public Event addEvent(AgentPath agentPath, AgentPath delegatePath, String agentRole, String stepName, String stepPath, String stepType, Schema schema, StateMachine stateMachine, int transitionId, String viewName) {
        Event newEvent = new Event(this.mItemPath, agentPath, delegatePath, agentRole, stepName, stepPath, stepType, stateMachine, transitionId);
        newEvent.addOutcomeDetails(schema, viewName);
        return this.storeNewEvent(newEvent);
    }

    public Event addEvent(AgentPath agentPath, AgentPath delegatePath, String agentRole, String stepName, String stepPath, String stepType, Schema schema, StateMachine stateMachine, int transitionId, String viewName, boolean hasAttachment) {
        Event newEvent = new Event(this.mItemPath, agentPath, delegatePath, agentRole, stepName, stepPath, stepType, stateMachine, transitionId, hasAttachment);
        newEvent.addOutcomeDetails(schema, viewName);
        return this.storeNewEvent(newEvent);
    }

    public Event addEvent(AgentPath agentPath, AgentPath delegatePath, String agentRole, String stepName, String stepPath, String stepType, StateMachine stateMachine, int transitionId, String timeString) throws InvalidDataException {
        Event newEvent = new Event(this.mItemPath, agentPath, delegatePath, agentRole, stepName, stepPath, stepType, stateMachine, transitionId);
        newEvent.setTimeString(timeString);
        return this.storeNewEvent(newEvent);
    }

    public Event addEvent(AgentPath agentPath, AgentPath delegatePath, String agentRole, String stepName, String stepPath, String stepType, Schema schema, StateMachine stateMachine, int transitionId, String viewName, String timeString) throws InvalidDataException {
        Event newEvent = new Event(this.mItemPath, agentPath, delegatePath, agentRole, stepName, stepPath, stepType, stateMachine, transitionId);
        newEvent.addOutcomeDetails(schema, viewName);
        newEvent.setTimeString(timeString);
        return this.storeNewEvent(newEvent);
    }

    public boolean containsKey(Integer id) {
        return this.containsKey((Object)id);
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        try {
            int id = key instanceof String ? Integer.valueOf((String)key).intValue() : ((Integer)key).intValue();
            return id >= 0 && id <= this.getLastId();
        }
        catch (Exception e) {
            log.error("containsKey() - Could not read key:{}", key, (Object)e);
            return false;
        }
    }
}

